/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.dbimport.CommitOnExecuteStatement;
import com.intellij.database.remote.dbimport.DefaultBatchPreparedStatement;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdba.impl.RemoteFacadeImpl;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteCallableStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteDatabaseMetaDataImpl;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteSavepointImpl;
import com.intellij.database.remote.jdbc.impl.RemoteStatementImpl;
import com.intellij.database.remote.jdbc.impl.SingleConnectionDataSource;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.MssqlExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.MssqlIntermediateFacade;
import org.jetbrains.dekaf.jdbc.MysqlExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.MysqlIntermediateFacade;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.OracleIntermediateFacade;
import org.jetbrains.dekaf.jdbc.PostgresExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.PostgresIntermediateFacade;
import org.jetbrains.dekaf.jdbc.SqliteExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.SqliteIntermediateFacade;
import org.jetbrains.dekaf.jdbc.SybaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.SybaseIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseIntermediateFacade;

public class RemoteConnectionImpl
extends JdbcRemoteObject
implements RemoteConnection {
    private final Connection myDelegate;
    private AtomicInteger myNextSavepointId = new AtomicInteger();
    private final Map<Integer, Savepoint> myIdToSavepoint = ContainerUtil.createConcurrentWeakValueMap();

    protected RemoteConnectionImpl(Connection delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteConnectionImpl wrap(Connection delegate) {
        return delegate == null ? null : new RemoteConnectionImpl(delegate);
    }

    @Override
    public RemoteFacade jpdaFacade(final String rdbms) throws RemoteException {
        Connection connection = this.myDelegate;
        if (System.getProperty("dekaf.workaround") != null) {
            connection = RemoteConnectionImpl.createUnclosableConnection(this.myDelegate);
        }
        SingleConnectionDataSource ds = new SingleConnectionDataSource(connection);
        Object facade = Postgres.RDBMS.code.equals(rdbms) ? new PostgresIntermediateFacade((DataSource)ds, 1, (DBExceptionRecognizer)PostgresExceptionRecognizer.INSTANCE) : (Oracle.RDBMS.code.equals(rdbms) ? new OracleIntermediateFacade((DataSource)ds, 1, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE) : (Mssql.RDBMS.code.equals(rdbms) ? new MssqlIntermediateFacade((DataSource)ds, 1, (DBExceptionRecognizer)MssqlExceptionRecognizer.INSTANCE) : (Sybase.RDBMS.code.equals(rdbms) ? new SybaseIntermediateFacade((DataSource)ds, 1, (DBExceptionRecognizer)SybaseExceptionRecognizer.INSTANCE) : (Mysql.RDBMS.code.equals(rdbms) ? new MysqlIntermediateFacade((DataSource)ds, 1, (DBExceptionRecognizer)MysqlExceptionRecognizer.INSTANCE) : (Sqlite.RDBMS.code.equals(rdbms) ? new SqliteIntermediateFacade((DataSource)ds, 1, (DBExceptionRecognizer)SqliteExceptionRecognizer.INSTANCE) : new UnknownDatabaseIntermediateFacade(ds, 1, (DBExceptionRecognizer)UnknownDatabaseExceptionRecognizer.INSTANCE){

            @NotNull
            public Rdbms rdbms() {
                Rdbms rdbms2 = Rdbms.of((String)rdbms);
                if (rdbms2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl$1", "rdbms"));
                }
                return rdbms2;
            }
        })))));
        return (RemoteFacade)((Object)this.export((Remote)((Object)new RemoteFacadeImpl((PrimeIntermediateFacade)facade))));
    }

    @Deprecated
    @NotNull
    public static Connection createUnclosableConnection(final @NotNull Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl", "createUnclosableConnection"));
        }
        Connection connection2 = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){
            boolean isClosed = false;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args == null) {
                    if ("close".equals(method.getName())) {
                        this.isClosed = true;
                        return null;
                    }
                    if ("isClosed".equals(method.getName())) {
                        return this.isClosed || (Boolean)method.invoke((Object)connection, new Object[0]) != false;
                    }
                    if ("hashCode".equals(method.getName())) {
                        return this.hashCode();
                    }
                }
                if (args != null && args.length == 1 && "equals".equals(method.getName())) {
                    return proxy == args[0];
                }
                return method.invoke((Object)connection, args);
            }
        });
        if (connection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl", "createUnclosableConnection"));
        }
        return connection2;
    }

    public String getCastToClassName() {
        return Connection.class.getName();
    }

    @Override
    public void setReadOnly(boolean p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setReadOnly(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isReadOnly();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void close() throws RemoteException, SQLException {
        try {
            this.unexportChildren();
            this.myDelegate.close();
            this.unreferenced();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isClosed() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isClosed();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isValid(int timeout) throws RemoteException, SQLException {
        try {
            return this.myDelegate.isValid(timeout);
        }
        catch (NoSuchMethodError e) {
            return !this.myDelegate.isClosed();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws RemoteException, SQLException {
        try {
            return this.wrapSqlWarning(this.myDelegate.getWarnings());
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public List<SQLWarning> getAllWarnings() throws RemoteException, SQLException {
        try {
            List<SQLWarning> warnings = this.getAllWarnings(this.myDelegate.getWarnings());
            this.myDelegate.clearWarnings();
            return warnings;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void commit() throws RemoteException, SQLException {
        try {
            this.myDelegate.commit();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void clearWarnings() throws RemoteException, SQLException {
        try {
            this.myDelegate.clearWarnings();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteDatabaseMetaData getMetaData() throws RemoteException, SQLException {
        try {
            return (RemoteDatabaseMetaData)((Object)this.export((Remote)((Object)RemoteDatabaseMetaDataImpl.wrap(this.myDelegate.getMetaData()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement createStatement(int p1, int p2, int p3) throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(this.myDelegate.createStatement(p1, p2, p3)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement createStatement(int p1, int p2) throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(this.myDelegate.createStatement(p1, p2)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement createStatement() throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(this.myDelegate.createStatement()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getAutoCommit();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getCatalog() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getCatalog();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getHoldability() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getHoldability();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getSchema() throws RemoteException, SQLException {
        try {
            return (String)ReflectionHelper.tryInvokeMethod(this.myDelegate, "getSchema", ArrayUtil.EMPTY_CLASS_ARRAY, ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTransactionIsolation();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Map getTypeMap() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTypeMap();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String nativeSQL(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.nativeSQL(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteCallableStatement prepareCall(String p1, int p2, int p3, int p4) throws RemoteException, SQLException {
        try {
            return (RemoteCallableStatement)((Object)this.export((Remote)((Object)RemoteCallableStatementImpl.wrap(this.myDelegate.prepareCall(p1, p2, p3, p4)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteCallableStatement prepareCall(String p1, int p2, int p3) throws RemoteException, SQLException {
        try {
            return (RemoteCallableStatement)((Object)this.export((Remote)((Object)RemoteCallableStatementImpl.wrap(this.myDelegate.prepareCall(p1, p2, p3)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteCallableStatement prepareCall(String p1) throws RemoteException, SQLException {
        try {
            return (RemoteCallableStatement)((Object)this.export((Remote)((Object)RemoteCallableStatementImpl.wrap(this.myDelegate.prepareCall(p1)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int p2) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(this.myDelegate.prepareStatement(p1, p2)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int[] p2) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(this.myDelegate.prepareStatement(p1, p2)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(this.myDelegate.prepareStatement(p1)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int p2, int p3, int p4) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(this.myDelegate.prepareStatement(p1, p2, p3, p4)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, int p2, int p3) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(this.myDelegate.prepareStatement(p1, p2, p3)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemotePreparedStatement prepareStatement(String p1, String[] p2) throws RemoteException, SQLException {
        try {
            return (RemotePreparedStatement)((Object)this.export((Remote)((Object)RemotePreparedStatementImpl.wrap(this.myDelegate.prepareStatement(p1, p2)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteBatchPreparedStatement prepareBatchStatement(RemoteBatchPreparedStatementImpl.Configuration configuration) throws RemoteException, SQLException {
        try {
            PreparedStatement delegate = this.myDelegate.prepareStatement(configuration.sql);
            PreparedStatement oneLineDelegate = this.myDelegate.prepareStatement(configuration.oneLineSql);
            RemoteBatchPreparedStatementImpl statement = this.getStatement(configuration, delegate, oneLineDelegate);
            return (RemoteBatchPreparedStatement)((Object)this.export((Remote)((Object)statement)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @NotNull
    private RemoteBatchPreparedStatementImpl getStatement(@NotNull RemoteBatchPreparedStatementImpl.Configuration configuration, @NotNull PreparedStatement delegate, @NotNull PreparedStatement oneLineDelegate) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl", "getStatement"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl", "getStatement"));
        }
        if (oneLineDelegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oneLineDelegate", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl", "getStatement"));
        }
        RemoteBatchPreparedStatementImpl remoteBatchPreparedStatementImpl = configuration.useSavepoints ? new DefaultBatchPreparedStatement(configuration, delegate, oneLineDelegate, this.myDelegate) : new CommitOnExecuteStatement(configuration, delegate, oneLineDelegate, this.myDelegate);
        if (remoteBatchPreparedStatementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/impl/RemoteConnectionImpl", "getStatement"));
        }
        return remoteBatchPreparedStatementImpl;
    }

    @Override
    public void releaseSavepoint(RemoteSavepoint p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.releaseSavepoint(this.getOriginalSavepoint(p1));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void rollback() throws RemoteException, SQLException {
        try {
            this.myDelegate.rollback();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void rollback(RemoteSavepoint p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.rollback(this.getOriginalSavepoint(p1));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setAutoCommit(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setCatalog(String p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setCatalog(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setHoldability(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setHoldability(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteSavepoint setSavepoint() throws RemoteException, SQLException {
        try {
            return (RemoteSavepoint)((Object)this.export((Remote)((Object)this.wrapSavepoint(this.myDelegate.setSavepoint()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteSavepoint setSavepoint(String p1) throws RemoteException, SQLException {
        try {
            return (RemoteSavepoint)((Object)this.export((Remote)((Object)this.wrapSavepoint(this.myDelegate.setSavepoint(p1)))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setTransactionIsolation(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setTransactionIsolation(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setTypeMap(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws RemoteException, SQLException {
        try {
            this.myDelegate.setClientInfo(name, value);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private Savepoint getOriginalSavepoint(RemoteSavepoint remoteSavepoint) throws RemoteException {
        return this.myIdToSavepoint.get(remoteSavepoint.getRemoteSavepointId());
    }

    private RemoteSavepoint wrapSavepoint(Savepoint savepoint) {
        int remoteSavepointId = this.myNextSavepointId.getAndIncrement();
        RemoteSavepointImpl wrapped = RemoteSavepointImpl.wrap(savepoint, remoteSavepointId);
        this.myIdToSavepoint.put(remoteSavepointId, savepoint);
        return wrapped;
    }
}

