/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TestMethod
extends TestObject {
    public TestMethod(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = this.createDefaultJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        javaParameters.getProgramParametersList().add(data.getMainClassName() + "," + data.getMethodNameWithSignature());
        return javaParameters;
    }

    protected JavaParameters createDefaultJavaParameters() throws ExecutionException {
        return super.createJavaParameters();
    }

    @Override
    @Nullable
    protected String getPreferredRunner(GlobalSearchScope globalSearchScope) {
        PsiMethod[] methods;
        JUnitConfiguration.Data data;
        Project project = this.getConfiguration().getProject();
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)project, (String)(data = this.getConfiguration().getPersistentData()).getMainClassName(), (GlobalSearchScope)globalSearchScope);
        if (psiClass == null) {
            return null;
        }
        if (JUnitUtil.isJUnit5TestClass((PsiClass)psiClass, (boolean)false)) {
            return "-junit5";
        }
        if (JUnitUtil.isJUnit4TestClass((PsiClass)psiClass)) {
            return "-junit4";
        }
        String methodName = data.getMethodName();
        for (PsiMethod method : methods = psiClass.findMethodsByName(methodName, true)) {
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            return "-junit4";
        }
        return "-junit3";
    }

    @Override
    public String suggestActionName() {
        return ProgramRunnerUtil.shortenName((String)this.getConfiguration().getPersistentData().METHOD_NAME, (int)2) + "()";
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, final JUnitConfiguration configuration) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (!method.getName().equals(configuration.getPersistentData().getMethodName())) {
                return null;
            }
            if (!method.getContainingClass().equals(configuration.myClass.getPsiElement())) {
                return null;
            }
            class Listener
            extends RefactoringElementAdapter
            implements UndoRefactoringElementListener {
                Listener() {
                }

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/junit/TestMethod$1Listener", "elementRenamedOrMoved"));
                    }
                    boolean generatedName = configuration.isGeneratedName();
                    configuration.getPersistentData().setTestMethod((Location<PsiMethod>)PsiLocation.fromPsiElement((PsiElement)((PsiMethod)newElement)));
                    if (generatedName) {
                        configuration.setGeneratedName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/junit/TestMethod$1Listener", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/execution/junit/TestMethod$1Listener", "undoElementMovedOrRenamed"));
                    }
                    int methodIdx = oldQualifiedName.indexOf("#") + 1;
                    if (methodIdx <= 0 || methodIdx >= oldQualifiedName.length()) {
                        return;
                    }
                    boolean generatedName = configuration.isGeneratedName();
                    configuration.getPersistentData().METHOD_NAME = oldQualifiedName.substring(methodIdx);
                    if (generatedName) {
                        configuration.setGeneratedName();
                    }
                }
            }
            return new Listener();
        }
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, configuration.myClass);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        if (testMethod == null) {
            return false;
        }
        if (testClass == null) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        return Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass), (String)data.getMainClassName()) && Comparing.equal((String)JUnitConfiguration.Data.getMethodPresentation(testMethod), (String)data.getMethodNameWithSignature());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        String testClass = data.getMainClassName();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(testClass, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        String methodName = data.getMethodName();
        if (methodName == null || methodName.trim().length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0]));
        }
        JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(psiClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
            if (filter.value(method)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{methodName}));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.junit.runner.RunWith", (boolean)true) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!psiClass.isInheritor(testCaseClass, true)) {
                    throw new RuntimeConfigurationError(ExecutionBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{testClass}));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"junit.jar.not.found.in.module.class.path.error.message", (Object[])new Object[]{configurationModule.getModuleName()}));
            }
        }
    }
}

