/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.execution.junit.codeInsight.references.MethodSourceReference;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitReferenceContributor
extends PsiReferenceContributor {
    private static PsiElementPattern.Capture<PsiLiteral> getElementPattern(String annotation, String paramName) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteral.class).and((ElementPattern)new FilterPattern((ElementFilter)new TestAnnotationFilter(annotation, paramName)));
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(JUnitReferenceContributor.getElementPattern("org.junit.jupiter.params.provider.MethodSource", "names"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$1", "getReferencesByElement"));
                }
                MethodSourceReference[] methodSourceReferenceArray = new MethodSourceReference[]{new MethodSourceReference((PsiLiteral)element)};
                if (methodSourceReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$1", "getReferencesByElement"));
                }
                return methodSourceReferenceArray;
            }
        });
        registrar.registerReferenceProvider(JUnitReferenceContributor.getElementPattern("org.junit.jupiter.params.provider.CsvFileSource", "resources"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$2", "getReferencesByElement"));
                }
                FileReference[] fileReferenceArray = FileReferenceSet.createSet((PsiElement)element, (boolean)false, (boolean)false, (boolean)false).getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$2", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
    }

    private static class TestAnnotationFilter
    implements ElementFilter {
        private final String myAnnotation;
        private final String myParameterName;

        public TestAnnotationFilter(String annotation, @NotNull @NonNls String parameterName) {
            if (parameterName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "com/intellij/execution/junit/codeInsight/references/JUnitReferenceContributor$TestAnnotationFilter", "<init>"));
            }
            this.myAnnotation = annotation;
            this.myParameterName = parameterName;
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)context, PsiNameValuePair.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiStatement.class});
            if (pair == null) {
                return false;
            }
            if (!this.myParameterName.equals(pair.getName())) {
                return false;
            }
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class);
            if (annotation == null) {
                return false;
            }
            return this.myAnnotation.equals(annotation.getQualifiedName());
        }

        public boolean isClassAcceptable(Class hintClass) {
            return PsiLiteral.class.isAssignableFrom(hintClass);
        }
    }
}

