/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSourceReference
extends PsiReferenceBase<PsiLiteral> {
    public MethodSourceReference(PsiLiteral element) {
        super((PsiElement)element, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/junit/codeInsight/references/MethodSourceReference", "bindToElement"));
        }
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        return super.bindToElement(element);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        if (cls != null) {
            PsiMethod[] methods = cls.findMethodsByName(this.getValue(), false);
            return Arrays.stream(methods).filter(MethodSourceReference::staticNoParams).findFirst().orElse(methods.length == 0 ? null : methods[0]);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        if (topLevelClass != null) {
            PsiMethod[] methods;
            PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
            for (PsiMethod method : methods = topLevelClass.getMethods()) {
                if (current != null && method.getName().equals(current.getName()) || !MethodSourceReference.staticNoParams(method)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)method);
                list.add(builder.withAutoCompletionPolicy(AutoCompletionPolicy.SETTINGS_DEPENDENT));
            }
        }
        Object[] objectArray = list.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInsight/references/MethodSourceReference", "getVariants"));
        }
        return objectArray;
    }

    private static boolean staticNoParams(PsiMethod method) {
        return method.hasModifierProperty("static") && method.getParameterList().getParametersCount() == 0;
    }
}

