/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.images;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.util.CssUriUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.URLUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssExtractImageFromDataUriIntention
extends CssBaseElementAtCaretIntentionAction {
    @Nullable
    private VirtualFileWrapper myFileToExtract;

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "isAvailable"));
        }
        return super.isAvailable(project, editor, element) && CssUriUtil.isDataUri(PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssUri.class}));
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "invoke"));
        }
        final CssUri cssUri = (CssUri)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssUri.class});
        if (cssUri != null && CssUriUtil.isDataUri((PsiElement)cssUri)) {
            RunResult result;
            VirtualFileWrapper savedFile;
            String cssUriValue = cssUri.getValue();
            final byte[] imageBytes = URLUtil.getBytesFromDataUri((String)cssUriValue);
            if (imageBytes == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.extract.image.cannot.read.data.uri", (Object[])new Object[0]), (String)"", null);
                return;
            }
            MediaType mediaType = CssUtil.getMediaTypeFromDataUri(cssUriValue);
            if (mediaType == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.extract.image.cannot.define.image.type", (Object[])new Object[0]), (String)"", null);
                return;
            }
            if (this.myFileToExtract == null) {
                String fileExtension = mediaType.subtype().replace('+', '.');
                FileSaverDescriptor descriptor = new FileSaverDescriptor(CssBundle.message((String)"css.intentions.extract.image.save.dialog.title", (Object[])new Object[0]), "", new String[]{fileExtension});
                FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
                savedFile = saverDialog.save(project.getBaseDir(), null);
            } else {
                savedFile = this.myFileToExtract;
            }
            if (savedFile != null && !((Boolean)(result = VfsUtilCore.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir()), (File)savedFile.getFile(), (boolean)true) ? new WriteCommandAction<Boolean>(project, CssBundle.message((String)"css.intentions.extract.image", (Object[])new Object[0]), new PsiFile[]{element.getContainingFile()}){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    PsiFile createdPsiFile;
                    PsiDirectory directory;
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention$1", "run"));
                    }
                    result.setResult((Object)Boolean.FALSE);
                    VirtualFile createdFile = savedFile.getVirtualFile();
                    CssExtractImageFromDataUriIntention.deleteFileIfExists(createdFile, project);
                    File createdIoFile = savedFile.getFile();
                    VirtualFile virtualDirectory = VfsUtil.findFileByIoFile((File)createdIoFile.getParentFile(), (boolean)true);
                    if (virtualDirectory != null && (directory = PsiManager.getInstance((Project)project).findDirectory(virtualDirectory)) != null && (createdFile = (createdPsiFile = directory.createFile(createdIoFile.getName())).getVirtualFile()) != null) {
                        createdFile.setBinaryContent(imageBytes);
                        CssExtractImageFromDataUriIntention.replaceCssUriWithReferenceToFile(cssUri, createdFile, project);
                        result.setResult((Object)Boolean.TRUE);
                    }
                }
            }.execute() : new WriteCommandAction<Boolean>(project, CssBundle.message((String)"css.intentions.extract.image", (Object[])new Object[0]), new PsiFile[]{element.getContainingFile()}){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention$2", "run"));
                    }
                    result.setResult((Object)Boolean.FALSE);
                    VirtualFile file = savedFile.getVirtualFile(true);
                    if (file != null) {
                        file.setBinaryContent(imageBytes);
                        cssUri.setValue(Strings.nullToEmpty((String)file.getCanonicalPath()));
                        result.setResult((Object)Boolean.TRUE);
                    }
                }
            }.execute()).getResultObject()).booleanValue()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.extract.image.cannot.save.file", (Object[])new Object[0]), (String)"", null);
            }
        }
    }

    public void setFileToExtract(@Nullable VirtualFileWrapper fileToExtract) {
        this.myFileToExtract = fileToExtract;
    }

    private static void deleteFileIfExists(VirtualFile createdFile, Project project) {
        PsiFile existingFile;
        if (createdFile != null && (existingFile = PsiManager.getInstance((Project)project).findFile(createdFile)) != null) {
            existingFile.delete();
        }
    }

    private static void replaceCssUriWithReferenceToFile(@NotNull CssUri cssUri, @NotNull VirtualFile createdFile, @NotNull Project project) {
        if (cssUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssUri", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "replaceCssUriWithReferenceToFile"));
        }
        if (createdFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdFile", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "replaceCssUriWithReferenceToFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "replaceCssUriWithReferenceToFile"));
        }
        String path = VfsUtilCore.getRelativePath((VirtualFile)createdFile, (VirtualFile)project.getBaseDir(), (char)'/');
        if (path != null) {
            PsiElement newValueElement = cssUri.setValue("/" + path);
            PsiFile referenceTarget = PsiManager.getInstance((Project)project).findFile(createdFile);
            if (newValueElement != null && referenceTarget != null) {
                CssUtil.rebindFileReference(newValueElement, referenceTarget);
            }
        }
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.intentions.extract.image", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.extract.image", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

