/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class CssColorGutterTooltipBuilder {
    private final StringBuilder stringBuilder = new StringBuilder();

    public CssColorGutterTooltipBuilder startColorPreviewCode() {
        this.stringBuilder.append("<html><body>");
        this.stringBuilder.append("<table style=\"padding: 2px 0;\" cellspacing=\"2\">");
        return this;
    }

    public CssColorGutterTooltipBuilder finishColorPreviewCode() {
        this.stringBuilder.append("</table>");
        this.stringBuilder.append("</body></html>");
        return this;
    }

    public CssColorGutterTooltipBuilder appendOneColoredProperty(@NotNull String propertyName, @NotNull Color color) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/browse/CssColorGutterTooltipBuilder", "appendOneColoredProperty"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/browse/CssColorGutterTooltipBuilder", "appendOneColoredProperty"));
        }
        this.stringBuilder.append("<tr><td valign=\"bottom\">").append(propertyName).append(":</td><td style=\"background-color:");
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        String textColor = hsb[2] > 0.7f ? "black" : "white";
        String hex = CssPsiColorUtil.toHexColor(color);
        this.stringBuilder.append(hex);
        this.stringBuilder.append("; color:").append(textColor).append("; font-family: monospaced;\" valign=\"bottom\">").append(hex).append("</td></tr>");
        return this;
    }

    public String build() {
        return this.stringBuilder.toString();
    }
}

