/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.css.CssTermType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssTermTypeImpl
implements CssTermType {
    private final String myName;
    private static final Map<String, CssTermType> registeredTypes = ContainerUtil.newHashMap();

    public CssTermTypeImpl(@NonNls String debugName) {
        this.myName = debugName;
        registeredTypes.put(this.myName, this);
    }

    @NotNull
    public static CssTermType find(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssTermTypeImpl", "find"));
        }
        CssTermType type = registeredTypes.get(name);
        if (type == null) {
            throw new RuntimeException("Can't find '" + name + "' term type");
        }
        CssTermType cssTermType = type;
        if (cssTermType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTermTypeImpl", "find"));
        }
        return cssTermType;
    }

    public String toString() {
        return this.myName;
    }
}

