/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssValueImportedAlias;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueImportedAliasImpl
extends CssElementImpl
implements CssValueImportedAlias {
    public CssValueImportedAliasImpl() {
        super(CssElementTypes.CSS_VALUE_IMPORTED_ALIAS);
    }

    @Nullable
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier == null ? null : identifier.getText();
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement[] children = this.getChildrenAsPsiElements(CssElementTypes.CSS_IDENT, ARRAY_FACTORY);
        if (children.length == 1 && children[0].getNode().getElementType() == CssElementTypes.CSS_IDENT) {
            return children[0];
        }
        if (children.length == 3 && "as".equals(children[1].getText())) {
            return children[2];
        }
        return null;
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextOffset() : super.getTextOffset();
    }

    public int getLineNumber() {
        PsiUtilCore.ensureValid((PsiElement)this);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getContainingFile());
        return document != null ? document.getLineNumber(this.getTextOffset()) + 1 : -1;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssValueImportedAliasImpl", "setName"));
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            CssPsiUtil.replaceToken((PsiElement)identifier, (String)name);
        }
        CssValueImportedAliasImpl cssValueImportedAliasImpl = this;
        if (cssValueImportedAliasImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssValueImportedAliasImpl", "setName"));
        }
        return cssValueImportedAliasImpl;
    }

    public ItemPresentation getPresentation() {
        PsiElement[] children = this.getChildrenAsPsiElements(CssElementTypes.CSS_IDENT, ARRAY_FACTORY);
        final String text = children.length == 1 && children[0].getNode().getElementType() == CssElementTypes.CSS_IDENT ? children[0].getText() : (children.length == 3 && "as".equals(children[1].getText()) ? children[0].getText() + " as " + children[2].getText() : null);
        if (text == null) {
            return super.getPresentation();
        }
        String location = null;
        PsiElement sibling = this.getParent().getNextSibling();
        if (sibling instanceof PsiWhiteSpace) {
            sibling = sibling.getNextSibling();
        }
        if (sibling != null && sibling.getNode().getElementType() == CssElementTypes.CSS_RPAREN) {
            sibling = sibling.getNextSibling();
        }
        if (sibling instanceof PsiWhiteSpace) {
            sibling = sibling.getNextSibling();
        }
        if (sibling != null && sibling.getNode().getElementType() == CssElementTypes.CSS_IDENT && sibling.textMatches((CharSequence)"from")) {
            if ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                sibling = sibling.getNextSibling();
            }
            if (sibling != null) {
                location = sibling.getText();
            }
        }
        final String finalLocation = location;
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssValueImportedAliasImpl$1", "getPresentableText"));
                }
                return string;
            }

            @Nullable
            public String getLocationString() {
                return finalLocation;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssValueImportedAliasImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitValueImportedAlias((CssValueImportedAlias)this);
        } else {
            super.accept(visitor);
        }
    }
}

