/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssValueOwnerDescriptorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMediaFeatureDescriptorImpl
extends CssValueOwnerDescriptorImpl
implements CssMediaFeatureDescriptor {
    @Nullable
    private final String myAppliesToValue;
    private final CssMediaGroup[] myMediaGroups;

    public CssMediaFeatureDescriptorImpl(@Nullable String appliesToValue, @NotNull CssMediaGroup[] mediaGroups, @NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptor valueDescriptor) {
        if (mediaGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaGroups", "com/intellij/psi/css/impl/descriptor/CssMediaFeatureDescriptorImpl", "<init>"));
        }
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/CssMediaFeatureDescriptorImpl", "<init>"));
        }
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/psi/css/impl/descriptor/CssMediaFeatureDescriptorImpl", "<init>"));
        }
        super(commonDescriptorData, valueDescriptor);
        this.myAppliesToValue = appliesToValue;
        this.myMediaGroups = mediaGroups;
    }

    @NotNull
    public CssMediaGroup[] getMediaGroups() {
        if (this.myMediaGroups == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssMediaFeatureDescriptorImpl", "getMediaGroups"));
        }
        return this.myMediaGroups;
    }

    @Nullable
    public String getAppliesToValue() {
        return this.myAppliesToValue;
    }

    @Override
    protected void fillWithAttributesDescription(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/css/impl/descriptor/CssMediaFeatureDescriptorImpl", "fillWithAttributesDescription"));
        }
        super.fillWithAttributesDescription(builder);
        String appliesToValue = this.getAppliesToValue();
        if (!StringUtil.isEmpty((String)appliesToValue)) {
            builder.append("Applies to: ").append(appliesToValue).append("<br/>");
        }
    }

    @Override
    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.media.feature", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssMediaFeatureDescriptorImpl", "getElementTypeName"));
        }
        return string;
    }
}

