/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.util.ColorSampleLookupValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssColorValue
extends CssLookupValue {
    private boolean myAllColorsAreStandard;

    public CssColorValue() {
        this(true);
    }

    protected CssColorValue(boolean allColorsAreStandard) {
        super(CssTableValue.Type.OR, CssTermTypes.COLOR);
        this.addChild(new CssPropertyValueImpl(CssCompletionUtil.lookupForUserColorLookup()));
        for (ColorSampleLookupValue color : ColorSampleLookupValue.getColors()) {
            this.myAllColorsAreStandard = allColorsAreStandard;
            if (this.myAllColorsAreStandard) {
                String colorName = color.getName();
                this.addChild(new MyCssPropertyValueImpl(new ColorSampleLookupValue(colorName, color.getValue(), true)));
                continue;
            }
            this.addChild(new MyCssPropertyValueImpl(color));
        }
    }

    @Override
    @NotNull
    public List<? extends CssPropertyValue> getDynamicVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/psi/css/impl/util/table/CssColorValue", "getDynamicVariants"));
        }
        List children = this.getChildren();
        Set<String> popularColors = CssColorValue.getPopularColors(contextElement);
        ASTNode contextElementNode = contextElement.getNode();
        boolean afterSharp = contextElementNode != null && contextElementNode.getElementType() == CssElementTypes.CSS_HASH;
        HashMap popularColorNames = afterSharp ? null : new HashMap(popularColors.size());
        ArrayList<CssPropertyValue> result = new ArrayList<CssPropertyValue>(children.size() + popularColors.size());
        for (CssPropertyValue propertyValue : children) {
            String colorName;
            ColorSampleLookupValue cslValue;
            String hashValue;
            Object variant;
            if (popularColorNames != null && (variant = propertyValue.getValue()) instanceof ColorSampleLookupValue && popularColors.contains(hashValue = (cslValue = (ColorSampleLookupValue)variant).getValue()) && (colorName = cslValue.getName()) != null) {
                popularColorNames.put(hashValue, colorName);
                continue;
            }
            result.add(propertyValue);
        }
        for (String colorHash : popularColors) {
            String colorName = popularColorNames != null ? (String)popularColorNames.get(colorHash) : null;
            result.add(new MyCssPropertyValueImpl(new MyPopularColorLookupValue(colorName, colorHash, this.myAllColorsAreStandard)));
        }
        ArrayList<CssPropertyValue> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssColorValue", "getDynamicVariants"));
        }
        return arrayList;
    }

    private static Set<String> getPopularColors(PsiElement psiElement) {
        HashSet result = new HashSet();
        HashSet resultLower = new HashSet();
        FileBasedIndex fbIndex = FileBasedIndex.getInstance();
        Collection allCssNames = fbIndex.getAllKeys(CssIndex.CSS_INDEX, psiElement.getProject());
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesScope().uniteWith(module.getModuleContentWithDependenciesScope()) : GlobalSearchScope.projectScope((Project)psiElement.getProject());
        for (String cssName : allCssNames) {
            String color;
            boolean b;
            if (CssIndexValue.keyType(cssName) != CssIndexValue.COLOR || (b = FileBasedIndex.getInstance().processValues(CssIndex.CSS_INDEX, (Object)cssName, null, (file, value) -> value.isEmpty(), scope)) || !resultLower.add((color = "#" + cssName).toLowerCase(Locale.US))) continue;
            result.add(color);
        }
        return result;
    }

    public static class MyPopularColorLookupValue
    extends ColorSampleLookupValue {
        public MyPopularColorLookupValue(String name, String value, boolean isStandard) {
            super(name, value, isStandard);
        }
    }

    private class MyCssPropertyValueImpl
    extends CssPropertyValueImpl {
        public MyCssPropertyValueImpl(ColorSampleLookupValue color) {
            super(color);
        }

        @Override
        public boolean isValueBelongs(@Nullable PsiElement element) {
            return CssColorValue.this.isValueBelongs(element);
        }
    }
}

