/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlCompletionContributor;
import com.intellij.freemarker.FtlPsiTypeCanonicalLookupElement;
import com.intellij.freemarker.inspections.DefineImplicitVariableIntention;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DefineImplicitToplevelVariableIntention
extends DefineImplicitVariableIntention {
    protected DefineImplicitToplevelVariableIntention(String text, boolean global) {
        super(text, global);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("add.implicit.toplevel.variable.fix.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/DefineImplicitToplevelVariableIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailableOnCall(FtlQualifiedReference expr) {
        return expr.getReferenceQualifier() == null;
    }

    @Override
    protected List<String> getNameVariants(FtlQualifiedReference reference) {
        return Collections.singletonList("");
    }

    @Override
    protected Expression createTypeExpression(FtlQualifiedReference reference) {
        final Couple<Set<String>> pair = FtlCompletionContributor.suggestClassesWithMember(reference);
        final GlobalSearchScope scope = reference.getElement().getResolveScope();
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return null;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
                ArrayList<FtlPsiTypeCanonicalLookupElement> result = new ArrayList<FtlPsiTypeCanonicalLookupElement>(((Set)pair.first).size() + ((Set)pair.second).size());
                for (String string : (Set)pair.first) {
                    result.add(new FtlPsiTypeCanonicalLookupElement((PsiType)facade.getElementFactory().createTypeByFQClassName(string, scope), false));
                }
                for (String string : (Set)pair.second) {
                    result.add(new FtlPsiTypeCanonicalLookupElement((PsiType)facade.getElementFactory().createTypeByFQClassName(string, scope), true));
                }
                Collections.sort(result, (o1, o2) -> o1.getLookupString().compareToIgnoreCase(o2.getLookupString()));
                return result.toArray(new LookupElement[result.size()]);
            }
        };
    }

    public static class LocalExternal
    extends DefineImplicitToplevelVariableIntention {
        public LocalExternal() {
            super(FreeMarkerBundle.message("add.implicit.toplevel.variable.fix.name.external", new Object[0]), true);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitToplevelVariableIntention$LocalExternal", "invoke"));
            }
            this.chooseTargetFile(file, editor);
        }
    }

    public static class Local
    extends DefineImplicitToplevelVariableIntention {
        public Local() {
            super(FreeMarkerBundle.message("add.implicit.toplevel.variable.fix.name.local", new Object[0]), false);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitToplevelVariableIntention$Local", "invoke"));
            }
            this.addDeclaration(file, editor, file);
        }
    }
}

