/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertAnnotationInspection
extends BaseJavaLocalInspectionTool {
    private static final String DISPLAY_NAME = "Convert TestNG annotations to javadocs";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName != null && qualifiedName.startsWith("org.testng.annotations")) {
                    holder.registerProblem((PsiElement)annotation, ConvertAnnotationInspection.DISPLAY_NAME, new LocalQuickFix[]{new ConvertAnnotationQuickFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection", "getGroupDisplayName"));
        }
        return "TestNG";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if (DISPLAY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection", "getDisplayName"));
        }
        return DISPLAY_NAME;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ConvertAnnotations" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection", "getShortName"));
        }
        return "ConvertAnnotations";
    }

    private static class ConvertAnnotationQuickFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(ConvertAnnotationQuickFix.class);

        private ConvertAnnotationQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if (ConvertAnnotationInspection.DISPLAY_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection$ConvertAnnotationQuickFix", "getFamilyName"));
            }
            return ConvertAnnotationInspection.DISPLAY_NAME;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection$ConvertAnnotationQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/theoryinpractice/testng/inspection/ConvertAnnotationInspection$ConvertAnnotationQuickFix", "applyFix"));
            }
            PsiAnnotation annotation = (PsiAnnotation)descriptor.getPsiElement();
            PsiElement parent = annotation.getParent();
            if (parent instanceof PsiModifierList) {
                try {
                    PsiModifierListOwner element = (PsiModifierListOwner)parent.getParent();
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
                    PsiDocComment docComment = ((PsiDocCommentOwner)element).getDocComment();
                    if (docComment == null) {
                        docComment = factory.createDocCommentFromText("/**\n */");
                        docComment = (PsiDocComment)element.addBefore((PsiElement)docComment, parent);
                    }
                    StringBuffer text = new StringBuffer(ConvertAnnotationQuickFix.convertAnnotationClassToJavadocElement(annotation.getQualifiedName()));
                    PsiAnnotationParameterList list = annotation.getParameterList();
                    for (PsiNameValuePair pair : list.getAttributes()) {
                        text.append(' ');
                        if (pair.getName() != null) {
                            text.append(pair.getName());
                        } else {
                            text.append("value");
                        }
                        text.append(" = \"");
                        String parameterText = StringUtil.stripQuotesAroundValue((String)pair.getValue().getText());
                        if (parameterText.startsWith("{")) {
                            parameterText = parameterText.replaceAll("(\\{\\\"|\\\"\\}|\\\"\\w*\\s*\\,\\s*\\w*\\\")", " ").trim();
                        }
                        text.append(parameterText);
                        text.append('\"');
                    }
                    docComment.addAfter((PsiElement)factory.createDocTagFromText('@' + text.toString()), docComment.getFirstChild());
                    annotation.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static String convertAnnotationClassToJavadocElement(@NonNls String annotationFqn) {
            char[] chars = annotationFqn.replace("org.testng.annotations", "testng").toCharArray();
            boolean skippedFirst = false;
            StringBuffer sb = new StringBuffer();
            for (char aChar : chars) {
                if (aChar >= 'A' && aChar <= 'Z') {
                    if (skippedFirst) {
                        sb.append('-');
                    } else {
                        skippedFirst = true;
                    }
                }
                sb.append(String.valueOf(aChar));
            }
            return sb.toString().toLowerCase();
        }
    }
}

