/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.velocity.editorActions.VelocityTypedHandler;

public class VtlDirectiveInsertHandler
implements InsertHandler<LookupElement> {
    private final boolean myClosingBraceNeeded;
    private final boolean myParenthesesNeeded;

    public VtlDirectiveInsertHandler(boolean closingBraceNeeded, boolean parenthesesNeeded) {
        this.myClosingBraceNeeded = closingBraceNeeded;
        this.myParenthesesNeeded = parenthesesNeeded;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Document document = context.getDocument();
        CharSequence chars = document.getCharsSequence();
        int offsetToInsertOpeningParen = context.getTailOffset();
        if (this.myClosingBraceNeeded) {
            if (offsetToInsertOpeningParen == chars.length() || chars.charAt(offsetToInsertOpeningParen) != '}') {
                document.insertString(offsetToInsertOpeningParen, (CharSequence)"}");
                context.getEditor().getCaretModel().moveToOffset(offsetToInsertOpeningParen + 1);
            }
            ++offsetToInsertOpeningParen;
        }
        if (!this.myParenthesesNeeded) {
            return;
        }
        int wsEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)offsetToInsertOpeningParen, (String)" ");
        if (wsEnd < chars.length() && chars.charAt(wsEnd) == '(') {
            context.getEditor().getCaretModel().moveToOffset(wsEnd + 1);
            return;
        }
        VelocityTypedHandler.closeDirective(context.getEditor(), context.getFile(), offsetToInsertOpeningParen);
    }
}

