/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFileElementTypes;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage;
    private final Set<Language> myAllLanguages;

    public VtlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        this(manager, virtualFile, physical, VtlFileViewProvider.getSubstitutedLanguage(manager, virtualFile));
    }

    private VtlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, Language templateDataLanguage) {
        super(manager, virtualFile, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
        this.myAllLanguages = Collections.unmodifiableSet(ContainerUtil.newTroveSet((Object[])new Language[]{VtlLanguage.INSTANCE, this.myTemplateDataLanguage}));
    }

    @NotNull
    private static Language getSubstitutedLanguage(PsiManager manager, VirtualFile virtualFile) {
        Language language = VtlFileViewProvider.getTemplateDataLanguage(virtualFile, manager.getProject());
        Object object = language instanceof TemplateLanguage ? PlainTextLanguage.INSTANCE : LanguageSubstitutors.INSTANCE.substituteLanguage(language, virtualFile, manager.getProject());
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getSubstitutedLanguage"));
        }
        return object;
    }

    @NotNull
    public Language getBaseLanguage() {
        VtlLanguage vtlLanguage = VtlLanguage.INSTANCE;
        if (vtlLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getBaseLanguage"));
        }
        return vtlLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myAllLanguages;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/velocity/psi/files/VtlFileViewProvider", "createFile"));
        }
        if (lang == this.getBaseLanguage()) {
            return this.createFileInner(lang);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)this.createFileInner(lang);
            file.setContentElementType((IElementType)VtlFileElementTypes.TEMPLATE_DATA);
            return file;
        }
        return null;
    }

    private PsiFile createFileInner(Language lang) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
    }

    protected VtlFileViewProvider cloneInner(VirtualFile copy) {
        return new VtlFileViewProvider(this.getManager(), copy, false, this.myTemplateDataLanguage);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    @NotNull
    static Language getTemplateDataLanguage(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguage"));
        }
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile);
        Language language2 = language == null ? VtlFileViewProvider.getTemplateDataLanguageByExtension(virtualFile) : language;
        if (language2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguage"));
        }
        return language2;
    }

    @NotNull
    private static Language getTemplateDataLanguageByExtension(VirtualFile virtualFile) {
        String name = virtualFile.getName();
        int index2 = name.lastIndexOf(46);
        if (index2 < 3) {
            Language language = StdLanguages.HTML;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguageByExtension"));
            }
            return language;
        }
        int index1 = 1 + name.lastIndexOf(46, index2 - 1);
        if (index1 < 1) {
            Language language = StdLanguages.HTML;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguageByExtension"));
            }
            return language;
        }
        String dataLanguageFileExtension = name.substring(index1, index2);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(dataLanguageFileExtension);
        if (fileType instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguageByExtension"));
            }
            return language;
        }
        Language language = StdLanguages.HTML;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFileViewProvider", "getTemplateDataLanguageByExtension"));
        }
        return language;
    }
}

