/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.utils;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataSourceDetector
extends DataSourceDetector {
    @NonNls
    private final List<Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>> myProviders = ContainerUtil.newArrayList();

    public SpringDataSourceDetector() {
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"com.mchange.v2.c3p0.ComboPooledDataSource", SpringDataSourceDetector.provider("c3p0", "jdbcUrl", "user", "password", "driverClass")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.apache.commons.dbcp.BasicDataSource", SpringDataSourceDetector.provider("jakarta commons-dbcp", "url", "username", "password", "driverClassName")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.springframework.jdbc.datasource.DriverManagerDataSource", SpringDataSourceDetector.provider("spring", "url", "username", "password", "driverClassName")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.logicalcobwebs.proxool.ProxoolDataSource", SpringDataSourceDetector.provider("proxool", "driverUrl", "user", "password", "driver")));
    }

    protected static PairConsumer<DataSourceDetector.Builder, SpringBean> provider(String category, String urlProp, String userProp, String passwordProp, String driverProp) {
        return (builder, bean) -> {
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.URL, bean, urlProp);
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.USERNAME, bean, userProp);
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.PASSWORD, bean, passwordProp);
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.DRIVER_CLASS, bean, driverProp);
            builder.withName(bean.getBeanName()).commit(category, (Object)bean.getIdentifyingPsiElement());
        };
    }

    private static void collect(DataSourceDetector.Builder b, DataSourceDetector.Property p, SpringBean bean, String key) {
        SpringPropertyDefinition value = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)key);
        if (value == null) {
            return;
        }
        for (String s : PlaceholderUtils.getInstance().getValueVariants((SpringValueHolderDefinition)value)) {
            b.with(p, s);
        }
    }

    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/persistence/integration/utils/SpringDataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/spring/persistence/integration/utils/SpringDataSourceDetector", "collectDataSources"));
        }
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, project, GlobalSearchScope.allScope((Project)project));
        Set localXmlModels = springXmlCandidates.stream().map(file -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/persistence/integration/utils/SpringDataSourceDetector", "lambda$collectDataSources$1"));
            }
            return this.getLocalXmlModel(project, PsiManager.getInstance((Project)project), (VirtualFile)file);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (localXmlModels.isEmpty()) {
            return;
        }
        for (Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>> provider : this.myProviders) {
            PsiClass beanPsiClass = JavaPsiFacade.getInstance((Project)project).findClass((String)provider.getFirst(), GlobalSearchScope.allScope((Project)project));
            if (beanPsiClass == null) continue;
            for (LocalXmlModel localXmlModel : localXmlModels) {
                for (SpringBeanPointer pointer : SpringModelSearchers.findBeans((CommonSpringModel)localXmlModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)beanPsiClass))) {
                    CommonSpringBean bean = pointer.getSpringBean();
                    if (!(bean instanceof SpringBean)) continue;
                    ((PairConsumer)provider.getSecond()).consume((Object)builder, (Object)((SpringBean)bean));
                }
            }
        }
    }

    @Nullable
    public LocalXmlModel getLocalXmlModel(@NotNull Project project, PsiManager psiManager, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/persistence/integration/utils/SpringDataSourceDetector", "getLocalXmlModel"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        PsiFile psiFile = psiManager.findFile(file);
        return psiFile instanceof XmlFile ? SpringManager.getInstance((Project)project).getLocalSpringModel((XmlFile)psiFile, module) : null;
    }
}

