/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class MultipleBindingAnnotationsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("multiple.binding.annotations.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/MultipleBindingAnnotationsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public static boolean isBindingAnnotation(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement == null) {
            return false;
        }
        PsiElement element = referenceElement.resolve();
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass annotationClass = (PsiClass)element;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)annotationClass, (String)"com.google.inject.BindingAnnotation", (boolean)true);
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            PsiModifierList modifiers = variable.getModifierList();
            if (modifiers == null) {
                return;
            }
            PsiAnnotation[] annotations = modifiers.getAnnotations();
            int numBindingAnnotations = 0;
            for (PsiAnnotation annotation : annotations) {
                if (!MultipleBindingAnnotationsInspection.isBindingAnnotation(annotation)) continue;
                ++numBindingAnnotations;
            }
            if (numBindingAnnotations > 1) {
                this.registerVariableError(variable, new Object[0]);
            }
        }
    }
}

