/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.projection;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataProjectionAnnotator
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringDataProjectionAnnotator";
    }

    public String getName() {
        return "Spring Data Projections";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.InfrastructureBean;
    }

    @Nullable
    protected PsiElement getElementToProcess(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "getElementToProcess"));
        }
        if (psiElement instanceof PsiIdentifier) {
            return psiElement.getParent();
        }
        return null;
    }

    @NotNull
    protected static PsiElement getElementToAnnotate(@NotNull PsiElement psiElement) {
        PsiElement nameIdentifier;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "getElementToAnnotate"));
        }
        if (psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
            PsiElement psiElement2 = nameIdentifier;
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "getElementToAnnotate"));
            }
            return psiElement2;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "getElementToAnnotate"));
        }
        return psiElement3;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringDataUtil.hasSpringDataSupport(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        Set<PsiMember> members;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "collectNavigationMarkers"));
        }
        PsiElement element = this.getElementToProcess(psiElement);
        if (element instanceof PsiClass && ((PsiClass)element).isInterface()) {
            Set<PsiClass> domainClasses = SpringDataProjectionUtil.getDomainProjectionClasses((PsiClass)element);
            if (domainClasses.size() > 0) {
                SpringDataProjectionAnnotator.annotateProjectionInterface((PsiClass)element, result, domainClasses);
            }
        } else if (element instanceof PsiMethod && (members = SpringDataProjectionUtil.getDomainProjectionMembers((PsiMethod)element)).size() > 0) {
            SpringDataProjectionAnnotator.annotateProjectionMethod((PsiMethod)element, result, members);
        }
    }

    private static void annotateProjectionInterface(PsiClass projectionInterfacesiElement, Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull Set<PsiClass> domainClasses) {
        if (domainClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClasses", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "annotateProjectionInterface"));
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.InfrastructureBean).setPopupTitle(SpringDataBundle.message("spring.data.domain.class.select", new Object[0])).setEmptyPopupText(SpringDataBundle.message("spring.data.domain.class.from.projection", new Object[0])).setTooltipText(SpringDataBundle.message("spring.data.domain.class.from.projection", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<? extends PsiElement> compute() {
                Set set = domainClasses;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator$1", "compute"));
                }
                return set;
            }
        });
        PsiIdentifier identifier = projectionInterfacesiElement.getNameIdentifier();
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void annotateProjectionMethod(PsiMethod projectionMethod, Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull Set<PsiMember> psiMembers) {
        if (psiMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMembers", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator", "annotateProjectionMethod"));
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringBeanMethod).setPopupTitle(SpringDataBundle.message("spring.data.domain.class.member.select", new Object[0])).setEmptyPopupText(SpringDataBundle.message("spring.data.domain.member.from.projection", new Object[0])).setTooltipText(SpringDataBundle.message("spring.data.domain.member.from.projection", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<? extends PsiElement> compute() {
                Set set = psiMembers;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator$2", "compute"));
                }
                return set;
            }
        });
        PsiIdentifier identifier = projectionMethod.getNameIdentifier();
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }
}

