/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.projection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoryMethodReturnTypeInspection;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.rest.SpringProjectionJamComponent;
import com.intellij.spring.data.rest.SpringRepositoryRestResource;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataProjectionUtil {
    public static boolean isExplicitProjectionType(@NotNull PsiClass projectionClass, @NotNull PsiClass domainClass, @NotNull PsiClass repositoryClass) {
        SpringRepositoryRestResource restResource;
        if (projectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isExplicitProjectionType"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isExplicitProjectionType"));
        }
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isExplicitProjectionType"));
        }
        SpringProjectionJamComponent projectionJamComponent = (SpringProjectionJamComponent)SpringProjectionJamComponent.META.getJamElement((PsiModifierListOwner)projectionClass);
        if (projectionJamComponent != null) {
            for (PsiClass aClass : projectionJamComponent.getDomainClasses()) {
                if (!aClass.equals(domainClass)) continue;
                return true;
            }
        }
        return (restResource = (SpringRepositoryRestResource)SpringRepositoryRestResource.META.getJamElement((PsiModifierListOwner)repositoryClass)) != null && projectionClass.equals(restResource.getProjectionClass());
    }

    public static boolean hasProjectionMethods(@NotNull PsiClass projectionClass, @NotNull PsiClass domainClass) {
        if (projectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "hasProjectionMethods"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "hasProjectionMethods"));
        }
        Set<String> domainClassProperties = SpringDataUtil.getProperties(domainClass);
        PsiMethod[] methods = projectionClass.getMethods();
        if (methods.length == 0) {
            return false;
        }
        for (PsiMethod method : methods) {
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
            if (propertyName == null) continue;
            boolean methodHasClosedProjection = domainClassProperties.contains(propertyName);
            boolean methodHasOpenProjection = AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Value", (boolean)true);
            if (methodHasClosedProjection || methodHasOpenProjection) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiMember findDomainAssociatedMember(@NotNull PsiMethod projectionMethod, @NotNull PsiClass domainClass) {
        if (projectionMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionMethod", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "findDomainAssociatedMember"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "findDomainAssociatedMember"));
        }
        String propertyName = PropertyUtil.getPropertyName((PsiMethod)projectionMethod);
        if (propertyName != null) {
            PsiField[] fields;
            Map properties = PropertyUtil.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true);
            PsiMethod method = (PsiMethod)properties.get(propertyName);
            if (method != null) {
                return method;
            }
            for (PsiField field : fields = domainClass.getFields()) {
                if (!propertyName.equals(PropertyUtil.suggestPropertyName((PsiField)field))) continue;
                return field;
            }
        }
        return null;
    }

    @NotNull
    public static Set<PsiClass> getDomainProjectionClasses(@NotNull PsiClass projectionClass) {
        if (projectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainProjectionClasses"));
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)projectionClass, () -> {
            if (projectionClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "lambda$getDomainProjectionClasses$0"));
            }
            return CachedValueProvider.Result.create(SpringDataProjectionUtil.getDomainClasses(projectionClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainProjectionClasses"));
        }
        return set;
    }

    @NotNull
    private static Set<PsiClass> getDomainClasses(@NotNull PsiClass projectionClass) {
        if (projectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainClasses"));
        }
        HashSet domainClasses = ContainerUtil.newHashSet();
        SpringProjectionJamComponent projectionJamComponent = (SpringProjectionJamComponent)SpringProjectionJamComponent.META.getJamElement((PsiModifierListOwner)projectionClass);
        if (projectionJamComponent != null) {
            Set<PsiClass> set = projectionJamComponent.getDomainClasses();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainClasses"));
            }
            return set;
        }
        GlobalSearchScope scope = projectionClass.getResolveScope();
        Project project = projectionClass.getProject();
        for (SpringRepositoryRestResource restResource : JamService.getJamService((Project)project).getJamClassElements(SpringRepositoryRestResource.JAM_KEY, "org.springframework.data.rest.core.annotation.RepositoryRestResource", scope)) {
            if (!projectionClass.equals(restResource.getProjectionClass())) continue;
            ContainerUtil.addIfNotNull((Collection)domainClasses, (Object)SpringDataProjectionUtil.getDomainClass(restResource.getPsiElement()));
        }
        if (domainClasses.size() > 0) {
            HashSet hashSet = domainClasses;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainClasses"));
            }
            return hashSet;
        }
        for (SpringBeanPointer repository : SpringDataProjectionUtil.geRepositories(project, scope)) {
            PsiClass domainClass;
            PsiClass repositoryBeanClass = repository.getBeanClass();
            if (repositoryBeanClass == null || (domainClass = SpringDataProjectionUtil.getDomainClass(repositoryBeanClass)) == null || projectionClass.equals(domainClass) || !SpringDataProjectionUtil.isRepositoryUsesProjections(repositoryBeanClass, projectionClass) || !SpringDataProjectionUtil.hasProjectionMethods(projectionClass, domainClass)) continue;
            domainClasses.add(domainClass);
        }
        HashSet hashSet = domainClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainClasses"));
        }
        return hashSet;
    }

    public static boolean isRepositoryUsesProjections(@NotNull PsiClass repositoryBeanClass, @NotNull PsiClass projectionClass) {
        if (repositoryBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryBeanClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isRepositoryUsesProjections"));
        }
        if (projectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isRepositoryUsesProjections"));
        }
        List<PsiMethod> methods = SpringDataUtil.getRepositoryMethods(repositoryBeanClass);
        for (PsiMethod method : methods) {
            if (!SpringDataProjectionUtil.isRepositoryUsesProjections(projectionClass, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRepositoryUsesProjections(@NotNull PsiClass projectionClass, @NotNull PsiMethod method) {
        if (projectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isRepositoryUsesProjections"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "isRepositoryUsesProjections"));
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return false;
        }
        PsiClassType projectionType = PsiTypesUtil.getClassType((PsiClass)projectionClass);
        if (returnType.equals(projectionType)) {
            return true;
        }
        if (projectionType.equals((Object)PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false))) {
            return true;
        }
        return projectionType.equals((Object)SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType));
    }

    @NotNull
    public static Set<SpringBeanPointer> geRepositories(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "geRepositories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "geRepositories"));
        }
        List<CommonSpringBean> repositories = RepositoriesSearchUtil.getAllRepositories(scope, project, "org.springframework.data.repository.Repository");
        Set set = BeanService.getInstance().mapSpringBeans(repositories);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "geRepositories"));
        }
        return set;
    }

    @Nullable
    public static PsiClass getDomainClass(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainClass"));
        }
        Pair<PsiClass, ? extends PsiType> pair = SpringDataUtil.substituteRepositoryTypes(repositoryClass);
        if (pair != null) {
            return (PsiClass)pair.first;
        }
        return null;
    }

    @NotNull
    public static Set<PsiMember> getDomainProjectionMembers(@NotNull PsiMethod projectionMethod) {
        if (projectionMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionMethod", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainProjectionMembers"));
        }
        HashSet members = ContainerUtil.newHashSet();
        PsiClass projectionClass = projectionMethod.getContainingClass();
        if (projectionClass != null && projectionClass.isInterface()) {
            for (PsiClass domainClass : SpringDataProjectionUtil.getDomainProjectionClasses(projectionClass)) {
                ContainerUtil.addIfNotNull((Collection)members, (Object)SpringDataProjectionUtil.findDomainAssociatedMember(projectionMethod, domainClass));
            }
        }
        HashSet hashSet = members;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil", "getDomainProjectionMembers"));
        }
        return hashSet;
    }
}

