/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.ql;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.data.commons.ql.SpringDataQLInjector;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringQueryELContextVariables
extends SpringElContextsExtension {
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/commons/ql/SpringQueryELContextVariables", "getContextVariables"));
        }
        PsiAnnotation annotation = SpringQueryELContextVariables.getQueryAnnotationContext(context);
        if (annotation == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/ql/SpringQueryELContextVariables", "getContextVariables"));
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
        if (method != null) {
            Collections.addAll(variables, method.getParameterList().getParameters());
        }
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/ql/SpringQueryELContextVariables", "getContextVariables"));
        }
        return list;
    }

    @Nullable
    private static PsiAnnotation getQueryAnnotationContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/commons/ql/SpringQueryELContextVariables", "getQueryAnnotationContext"));
        }
        PsiElement element = context.getContext();
        if (element == null) {
            return null;
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
        if (annotation == null) {
            return null;
        }
        if (!SpringDataUtil.hasSpringDataSupport(context.getProject())) {
            return null;
        }
        String annoFqn = annotation.getQualifiedName();
        return annoFqn != null && SpringDataQLInjector.QUERY_ANNOTATIONS.contains(annoFqn) ? annotation : null;
    }
}

