/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.nodes.PropertyNode;
import com.intellij.spring.data.commons.util.nodes.PropertyParametersType;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SelectPropertyNode
extends PropertyNode {
    private static final Pattern IGNORE_CASE = Pattern.compile("Ignor(ing|e)Case");
    private String myPropertyName;
    private PropertyParametersType myType;
    private boolean ignoreCase;

    public SelectPropertyNode(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/commons/util/nodes/SelectPropertyNode", "<init>"));
        }
        super(expression);
        this.myType = PropertyParametersType.SIMPLE_PROPERTY;
        this.ignoreCase = false;
        String expressionCaseProcessed = this.detectAndSetIgnoreCase(expression);
        this.myPropertyName = StringUtil.decapitalize((String)expressionCaseProcessed);
        Processor processor = type -> {
            for (String keyword : type.getKeywords()) {
                if (!expressionCaseProcessed.endsWith(keyword)) continue;
                this.myType = type;
                this.myPropertyName = StringUtil.decapitalize((String)expressionCaseProcessed.substring(0, expressionCaseProcessed.indexOf(keyword)));
                return false;
            }
            return true;
        };
        for (PropertyParametersType type2 : PropertyParametersType.ALL) {
            if (!processor.process((Object)type2)) break;
        }
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    public boolean isDefaultKeyword() {
        return this.myType == PropertyParametersType.SIMPLE_PROPERTY;
    }

    public PropertyParametersType getType() {
        return this.myType;
    }

    @Override
    public Set<String> getPropertyKeywords() {
        HashSet strings = new HashSet();
        for (PropertyParametersType type : PropertyParametersType.ALL) {
            for (String propertyKeyword : type.getKeywords()) {
                strings.add((Object)propertyKeyword);
            }
        }
        return strings;
    }

    @Override
    @NotNull
    public String getKeyword() {
        String string = this.getExpression().substring(this.myPropertyName.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/nodes/SelectPropertyNode", "getKeyword"));
        }
        return string;
    }

    @NotNull
    private String detectAndSetIgnoreCase(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/commons/util/nodes/SelectPropertyNode", "detectAndSetIgnoreCase"));
        }
        Matcher matcher = IGNORE_CASE.matcher(expression);
        String result = expression;
        if (matcher.find()) {
            this.ignoreCase = true;
            result = expression.substring(0, matcher.start()) + expression.substring(matcher.end(), expression.length());
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/nodes/SelectPropertyNode", "detectAndSetIgnoreCase"));
        }
        return string;
    }
}

