/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view.panels;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.spring.data.commons.view.SpringRepositoriesView;
import com.intellij.spring.data.commons.view.panels.SpringRepositoriesPanel;
import com.intellij.spring.toolWindow.SpringModulesPanelBase;
import com.intellij.ui.FinderRecursivePanel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringRepositoriesModulesPanel
extends SpringModulesPanelBase {
    public SpringRepositoriesModulesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/commons/view/panels/SpringRepositoriesModulesPanel", "<init>"));
        }
        super(project, "SpringRepositoriesModulesPanel");
    }

    @NotNull
    public List<Module> getListItems() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        List<Module> list = Arrays.stream(modules).filter(module -> this.hasRepositories((Module)module)).sorted((Comparator<Module>)ModulesAlphaComparator.INSTANCE).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/view/panels/SpringRepositoriesModulesPanel", "getListItems"));
        }
        return list;
    }

    public boolean hasChildren(Module module) {
        if (module.isDisposed()) {
            return false;
        }
        if (DumbService.isDumb((Project)this.getProject())) {
            return false;
        }
        return this.hasRepositories(module);
    }

    public boolean hasRepositories(Module module) {
        return SpringRepositoriesView.getRepositories(module).size() > 0;
    }

    @Nullable
    protected JComponent createRightComponent(Module module) {
        return new SpringRepositoriesPanel((FinderRecursivePanel<Module>)this, module);
    }
}

