/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.el;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.seam.el.SeamELContextProvider;
import com.intellij.seam.el.SeamELInjectorUtil;
import com.intellij.seam.facet.SeamFacet;
import com.intellij.seam.utils.SeamCommonUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SeamClassELInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        Module module;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/seam/el/SeamClassELInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/seam/el/SeamClassELInjector", "getLanguagesToInject"));
        }
        if (!host.textContains('#')) {
            return;
        }
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)host);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PsiClass.class);
        if (psiClass != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)) != null && SeamFacet.getInstance(module) != null && (SeamCommonUtils.isSeamClass(psiClass) || SeamCommonUtils.isAbstractSeamComponent(psiClass))) {
            for (TextRange textRange : SeamELInjectorUtil.getELTextRanges(host)) {
                registrar.startInjecting(ELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, textRange).doneInjecting();
                host.putUserData(ELContextProvider.ourContextProviderKey, (Object)new SeamELContextProvider(host));
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(PsiLiteral.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/el/SeamClassELInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

