/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.utils.SeamCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Seam Role")
public abstract class SeamJamRole
extends CommonModelElement.PsiBase
implements JamElement,
CommonModelElement {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static JamStringAttributeMeta.Single<String> NAME_ATTRIBUTE_META = JamAttributeMeta.singleString((String)"name");
    public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.jboss.seam.annotations.Role").addAttribute(NAME_ATTRIBUTE_META);
    public static final JamClassMeta<SeamJamRole> META = new JamClassMeta(SeamJamRole.class).addAnnotation(ANNOTATION_META).addPomTargetProducer((seamJamRole, consumer) -> consumer.consume((Object)seamJamRole.getPsiTarget()));
    private final PsiMember myPsiMember;
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    public SeamJamRole(PsiMember psiMember) {
        this.myPsiMember = psiMember;
        this.myPsiAnnotation = ANNOTATION_META.getAnnotationRef((PsiModifierListOwner)psiMember);
    }

    public SeamJamRole(PsiAnnotation psiAnnotation) {
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)psiAnnotation);
        this.myPsiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMember.class, (boolean)true);
    }

    protected JamStringAttributeElement<String> getNamedStringAttributeElement() {
        return NAME_ATTRIBUTE_META.getJam(this.myPsiAnnotation);
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (namedAttributeValue.getStringValue() != null) {
            return new JamPomTarget((JamElement)this, namedAttributeValue);
        }
        return null;
    }

    public PsiElement getIdentifyingPsiElement() {
        return PomService.convertToPsi((Project)this.myPsiMember.getProject(), (PomTarget)this.getPsiTarget());
    }

    @NotNull
    public PsiMember getPsiElement() {
        PsiMember psiMember = this.myPsiMember;
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/jam/SeamJamRole", "getPsiElement"));
        }
        return psiMember;
    }

    @NonNls
    public String getName() {
        return NAME_ATTRIBUTE_META.getJam(this.myPsiAnnotation).getStringValue();
    }

    @Nullable
    public PsiAnnotation getIdentifyingAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Nullable
    public PsiType getComponentType() {
        PsiClass psiClass = (PsiClass)this.getPsiElement();
        PsiType unwrapType = SeamCommonUtils.getUnwrapType(psiClass);
        return unwrapType == null ? JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass) : unwrapType;
    }

    public SeamComponentScope getScope() {
        return (SeamComponentScope)((Object)AnnotationModelUtil.getEnumValue((PsiAnnotation)this.getIdentifyingAnnotation(), (String)SCOPE_ATTRIBUTE, SeamComponentScope.class).getValue());
    }
}

