/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseViewActions {
    private static final DataSourceFactory MY_DATA_SOURCE_FACTORY = new DataSourceFactory(){

        @Override
        public void create(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String s) {
            if (facade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/DatabaseViewActions$2", "create"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/actions/DatabaseViewActions$2", "create"));
            }
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/actions/DatabaseViewActions$2", "create"));
            }
            DatabaseViewActions.instantiateTemplate(facade, manager, template, s);
        }
    };

    private DatabaseViewActions() {
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setter", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        ToggleAction toggleAction = DatabaseViewActions.toggle(name, getter, setter, null, null);
        if (toggleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        return toggleAction;
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter, @Nullable Runnable performer) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setter", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        ToggleAction toggleAction = DatabaseViewActions.toggle(name, getter, setter, performer, null);
        if (toggleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        return toggleAction;
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter, final @Nullable Runnable performer, final @Nullable Consumer<Presentation> updater) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setter", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        ToggleAction toggleAction = new ToggleAction(name){

            public boolean isSelected(AnActionEvent e) {
                return (Boolean)getter.get();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                if ((Boolean)getter.get() != state) {
                    setter.set((Object)state);
                    if (performer != null) {
                        performer.run();
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$1", "update"));
                }
                super.update(e);
                if (updater != null) {
                    updater.consume((Object)e.getPresentation());
                }
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        if (toggleAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions", "toggle"));
        }
        return toggleAction;
    }

    private static void instantiateTemplate(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String url) {
        LocalDataSource localDataSource;
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/DatabaseViewActions", "instantiateTemplate"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/actions/DatabaseViewActions", "instantiateTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/actions/DatabaseViewActions", "instantiateTemplate"));
        }
        DatabaseSystem newDS = template.createDataSource(facade.getProject(), null, null);
        if (url != null && (localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)newDS, LocalDataSource.class)) != null) {
            localDataSource.setUrlSmart(url);
        }
        DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(newDS, (DbPsiManagerSpi)manager);
        DataSourceManagerDialog.showDialog(facade, newElement);
    }

    public static void addNewDataSourceActions(@Nullable Project project, @NotNull List<AnAction> actions, boolean flatten, @NotNull DbPsiFacade facade, @Nullable Function.Mono<DataSourceTemplate> wrapper, PairConsumer<DbPsiManager, DataSourceTemplate> consumer) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/actions/DatabaseViewActions", "addNewDataSourceActions"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/DatabaseViewActions", "addNewDataSourceActions"));
        }
        for (DbPsiManager manager : facade.getDbManagers()) {
            if (flatten) {
                actions.add((AnAction)Separator.getInstance());
            }
            int size = actions.size();
            DatabaseViewActions.addNewDataSourceActions(project, actions, manager, manager.getDataSourceTemplates(), wrapper, consumer);
            for (AnAction action : actions.subList(size, actions.size())) {
                if (!(action instanceof ActionGroup)) continue;
                ((ActionGroup)action).setPopup(!flatten);
            }
        }
    }

    public static void addNewDataSourceActions(final @Nullable Project project, @NotNull List<AnAction> actions, final @NotNull DbPsiManager manager, @NotNull List<? extends DataSourceTemplate> templates, final @Nullable Function.Mono<DataSourceTemplate> wrapper, final @NotNull PairConsumer<DbPsiManager, DataSourceTemplate> consumer) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/actions/DatabaseViewActions", "addNewDataSourceActions"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/actions/DatabaseViewActions", "addNewDataSourceActions"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/database/actions/DatabaseViewActions", "addNewDataSourceActions"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/DatabaseViewActions", "addNewDataSourceActions"));
        }
        Condition predefCondition = template -> template instanceof DatabaseDriver && ((DatabaseDriver)template).isPredefined();
        List lru = ContainerUtil.reverse(DatabaseViewActions.getLRUNames(project));
        Comparator comparator = (o1, o2) -> {
            int i1 = lru.indexOf(o1.getName());
            int i2 = lru.indexOf(o2.getName());
            if (i1 == -1 && i2 == -1) {
                return StringUtil.naturalCompare((String)o1.getFullName(), (String)o2.getFullName());
            }
            return i2 - i1;
        };
        JBIterable predef = JBIterable.from(templates).filter(predefCondition);
        JBIterable nonPredef = JBIterable.from(templates).filter(Conditions.not((Condition)predefCondition));
        if (wrapper != null) {
            predef = predef.transform(wrapper);
            nonPredef = nonPredef.transform(wrapper);
        }
        ArrayList sortedTemplates = ContainerUtil.newArrayList();
        sortedTemplates.addAll(nonPredef.toList());
        int sepIdx = sortedTemplates.size();
        sortedTemplates.addAll(predef.toList());
        Collections.sort(sortedTemplates.subList(0, sepIdx), comparator);
        Collections.sort(sortedTemplates.subList(sepIdx, sortedTemplates.size()), comparator);
        DataSourceTemplate sepItem = sepIdx == sortedTemplates.size() || sepIdx == 0 ? null : (DataSourceTemplate)sortedTemplates.get(sepIdx);
        for (final DataSourceTemplate template2 : sortedTemplates) {
            List subs;
            if (template2 == sepItem) {
                actions.add((AnAction)Separator.getInstance());
            }
            if (!(subs = template2.getSubConfigurations()).isEmpty()) {
                actions.add((AnAction)new ActionGroup(template2.getFullName(), null, template2.getIcon(0)){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        ArrayList subActions = ContainerUtil.newArrayList();
                        DatabaseViewActions.addNewDataSourceActions(project, (List<AnAction>)subActions, manager, subs, (Function.Mono<DataSourceTemplate>)wrapper, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
                        AnAction[] anActionArray = subActions.toArray(new AnAction[subActions.size()]);
                        if (anActionArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$3", "getChildren"));
                        }
                        return anActionArray;
                    }
                });
                continue;
            }
            final String name = template2.getName();
            actions.add((AnAction)new DumbAwareAction(name, null, template2.getIcon(0)){

                public void actionPerformed(AnActionEvent e) {
                    DatabaseViewActions.addToLRU(e.getProject(), name);
                    consumer.consume((Object)manager, (Object)template2);
                }
            });
        }
    }

    private static void addToLRU(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/DatabaseViewActions", "addToLRU"));
        }
        if (project == null) {
            return;
        }
        String[] values = PropertiesComponent.getInstance((Project)project).getValues(DataSourceTemplate.class.getName());
        int capacity = 5;
        ArrayList<String> lastUsed = new ArrayList<String>(capacity);
        lastUsed.add(name);
        if (values != null) {
            for (String value : values) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() == capacity) break;
            }
        }
        PropertiesComponent.getInstance((Project)project).setValues(DataSourceTemplate.class.getName(), ArrayUtil.toStringArray(lastUsed));
    }

    @NotNull
    public static List<String> getLRUNames(@Nullable Project project) {
        if (project == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions", "getLRUNames"));
            }
            return list;
        }
        Object[] values = PropertiesComponent.getInstance((Project)project).getValues(DataSourceTemplate.class.getName());
        List list = values == null ? ContainerUtil.emptyList() : ContainerUtil.list((Object[])values);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions", "getLRUNames"));
        }
        return list;
    }

    static class CopyAction
    extends DumbAwareAction {
        CopyAction() {
        }

        public void update(AnActionEvent e) {
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            boolean enabled = elements.size() == 1 && elements.first() instanceof DbDataSource;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                return;
            }
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            PsiElement first = (PsiElement)elements.first();
            if (elements.size() != 1 || !(first instanceof DbDataSource)) {
                return;
            }
            DbDataSource element = (DbDataSource)first;
            DataSourceTemplate template = element.getDbManager().getDataSourceTemplate(element);
            if (template == null) {
                return;
            }
            DatabaseView view2 = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
            if (view2 == null) {
                return;
            }
            DatabaseSystem dsCopy = template.createDataSource(element.getProject(), element.getDelegate(), DbUtil.createNewDataSourceName((Project)facade.getProject(), (String)element.getName()));
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dsCopy, (DbPsiManagerSpi)element.getDbManager());
            DataSourceManagerDialog.showDialog(facade, newElement);
        }
    }

    static class ForgetSchemasAction
    extends DataSourceActionBase {
        ForgetSchemasAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction", "isEnabledFor"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction", "isEnabledFor"));
            }
            return dataSource.getDelegate() instanceof AbstractDataSource;
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction", "performActionImpl"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction", "performActionImpl"));
            }
            final DataSourceManagerEx manager = DataSourceManagerEx.getInstanceEx(project);
            ForgetSchemasAction.performActionImpl(dataSources, (Consumer<DbDataSource>)((Consumer)dataSource -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction", "lambda$performActionImpl$0"));
                }
                final LocalDataSource delegate = (LocalDataSource)dataSource.getDelegate();
                new Task.Backgroundable(project, "Clearing Cached Schemas"){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction$1", "run"));
                        }
                        delegate.clearModel();
                        manager.updateDataSource(delegate);
                    }
                }.queue();
            }));
        }
    }

    static class DisconnectAction
    extends DataSourceActionBase {
        DisconnectAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseViewActions$DisconnectAction", "isEnabledFor"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/actions/DatabaseViewActions$DisconnectAction", "isEnabledFor"));
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DatabaseSystem delegate = dataSource.getDelegate();
            LocalDataSource local = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
            return local != null && !manager.getActiveConfigurations(local).isEmpty();
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DatabaseViewActions$DisconnectAction", "performActionImpl"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/actions/DatabaseViewActions$DisconnectAction", "performActionImpl"));
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DisconnectAction.performActionImpl(dataSources, (Consumer<DbDataSource>)((Consumer)dataSource -> manager.releaseDriver(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource), null)));
        }
    }

    static abstract class DataSourceActionBase
    extends DumbAwareAction {
        DataSourceActionBase() {
        }

        protected abstract boolean isEnabledFor(@NotNull Project var1, @NotNull DbDataSource var2);

        protected abstract void performActionImpl(@NotNull Project var1, @NotNull List<DbDataSource> var2);

        public void update(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            boolean enabled = false;
            boolean strict = false;
            if (project != null && !elements.isEmpty()) {
                HashSet visited = ContainerUtil.newHashSet();
                for (DbElement element : elements) {
                    DbDataSource dataSource = element.getDataSource();
                    if (!visited.add(dataSource.getUniqueId())) continue;
                    strict |= element == dataSource;
                    if (enabled || !this.isEnabledFor(project, dataSource)) continue;
                    enabled = true;
                }
            }
            boolean inPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(!inPopup || strict);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            if (project == null || elements.isEmpty()) {
                return;
            }
            ArrayList dataSources = ContainerUtil.newArrayList();
            HashSet visited = ContainerUtil.newHashSet();
            for (DbElement element : elements) {
                DbDataSource dataSource = element.getDataSource();
                if (!visited.add(dataSource.getUniqueId()) || !this.isEnabledFor(project, dataSource)) continue;
                dataSources.add(dataSource);
            }
            this.performActionImpl(project, dataSources);
        }

        protected static void performActionImpl(@NotNull List<DbDataSource> dataSources, @NotNull Consumer<DbDataSource> consumer) {
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase", "performActionImpl"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase", "performActionImpl"));
            }
            for (DbDataSource dataSource : dataSources) {
                consumer.consume((Object)dataSource);
            }
        }
    }

    static class ToolsGroup
    extends DumbAwareAction {
        ToolsGroup() {
        }

        public void update(AnActionEvent e) {
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(facade != null);
        }

        public void actionPerformed(AnActionEvent e) {
            ActionGroup group2 = (ActionGroup)ActionManager.getInstance().getAction("DatabaseView.Tools");
            if (ActionGroupUtil.isGroupEmpty((ActionGroup)group2, (AnActionEvent)e, (boolean)false)) {
                return;
            }
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(e.getPresentation().getText(), group2, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    static class AddDataSourceFromThatAction
    extends AddDataSourceFromPath.FromThat {
        public AddDataSourceFromThatAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    static class AddDataSourceHereAction
    extends AddDataSourceFromPath.Here {
        public AddDataSourceHereAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    static class AddDataSourceFromPathAction
    extends AddDataSourceFromPath.FromDialog {
        public AddDataSourceFromPathAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    static class AddDataSourceFromUrlAction
    extends AddDataSourceFromUrl {
        public AddDataSourceFromUrlAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    public static interface DataSourceFactory {
        public void create(@NotNull DbPsiFacade var1, @NotNull DbPsiManager var2, @NotNull DataSourceTemplate var3, @Nullable String var4);
    }

    public static class AddDataSourcesGroup
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            ArrayList actions = ContainerUtil.newArrayList();
            DatabaseViewActions.addNewDataSourceActions(e.getProject(), (List<AnAction>)actions, false, facade, null, (PairConsumer<DbPsiManager, DataSourceTemplate>)((PairConsumer)(manager, template) -> DatabaseViewActions.instantiateTemplate(facade, manager, template, null)));
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup", "getChildren"));
            }
            return anActionArray;
        }
    }

    public static class AddActionGroupPopup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            boolean toolbar = ActionPlaces.isToolbarPlace((String)e.getPlace());
            e.getPresentation().setIcon(toolbar ? IconUtil.getAddIcon() : AllIcons.General.Add);
        }
    }
}

