/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFederatedProvider;

public class JdbcConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    @NonNls
    public static final String MAIN_CLASS = "com.intellij.database.remote.RemoteJdbcServer";
    private final LocalDataSource myDataSource;

    JdbcConsoleRunContext(LocalDataSource dataSource) {
        this.myDataSource = dataSource;
    }

    public static void addSslAndWinAuthProperties(@NotNull LocalDataSource dataSource, @NotNull Properties properties) {
        DataSourceSslConfiguration ssl;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcConsoleRunContext", "addSslAndWinAuthProperties"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/console/JdbcConsoleRunContext", "addSslAndWinAuthProperties"));
        }
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource);
        if (familyId.isMicrosoft()) {
            boolean jtds = JdbcConsoleRunContext.isJtds(dataSource);
            if (dataSource.isDomainAuthentication() && !jtds) {
                properties.setProperty("integratedSecurity", "true");
            }
        }
        if ((ssl = dataSource.getSslCfg()) != null && ssl.myEnabled) {
            if (familyId.isMysql()) {
                properties.setProperty("useSSL", "true");
                properties.setProperty("requireSSL", "true");
            } else if (familyId.isPostgres()) {
                properties.setProperty("ssl", "true");
            }
        }
    }

    public static void addUtilJars(@NotNull PathsList cp, boolean addGroovy) {
        if (cp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cp", "com/intellij/database/console/JdbcConsoleRunContext", "addUtilJars"));
        }
        cp.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        cp.add(PathUtil.getJarPathForClass(ExceptionUtil.class));
        cp.add(PathUtil.getJarPathForClass(ContainerUtil.class));
        cp.add(PathUtil.getJarPathForClass(TObjectHashingStrategy.class));
        if (addGroovy) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcConsole.class, "groovy.lang.GroovyShell");
        }
    }

    public static void addJdbcConsoleJars(PathsList cp) {
        JdbcConsoleRunContext.addClassJar(cp, JdbcEngine.class, MAIN_CLASS);
        JdbcConsoleRunContext.addClassJar(cp, JdbcEngine.class, JdbcIntermediateFederatedProvider.class.getName());
    }

    public static void addClassJar(@NotNull PathsList cp, @NotNull Class<?> context, @NotNull String className) {
        if (cp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cp", "com/intellij/database/console/JdbcConsoleRunContext", "addClassJar"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcConsoleRunContext", "addClassJar"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/database/console/JdbcConsoleRunContext", "addClassJar"));
        }
        String s = PathManager.getResourceRoot(context, (String)("/" + className.replace('.', '/') + ".class"));
        if (s == null) {
            return;
        }
        cp.add(new File(s).getAbsoluteFile().getAbsolutePath());
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    @Override
    public Module getModule() {
        return null;
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS;
    }

    @Override
    public void collectClassPath(PathsList cp) {
        JdbcConsoleRunContext.addUtilJars(cp, true);
        JdbcConsoleRunContext.addJdbcConsoleJars(cp);
        for (SimpleClasspathElement classpathElement : this.myDataSource.getClasspathElements()) {
            for (String url : classpathElement.getClassesRootUrls()) {
                cp.add(PathUtil.toPresentableUrl((String)url));
            }
        }
    }

    @Override
    public void tuneParams(@NotNull SimpleJavaParameters params2) throws ExecutionException {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/console/JdbcConsoleRunContext", "tuneParams"));
        }
        String driverClass = this.myDataSource.getDriverClass();
        if (StringUtil.isEmpty((String)driverClass)) {
            throw new ExecutionException("No driver class for: " + this.myDataSource.getName());
        }
        DataSourceSslConfiguration ssl = this.myDataSource.getSslCfg();
        ParametersList vmParams = params2.getVMParametersList();
        if (ssl != null && ssl.myEnabled) {
            JdbcConsoleRunContext.addNotEmpty(vmParams, ssl.myCaCertPath, "sslCaCertPath");
            JdbcConsoleRunContext.addNotEmpty(vmParams, ssl.myClientCertPath, "sslClientCertPath");
            JdbcConsoleRunContext.addNotEmpty(vmParams, ssl.myClientKeyPath, "sslClientKeyPath");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            vmParams.addProperty("dekaf.workaround");
        }
        if (DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource).isMicrosoft() && this.myDataSource.isDomainAuthentication()) {
            String libPath = "/#BITNESS" + (JdbcConsoleRunContext.isJtds(this.myDataSource) ? "/SSO/ntlmauth.dll" : "/sqljdbc_auth.dll");
            vmParams.addProperty("domain.auth.library", libPath);
        }
        params2.getProgramParametersList().add(driverClass);
    }

    private static void addNotEmpty(@NotNull ParametersList props, @Nullable String value, @NotNull String key) {
        if (props == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props", "com/intellij/database/console/JdbcConsoleRunContext", "addNotEmpty"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/console/JdbcConsoleRunContext", "addNotEmpty"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            props.addProperty(key, value);
        }
    }

    private static boolean isJtds(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcConsoleRunContext", "isJtds"));
        }
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        String driverClass = driver == null ? null : driver.getDriverClass();
        return driverClass != null && StringUtil.containsIgnoreCase((String)driverClass, (String)"jtds");
    }
}

