/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvFormat {
    public final String name;
    public final CsvRecordFormat dataRecord;
    public final CsvRecordFormat headerRecord;
    public final boolean rowNumbers;
    public final String id;

    public CsvFormat(@NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, boolean rowNumbers) {
        if (dataRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataRecord", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        this("", dataRecord, headerRecord, rowNumbers);
    }

    public CsvFormat(@NotNull String name, @NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, boolean rowNumbers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        if (dataRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataRecord", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        this(name, dataRecord, headerRecord, UUID.randomUUID().toString(), rowNumbers);
    }

    public CsvFormat(@NotNull String name, @NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, @NotNull String id, boolean rowNumbers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        if (dataRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataRecord", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        this.name = name;
        this.dataRecord = dataRecord;
        this.headerRecord = headerRecord;
        this.rowNumbers = rowNumbers;
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvFormat)) {
            return false;
        }
        CsvFormat format = (CsvFormat)o;
        if (this.rowNumbers != format.rowNumbers) {
            return false;
        }
        if (!this.name.equals(format.name)) {
            return false;
        }
        if (!this.dataRecord.equals(format.dataRecord)) {
            return false;
        }
        if (this.headerRecord != null ? !this.headerRecord.equals(format.headerRecord) : format.headerRecord != null) {
            return false;
        }
        return this.id.equals(format.id);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.dataRecord.hashCode();
        result2 = 31 * result2 + (this.headerRecord != null ? this.headerRecord.hashCode() : 0);
        result2 = 31 * result2 + (this.rowNumbers ? 1 : 0);
        result2 = 31 * result2 + this.id.hashCode();
        return result2;
    }

    public static int indexOfFormatNamed(@NotNull List<CsvFormat> formats, @Nullable String name) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/csv/CsvFormat", "indexOfFormatNamed"));
        }
        return name == null ? -1 : ContainerUtil.indexOf(formats, format -> StringUtil.equals((CharSequence)name, (CharSequence)format.name));
    }
}

