/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceGeneralPanel {
    private final DataSourceConfigurable myConfigurable;
    private JBScrollPane myPanel;
    private JComponent myConnectionPropertiesComponent;
    private JBCheckBox myAutoCommitCheckBox;
    private JBCheckBox myAutoSyncCheckBox;
    private JCheckBox myReadOnlyCheckBox;
    private JLabel myStatistics;
    private final DynamicJdbcUrlEditor myUrlPanel;
    private String myGeneratedName;

    DataSourceGeneralPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/database/dataSource/DataSourceGeneralPanel", "<init>"));
        }
        this.myGeneratedName = "";
        this.myConfigurable = configurable;
        LocalDataSource dataSource = (LocalDataSource)configurable.getDataSource();
        this.myUrlPanel = new DynamicJdbcUrlEditor(configurable, new Runnable(){

            @Override
            public void run() {
                String generatedName = DataSourceGeneralPanel.this.myUrlPanel.generateNameFromParameters();
                if (!Comparing.equal((String)generatedName, (String)DataSourceGeneralPanel.this.myGeneratedName) && Comparing.equal((String)DataSourceGeneralPanel.this.myConfigurable.createUniqueName(DataSourceGeneralPanel.this.myGeneratedName), (String)DataSourceGeneralPanel.this.myConfigurable.getNameValue()) || StringUtil.isEmptyOrSpaces((String)DataSourceGeneralPanel.this.myConfigurable.getNameValue())) {
                    DataSourceGeneralPanel.this.myConfigurable.setGeneratedName(DataSourceGeneralPanel.this.myConfigurable.createUniqueName(generatedName));
                }
                DataSourceGeneralPanel.this.myGeneratedName = generatedName;
            }
        });
        this.$$$setupUI$$$();
        this.myUrlPanel.getComponent().setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.myPanel.setBorder(null);
        JComponent view2 = (JComponent)this.myPanel.getViewport().getView();
        view2.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        ((GridLayoutManager)view2.getLayout()).setHGap(5);
        int objectCount = ((JBTreeTraverser)dataSource.getModel().traverser().expand(DasUtil.byClass(DasNamespace.class))).traverse().size();
        this.myStatistics.setText(objectCount == 0 ? "no objects" : (objectCount == 1 ? "1 object" : objectCount + " objects"));
        this.myStatistics.setToolTipText("Data source statistics");
        boolean isSqlite = DbImplUtil.getDatabaseDialect(dataSource).getFamilyId().isSqlite();
        if (isSqlite) {
            this.myReadOnlyCheckBox.setVisible(false);
            dataSource.setReadOnly(false);
        }
    }

    @NotNull
    public JScrollPane getComponent() {
        JBScrollPane jBScrollPane = this.myPanel;
        if (jBScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceGeneralPanel", "getComponent"));
        }
        return jBScrollPane;
    }

    @Nullable
    public String getUserName() {
        return this.myUrlPanel.getUserName();
    }

    @Nullable
    public char[] getPassword() {
        return this.myUrlPanel.getPassword();
    }

    public void setCanConnect(boolean canConnect) {
        this.myUrlPanel.setCanConnect(canConnect);
    }

    public void onActivity() {
        this.myUrlPanel.onActivity();
    }

    public void saveSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceGeneralPanel", "saveSettings"));
        }
        this.myUrlPanel.saveSettings(dataSource, copyCredentials, actual);
        dataSource.setAutoCommit(this.myAutoCommitCheckBox.isSelected());
        dataSource.setAutoSynchronize(this.myAutoSyncCheckBox.isSelected());
        dataSource.setReadOnly(this.myReadOnlyCheckBox.isSelected());
    }

    public void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceGeneralPanel", "reset"));
        }
        this.myUrlPanel.reset(dataSource);
        this.myAutoCommitCheckBox.setSelected(dataSource.isAutoCommit());
        this.myAutoSyncCheckBox.setSelected(dataSource.isAutoSynchronize());
        this.myReadOnlyCheckBox.setSelected(dataSource.isReadOnly());
    }

    public void requestUrlFocus() {
        this.myUrlPanel.requestUrlFocus();
    }

    public String generateNameFromParameters() {
        return this.myConfigurable.createUniqueName(this.myUrlPanel.generateNameFromParameters());
    }

    private void createUIComponents() {
        this.myConnectionPropertiesComponent = this.myUrlPanel.getComponent();
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        this.myUrlPanel.setDriver(driver, this.myUrlPanel.getUrl(), this.myUrlPanel.isUrlOnly());
    }

    public void resetCredentials(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceGeneralPanel", "resetCredentials"));
        }
        this.myUrlPanel.resetCredentials(dataSource);
    }

    public boolean isPasswordChanged() {
        return this.myUrlPanel.isPasswordChanged();
    }

    @Nullable
    public DatabaseDriver getActualDriver() {
        return this.myUrlPanel.getActualDriver();
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myUrlPanel.getDriver();
    }

    @NotNull
    public UrlEditorModel getUrlEditorModel() {
        UrlEditorModel urlEditorModel = this.myUrlPanel.getEditorModel();
        if (urlEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceGeneralPanel", "getUrlEditorModel"));
        }
        return urlEditorModel;
    }

    public void updateDriverLink() {
        this.myUrlPanel.updateDriverLink();
    }

    public void onApply() {
        this.myUrlPanel.forgetPassword();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JLabel jLabel;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myPanel = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        JComponent jComponent = this.myConnectionPropertiesComponent;
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myStatistics = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAutoSyncCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/DatabaseBundle").getString("auto.sync"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAutoCommitCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/DatabaseBundle").getString("auto.commit"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        JBCheckBox jBCheckBox3 = new JBCheckBox();
        this.myReadOnlyCheckBox = jBCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/DatabaseBundle").getString("read.only"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

