/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.database.dataSource.DataSourceProviderFactory;
import com.intellij.database.dataSource.DataSourceStorageLocal;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.serialization.ModelSerializerKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.GuiUtils;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.json.AbstractJsonWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceStorage
extends SimpleModificationTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceStorage");
    public static final String MULTIFILE_MODEL = "multifile-model";
    private boolean myMultiFileModel = true;
    @NonNls
    static final String STORAGE_ENTRY_NAME = "dataSources";
    @NonNls
    static final String STATE_FILE = "dataSources.xml";
    @NonNls
    static final String APP_STORAGE_FILE = "dataSources.ids";
    @NonNls
    static final String COMPONENT_NAME = "dataSourceStorage";
    @NonNls
    static final String COMPRESSED_ATTR_NAME = "compressed";
    @NonNls
    static final String FORMAT_ATTR_NAME = "format";
    @NonNls
    private static final String DATA_SOURCE_SOURCE_NAME = "DataSourceSourceName";
    @Nullable
    private final DataSourceStorage myParentStorage;
    @NotNull
    private final List<LocalDataSource> myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final EventDispatcher<DataSourceListener> myDispatcher = EventDispatcher.create(DataSourceListener.class);
    private final Map<String, Object> myLocks = new FactoryMap<String, Object>(){

        @Nullable
        protected Object create(final String key) {
            return new Object(){

                public String toString() {
                    return key;
                }
            };
        }
    };
    private Format myFormat = Format.XML;
    private final LocalDataSource.Listener myDataSourceListener = dataSource -> {
        this.incModificationCount();
        ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceChanged(dataSource);
    };

    public static DataSourceStorage getStorage() {
        return (DataSourceStorage)((Object)ServiceManager.getService(App.class));
    }

    public DataSourceStorage(@Nullable DataSourceStorage parentStorage) {
        this.myParentStorage = parentStorage;
        if (parentStorage != null) {
            this.myParentStorage.addDataSourceListener(new DataSourceListener(){

                @Override
                public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                    if (dataSource == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$2", "dataSourceAdded"));
                    }
                    ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceAdded(dataSource);
                }

                @Override
                public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                    if (dataSource == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$2", "dataSourceRemoved"));
                    }
                    ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceRemoved(dataSource);
                }

                @Override
                public void dataSourceChanged(LocalDataSource dataSource) {
                    ((DataSourceListener)DataSourceStorage.this.myDispatcher.getMulticaster()).dataSourceChanged(dataSource);
                }
            }, this);
        }
    }

    private void addDataSourcesInner(@NotNull Iterable<LocalDataSource> dataSources) {
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORAGE_ENTRY_NAME, "com/intellij/database/dataSource/DataSourceStorage", "addDataSourcesInner"));
        }
        for (LocalDataSource dataSource : dataSources) {
            this.addDataSourceInner(dataSource);
        }
    }

    private void addDataSourceInner(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage", "addDataSourceInner"));
        }
        this.myDataSources.add(dataSource);
        dataSource.addListener(this.myDataSourceListener);
    }

    private boolean removeDataSourceInner(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage", "removeDataSourceInner"));
        }
        boolean removed = this.myDataSources.remove(dataSource);
        if (removed) {
            dataSource.removeListener(this.myDataSourceListener);
        }
        return removed;
    }

    private void removeAllDataSources() {
        ArrayList<LocalDataSource> existentDataSources = new ArrayList<LocalDataSource>(this.myDataSources);
        for (LocalDataSource dataSource : existentDataSources) {
            this.removeDataSourceInner(dataSource);
        }
    }

    private boolean hasDataSources() {
        return !this.myDataSources.isEmpty();
    }

    private boolean isEmpty() {
        return this.myDataSources.isEmpty();
    }

    @Nullable
    private static LocalDataSource createExtDataSource(Project project, String sourceName, String name) {
        for (DataSourceProviderFactory factory : (DataSourceProviderFactory[])Extensions.getExtensions((ExtensionPointName)DataSourceProviderFactory.EP_NAME)) {
            DataSourceProvider dataSourceProvider = factory.getDataSourceProvider(name);
            if (dataSourceProvider == null) continue;
            DataSource dataSource = dataSourceProvider.createNewDataInstance(project, sourceName);
            if (dataSource instanceof LocalDataSource) {
                return (LocalDataSource)dataSource;
            }
            if (dataSource == null) continue;
            LOG.error(String.format("Unsupported DataSource class %s when supported %s only", dataSource.getClass().getName(), LocalDataSource.class.getSimpleName()));
        }
        return null;
    }

    public List<LocalDataSource> getDataSources() {
        return this.getDataSources(new ArrayList());
    }

    public <T extends Collection<LocalDataSource>> T getDataSources(T result2) {
        result2.addAll(this.myDataSources);
        if (this.myParentStorage != null) {
            this.myParentStorage.getDataSources(result2);
        }
        return result2;
    }

    public void addDataSource(LocalDataSource dataSource) {
        LocalDataSource existing;
        LocalDataSource localDataSource = existing = dataSource.getUniqueId() == null ? null : this.getDataSourceById(dataSource.getUniqueId());
        if (existing != null) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): '%s' (%s@%d) has the same id: %s", this.myParentStorage == null ? "global" : "project", dataSource.getName(), dataSource.getClass().getSimpleName(), dataSource.hashCode(), existing.getName(), existing.getClass().getSimpleName(), existing.hashCode(), dataSource.getUniqueId()));
        }
        if (dataSource.isGlobal() && this.myParentStorage != null) {
            this.myParentStorage.addDataSource(dataSource);
        } else {
            dataSource.init();
            this.addDataSourceInner(dataSource);
            this.incModificationCount();
            ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceAdded(dataSource);
        }
    }

    @Nullable
    public LocalDataSource getDataSourceByName(String name) {
        for (LocalDataSource dataSource : this.getDataSources()) {
            if (!dataSource.getName().equalsIgnoreCase(name)) continue;
            return dataSource;
        }
        return null;
    }

    @Nullable
    public LocalDataSource getDataSourceById(String id) {
        return DataSourceStorage.getDataSourcesByIdInner(id, this.getDataSources());
    }

    @Nullable
    private static <L extends AbstractDataSource> L getDataSourcesByIdInner(@Nullable String id, @NotNull Collection<? extends L> dataSources) {
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORAGE_ENTRY_NAME, "com/intellij/database/dataSource/DataSourceStorage", "getDataSourcesByIdInner"));
        }
        for (AbstractDataSource dataSource : dataSources) {
            LOG.assertTrue(dataSource.getUniqueId() != null);
            if (!dataSource.getUniqueId().equals(id)) continue;
            return (L)((Object)dataSource);
        }
        return null;
    }

    public void removeDataSource(LocalDataSource dataSource) {
        if (this.removeDataSourceInner(dataSource)) {
            this.incModificationCount();
            ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceRemoved(dataSource);
        } else if (this.myParentStorage != null) {
            this.myParentStorage.removeDataSource(dataSource);
        }
    }

    public void addDataSourceListener(DataSourceListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addDataSourceListener(DataSourceListener listener, Disposable parent) {
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void removeDataSourceListener(DataSourceListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void updateDataSource(LocalDataSource dataSource) {
        boolean isMy = this.myDataSources.contains(dataSource);
        if (this.myParentStorage != null && dataSource.isGlobal() == isMy) {
            this.removeDataSource(dataSource);
            this.addDataSource(dataSource);
        } else if (isMy) {
            this.incModificationCount();
            ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceChanged(dataSource);
        } else if (this.myParentStorage != null) {
            this.myParentStorage.updateDataSource(dataSource);
        }
        dataSource.incModificationCount();
    }

    public long getModificationCount() {
        if (this.myParentStorage != null) {
            return super.getModificationCount() + this.myParentStorage.getModificationCount();
        }
        return super.getModificationCount();
    }

    public void dispose() {
    }

    public Element getState() {
        Element element = new Element(COMPONENT_NAME);
        this.writeState(null, element);
        return element;
    }

    public void loadState(Element state) {
        this.readState(null, state);
    }

    public void writeLocalState(@Nullable Project project) {
        Element element = new Element("dataSourceStorageLocal");
        JDomWriter serializer = new JDomWriter(element);
        for (LocalDataSource dataSource : this.myDataSources) {
            dataSource.serialize(project, (HierarchicalStreamWriter)serializer, LocalDataSource.SaveMode.LOCAL_CONFIG);
        }
        DataSourceStorageLocal.getInstance(project).loadState(element);
    }

    private static void readLocalState(@Nullable Element element, @Nullable Project project, boolean isGlobal, @NotNull Collection<LocalDataSource> dataSources, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORAGE_ENTRY_NAME, "com/intellij/database/dataSource/DataSourceStorage", "readLocalState"));
        }
        if (element == null) {
            for (LocalDataSource dataSource : dataSources) {
                if (!StringUtil.isEmpty((String)dataSource.getUsername())) continue;
                dataSource.setUseMasterKeyStorage(false);
            }
        } else {
            DataSourceStorage.readDataSources((HierarchicalStreamReader)new JDomReader(element), LocalDataSource.SaveMode.LOCAL_CONFIG, project, isGlobal, dataSources, newDataSourcesConsumer);
        }
    }

    void readState(final Project project, Element element) {
        if (project != null && project.isDefault()) {
            return;
        }
        this.myFormat = DataSourceStorage.readFormat(element);
        this.myMultiFileModel = DataSourceStorage.isMultiFileModel(element);
        this.incModificationCount();
        this.removeAllDataSources();
        boolean isGlobal = this.myParentStorage == null;
        DataSourceStorageLocal storageLocal = DataSourceStorageLocal.getInstance(project);
        ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
        JDomReader domReader = new JDomReader(element);
        DataSourceStorage.readDataSources((HierarchicalStreamReader)domReader, LocalDataSource.SaveMode.CONFIG, project, isGlobal, Collections.emptySet(), newDataSources::add);
        DataSourceStorage.readLocalState(storageLocal.getState(), project, isGlobal, newDataSources, newDataSources::add);
        for (LocalDataSource dataSource : newDataSources) {
            dataSource.setLoading(true);
        }
        this.addDataSourcesInner(newDataSources);
        ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceChanged(null);
        Application application = ApplicationManager.getApplication();
        Condition condition = project == null ? application.getDisposed() : project.getDisposed();
        application.executeOnPooledThread(() -> {
            Project proj;
            if (condition.value(null)) {
                return;
            }
            ErrorHandler errorHandler = new ErrorHandler();
            try {
                this.loadModels(project, errorHandler);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            for (LocalDataSource dataSource : this.myDataSources) {
                if (!dataSource.isLoading()) continue;
                dataSource.clearModel();
                dataSource.setLoading(false);
            }
            Project project2 = proj = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
            if (!proj.isDisposed() && DbSrcValidator.isEnabled()) {
                new Task.Backgroundable(proj, "Validating Sources", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceStorage$3", "run"));
                        }
                        if (proj.isDisposed()) {
                            return;
                        }
                        Couple<List<LocalDataSource>> result2 = new DbSrcValidator().collect(project, DataSourceStorage.this.myDataSources);
                        if (proj.isDisposed() || ((List)result2.first).isEmpty() && ((List)result2.second).isEmpty()) {
                            return;
                        }
                        if (!((List)result2.second).isEmpty()) {
                            DbSrcValidator.suggestIntrospecting(proj, (List)result2.second);
                        }
                        if (!((List)result2.first).isEmpty()) {
                            DbSrcValidator.regenerateSources(proj, (List)result2.first);
                        }
                    }
                }.queue();
            }
            GuiUtils.invokeLaterIfNeeded(() -> {
                ((DataSourceListener)this.myDispatcher.getMulticaster()).dataSourceChanged(null);
                FileContentUtil.reparseOpenedFiles();
                String summary = errorHandler.getSummary();
                if (StringUtil.isNotEmpty((String)summary)) {
                    String title = (project == null ? "Global" : "Project") + " Data Sources: re-sync required";
                    Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR);
                    notification.notify(project);
                }
            }, (ModalityState)ModalityState.defaultModalityState(), (Condition)condition);
        });
    }

    private static boolean isMultiFileModel(Element element) {
        return "true".equals(element.getAttributeValue(MULTIFILE_MODEL));
    }

    private boolean loadModels(@Nullable Project project, @NotNull ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DataSourceStorage", "loadModels"));
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        ArrayList newDataSources = ContainerUtil.newArrayList(this.myDataSources);
        String path = DataSourceStorage.getStoragePath(project);
        boolean migrating = !this.myMultiFileModel && FileUtil.exists((String)path);
        this.myMultiFileModel = true;
        boolean failed = migrating && this.loadFromDisk(project, path, LocalDataSource.SaveMode.SCHEMA, errorHandler) == null;
        for (LocalDataSource source : newDataSources) {
            try {
                boolean loaded = this.readModel(project, source, false);
                if (loaded) continue;
                if (migrating && source.getModel() != DasUtil.emptyModel()) {
                    failed |= !this.writeModel(project, source);
                    continue;
                }
                if (migrating || !(loaded = this.readModel(project, source, true))) continue;
                failed |= !this.writeModel(project, source);
            }
            catch (Exception e) {
                failed = true;
                String file = this.getModelPath(project, source, false);
                if (file != null) {
                    DataSourceStorage.processCorruption(new File(file), e);
                }
                errorHandler.addError(e.getMessage(), e);
            }
        }
        if (failed) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        Condition expired = project == null ? app.getDisposed() : project.getDisposed();
        app.invokeLater(() -> app.runWriteAction(() -> this.cleanupOldFiles(project, newDataSources)), expired);
        this.incModificationCount();
        return true;
    }

    private void cleanupOldFiles(@Nullable Project project, @NotNull List<LocalDataSource> newDataSources) {
        VirtualFile root2;
        if (newDataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDataSources", "com/intellij/database/dataSource/DataSourceStorage", "cleanupOldFiles"));
        }
        String dir = DataSourceStorage.getStorageDir(project);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = root2 = dir == null ? null : lfs.refreshAndFindFileByPath(dir);
        if (root2 == null) {
            return;
        }
        HashSet toKeep = ContainerUtil.newHashSet();
        HashSet uids = ContainerUtil.newHashSet();
        for (LocalDataSource source : newDataSources) {
            uids.add(source.getUniqueId());
            if (source.getModel() == DasUtil.emptyModel()) continue;
            String path = this.getModelPath(project, source, false);
            ContainerUtil.addIfNotNull((Collection)toKeep, path == null ? null : lfs.findFileByPath(path));
        }
        Pattern filePattern = Pattern.compile("\\p{XDigit}{8}(?:-\\p{XDigit}{4}){3}-\\p{XDigit}{12}\\.xml");
        Condition keep = f -> toKeep.contains(f) || uids.stream().anyMatch(uid -> f.getName().startsWith((String)uid));
        for (VirtualFile file : root2.getChildren()) {
            if (!filePattern.matcher(file.getName()).matches() || keep.value((Object)file)) continue;
            try {
                file.delete((Object)this);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static Format readFormat(Element element) {
        String formatAttr = element.getAttributeValue(FORMAT_ATTR_NAME);
        if (formatAttr != null) {
            Format format;
            try {
                format = Format.valueOf(formatAttr.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                Format format2 = Format.XML;
                if (format2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage", "readFormat"));
                }
                return format2;
            }
            if (format == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage", "readFormat"));
            }
            return format;
        }
        String oldCompressedAttr = element.getAttributeValue(COMPRESSED_ATTR_NAME);
        Format format = Boolean.parseBoolean(oldCompressedAttr) ? Format.COMPRESSED_XML : Format.XML;
        if (format == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage", "readFormat"));
        }
        return format;
    }

    void writeState(Project project, Element element) {
        if (project != null && project.isDefault()) {
            return;
        }
        this.writeStateInner(project, element);
    }

    @Nullable
    public static String getStoragePath(@Nullable Project project) {
        String path;
        if (project == null) {
            path = PathManager.getOptionsPath() + "/" + APP_STORAGE_FILE;
        } else {
            if (project.isDisposed()) {
                return null;
            }
            if (ProjectKt.isDirectoryBased((Project)project)) {
                String ideaFolder = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
                if (ideaFolder == null) {
                    return null;
                }
                return ideaFolder + '/' + APP_STORAGE_FILE;
            }
            String projectFilePath = project.getProjectFilePath();
            if (projectFilePath == null) {
                return null;
            }
            path = FileUtil.getNameWithoutExtension((String)projectFilePath) + "." + "ids";
        }
        return FileUtil.toSystemIndependentName((String)path);
    }

    @Nullable
    public static String getStorageDir(@Nullable Project project) {
        IProjectStore projectStore;
        String path = DataSourceStorage.getStoragePath(project);
        if (project != null && !project.isDisposed() && path != null && (projectStore = ProjectKt.getStateStore((Project)project)).getStorageScheme() == StorageScheme.DEFAULT) {
            return PathUtil.getParentPath((String)path) + "/.ideaDataSources";
        }
        return path == null ? null : PathUtil.getParentPath((String)path) + "/dataSources";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeModel(@Nullable Project project, @NotNull LocalDataSource dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage", "writeModel"));
        }
        if (project != null && (project.isDefault() || project.isDisposed())) {
            return false;
        }
        String path = this.getModelPath(project, dataSource, false);
        if (path == null) {
            return false;
        }
        if (DataSourceStorage.isReadonly(project, path)) {
            LOG.warn("Unable to save model. File is readonly: " + path);
            return false;
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        File file = new File(path);
        FileUtil.createParentDirs((File)file);
        DasModel model = dataSource.getModel();
        if (model.getModelRoots().isEmpty()) {
            FileUtil.delete((File)file);
            return false;
        }
        Object object = this.lock(dataSource);
        synchronized (object) {
            return DataSourceStorage.writeModel(file, model, dataSource.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeModel(@NotNull File file, @NotNull DasModel model, @NotNull String name) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/DataSourceStorage", "writeModel"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DataSourceStorage", "writeModel"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DataSourceStorage", "writeModel"));
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new SafeFileOutputStream(file), "UTF-8"));
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try (PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);){
            writer.startNode("dataSource");
            writer.addAttribute("name", name);
            ModelSerializerKt.serialize(model, (HierarchicalStreamWriter)writer);
            writer.endNode();
            boolean bl = true;
            return bl;
        }
    }

    private static boolean isReadonly(@Nullable Project project, @NotNull String path) {
        VirtualFile virtualFile;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/DataSourceStorage", "isReadonly"));
        }
        VirtualFile virtualFile2 = virtualFile = project == null ? null : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        if (virtualFile == null) {
            return false;
        }
        boolean[] readOnly = new boolean[1];
        UIUtil.invokeAndWaitIfNeeded(() -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            readOnly[0] = !project.isDisposed() && !ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        }));
        return readOnly[0];
    }

    public boolean readModel(@Nullable Project project, @NotNull LocalDataSource dataSource, boolean oldMistakenFile) throws IOException {
        File file;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage", "readModel"));
        }
        if (project != null && project.isDefault()) {
            return false;
        }
        String path = this.getModelPath(project, dataSource, oldMistakenFile);
        File file2 = file = path == null ? null : new File(path);
        if (file == null || !file.exists()) {
            return false;
        }
        DasModel model = DataSourceStorage.readModel(DbSrcModelStorage.createFactory(project, dataSource), file);
        if (model == null) {
            return false;
        }
        dataSource.setModel(model);
        dataSource.setLoading(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DasModel readModel(@NotNull ModelFactory modelFactory, @NotNull File file) throws IOException {
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/dataSource/DataSourceStorage", "readModel"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/DataSourceStorage", "readModel"));
        }
        try (XppReader reader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("database-model".equals(reader.getNodeName())) {
                    BasicModModel model;
                    BasicModModel basicModModel = model = ModelSerializerKt.deserialize((HierarchicalStreamReader)reader, modelFactory);
                    return basicModModel;
                }
                reader.moveUp();
            }
        }
        return null;
    }

    @Nullable
    protected String getModelPath(@Nullable Project project, @NotNull LocalDataSource dataSource, boolean oldMistakenPlace) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage", "getModelPath"));
        }
        String dir = DataSourceStorage.getStorageDir(project);
        if (dir != null && project != null && oldMistakenPlace) {
            dir = PathUtil.getParentPath((String)dir) + "/" + project.getName();
        }
        return dir == null ? null : dir + "/" + dataSource.getUniqueId() + ".xml";
    }

    public Element getStateInner(@Nullable Project project) {
        Element element = new Element(COMPONENT_NAME);
        this.writeStateInner(project, element);
        return element;
    }

    private void writeStateInner(Project project, Element element) {
        if (this.hasDataSources() || this.myFormat != Format.XML) {
            element.setAttribute(FORMAT_ATTR_NAME, this.myFormat.name().toLowerCase(Locale.ENGLISH));
            if (this.myMultiFileModel) {
                element.setAttribute(MULTIFILE_MODEL, "true");
            }
        }
        if (this.hasDataSources()) {
            JDomWriter serializer = new JDomWriter(element);
            for (LocalDataSource dataSource : this.myDataSources) {
                dataSource.serialize(project, (HierarchicalStreamWriter)serializer, LocalDataSource.SaveMode.CONFIG);
            }
        }
        this.writeLocalState(project);
    }

    private static void readDataSources(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource.SaveMode mode, @Nullable Project project, boolean isGlobal, @NotNull Collection<LocalDataSource> dataSources, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/DataSourceStorage", "readDataSources"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/DataSourceStorage", "readDataSources"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORAGE_ENTRY_NAME, "com/intellij/database/dataSource/DataSourceStorage", "readDataSources"));
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String source = (String)ObjectUtils.chooseNotNull((Object)xmlReader.getAttribute(DATA_SOURCE_SOURCE_NAME), (Object)xmlReader.getAttribute("source"));
            if ("data-source".equals(xmlReader.getNodeName())) {
                LocalDataSource dataSource;
                LocalDataSource existingDataSource;
                String uuid = xmlReader.getAttribute("uuid");
                LocalDataSource localDataSource = existingDataSource = uuid == null ? null : DataSourceStorage.getDataSourcesByIdInner(uuid, dataSources);
                if ((existingDataSource != null || mode.includeConfig()) && (dataSource = existingDataSource != null ? existingDataSource : (source == null || "LOCAL".equals(source) ? new LocalDataSource() : DataSourceStorage.createExtDataSource(project, source, source))) != null) {
                    dataSource.deserialize(project, xmlReader, mode);
                    dataSource.setGlobal(isGlobal);
                    dataSource.init();
                    if (!(dataSource == existingDataSource || dataSource.getDatabaseDriver() != null && dataSource.getOwnClasspath().isEmpty())) {
                        dataSource.ensureDriverConfigured();
                    }
                    if (existingDataSource != dataSource && newDataSourcesConsumer != null) {
                        newDataSourcesConsumer.accept(dataSource);
                    }
                }
            }
            xmlReader.moveUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToDisk(@Nullable Project project, @NotNull String storagePath, LocalDataSource.SaveMode mode) {
        if (storagePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storagePath", "com/intellij/database/dataSource/DataSourceStorage", "writeToDisk"));
        }
        File original = new File(PathUtil.toPresentableUrl((String)storagePath));
        if (this.isEmpty()) {
            FileUtil.delete((File)original);
            return true;
        }
        if (!original.exists()) {
            FileUtil.createParentDirs((File)original);
        }
        Object serializer = null;
        String errorMessage = null;
        try {
            Object os;
            SafeFileOutputStream safeStream = new SafeFileOutputStream(original);
            boolean compressed = this.myFormat == Format.COMPRESSED_XML || this.myFormat == Format.COMPRESSED_JSON;
            boolean isXml = this.myFormat == Format.XML || this.myFormat == Format.COMPRESSED_XML;
            Object object = os = compressed ? new ZipOutputStream((OutputStream)safeStream) : safeStream;
            if (os instanceof ZipOutputStream) {
                ((ZipOutputStream)os).putNextEntry(new ZipEntry(STORAGE_ENTRY_NAME + (isXml ? ".xml" : ".json")));
            }
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            if (isXml) {
                serializer = new PrettyPrintWriter((Writer)printWriter);
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            } else {
                serializer = new JsonWriter(printWriter, new JsonWriter.Format(new char[]{' '}, new char[]{'\n'}, 2)){

                    protected void addValue(String value, AbstractJsonWriter.Type type) {
                        super.addValue(value, AbstractJsonWriter.Type.STRING);
                    }
                };
            }
            serializer.startNode("component");
            serializer.addAttribute("name", COMPONENT_NAME);
            for (LocalDataSource dataSource : this.myDataSources) {
                dataSource.serialize(project, (HierarchicalStreamWriter)serializer, mode);
            }
            serializer.endNode();
            serializer.close();
        }
        catch (XStreamException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        finally {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
            }
        }
        if (errorMessage != null) {
            LOG.warn(errorMessage);
            DataSourceUiUtil.showNotification(project, "", "Failed to save data sources:<br>" + errorMessage, true);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<LocalDataSource> loadFromDisk(Project project, String storagePath, LocalDataSource.SaveMode mode, @Nullable ErrorHandler errorHandler) {
        block22: {
            List<LocalDataSource> list;
            File file;
            File file2 = file = storagePath == null ? null : new File(PathUtil.toPresentableUrl((String)storagePath));
            if (file == null || !file.exists() || file.isDirectory()) {
                return null;
            }
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                boolean isReallyZip = false;
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    boolean isXml = Comparing.equal((String)zipEntry.getName(), (String)STATE_FILE);
                    if (isXml || Comparing.equal((String)zipEntry.getName(), (String)"dataSources.json")) {
                        List<LocalDataSource> list2 = this.loadFromDisk(project, zis, isXml, errorHandler, mode);
                        return list2;
                    }
                    isReallyZip = true;
                    zipEntry = zis.getNextEntry();
                }
                if (isReallyZip) {
                    LOG.warn("No datasource entries found in: " + file);
                    break block22;
                }
                list = this.loadFromDisk(project, new FileInputStream(file), this.checkXml(file), errorHandler, mode);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                DataSourceStorage.processCorruption(file, e);
                break block22;
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return list;
        }
        return null;
    }

    public static void processCorruption(File file, Exception e) {
        String message = e.getMessage();
        if (message != null && message.length() > 1024) {
            RuntimeException truncated = new RuntimeException(message.substring(0, 1024) + "...");
            truncated.setStackTrace(e.getStackTrace());
            e = truncated;
        }
        LOG.warn((Throwable)e);
        DataSourceStorage.backupCorruptedVersion(file);
    }

    protected boolean checkXml(File file) throws IOException {
        try (InputStreamReader formatPicker = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            boolean bl = StringUtil.isNotEmpty((String)NanoXmlUtil.parseHeader((Reader)formatPicker).getRootTagLocalName());
            return bl;
        }
    }

    protected List<LocalDataSource> loadFromDisk(Project project, InputStream stream, boolean isXml, @Nullable ErrorHandler errorHandler, LocalDataSource.SaveMode mode) throws UnsupportedEncodingException {
        InputStreamReader fileReader = new InputStreamReader(stream, "UTF-8");
        return this.loadDataSources(project, (HierarchicalStreamReader)(isXml ? new XppReader((Reader)fileReader) : new JettisonMappedXmlDriver().createReader((Reader)fileReader)), mode, errorHandler);
    }

    private static void backupCorruptedVersion(File file) {
        if (file.exists()) {
            try {
                String backupName = FileUtil.getNameWithoutExtension((File)file) + ".corrupted." + new SimpleDateFormat("yyyyMMdd-hhmmss").format(new Date(System.currentTimeMillis())) + "." + FileUtilRt.getExtension((String)file.getName());
                File backup = new File(file.getParentFile(), backupName);
                FileUtil.copy((File)file, (File)backup);
                String message = file.getAbsolutePath() + " is corrupted. Backup copy " + backup.getName() + " is created.";
                Notification notification = new Notification("System Messages", "Failed to load data sources", message, NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocalDataSource> loadDataSources(Project project, HierarchicalStreamReader reader, LocalDataSource.SaveMode mode, final ErrorHandler errorHandler) {
        MyReader wrapper = new MyReader(reader){

            public void appendErrors(ErrorWriter errorWriter) {
                super.appendErrors(errorWriter);
                if (errorHandler != null && errorWriter instanceof ConversionException) {
                    errorHandler.addError(((ConversionException)errorWriter).getShortMessage(), null);
                }
            }
        };
        try {
            if ("component".equals(reader.getNodeName())) {
                ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
                DataSourceStorage.readDataSources((HierarchicalStreamReader)wrapper, mode, project, this.myParentStorage == null, this.myDataSources, newDataSources::add);
                ArrayList<LocalDataSource> arrayList = newDataSources;
                return arrayList;
            }
            List<LocalDataSource> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    DataSourceListener createSavingListener(final @Nullable Project project) {
        return new DataSourceListener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$6", "dataSourceAdded"));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$6", "dataSourceRemoved"));
                }
                Map map = DataSourceStorage.this.myLocks;
                synchronized (map) {
                    DataSourceStorage.this.myLocks.remove(dataSource.getUniqueId());
                }
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null || !DataSourceStorage.this.myDataSources.contains(dataSource) || dataSource.isInBatch() || dataSource.isLoading()) {
                    return;
                }
                try {
                    DataSourceStorage.this.writeModel(project, dataSource);
                }
                catch (IOException e) {
                    LOG.error("Failed to save model for: " + dataSource.getName(), (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Object lock(@NotNull LocalDataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/DataSourceStorage", "lock"));
        }
        Map<String, Object> map = this.myLocks;
        // MONITORENTER : map
        Object object = this.myLocks.get(ds.getUniqueId());
        // MONITOREXIT : map
        if (object != null) return object;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage", "lock"));
    }

    private static class MyReader
    extends ReaderWrapper {
        public MyReader(HierarchicalStreamReader reader) {
            super(reader);
        }

        public String getNodeName() {
            return DbUtil.intern2((String)super.getNodeName());
        }

        public String getValue() {
            return DbUtil.intern2((String)super.getValue());
        }

        public String getAttribute(String name) {
            return DbUtil.intern2((String)super.getAttribute(name));
        }

        public String getAttribute(int index) {
            return DbUtil.intern2((String)super.getAttribute(index));
        }
    }

    @State(name="dataSourceStorage", storages={@Storage(value="dataSources.xml", roamingType=RoamingType.DISABLED)})
    public static class App
    extends DataSourceStorage
    implements PersistentStateComponent<Element> {
        public App(VirtualFileManager fileManager, LibraryTablesRegistrar libraryTablesRegistrar) {
            super(null);
            this.addDataSourceListener(this.createSavingListener(null));
        }
    }

    private static enum Format {
        XML,
        JSON,
        COMPRESSED_XML,
        COMPRESSED_JSON;

    }
}

