/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSyncManager {
    private static final Logger LOG = Logger.getInstance(DataSourceSyncManager.class);
    private static final DataSourceSyncManager INSTANCE = new DataSourceSyncManager();
    private static final DatabaseExecutor NEW_CONNECTION_EXECUTOR = (t, path, op) -> DatabaseConnectionManager.getInstance().build(t.context.getProject(), t.context.getDataSource()).setDestination(path).sync(c -> {
        op.consume((Object)c);
        return null;
    }, t.context.getErrorHandler());
    private final MultiMap<Object, SyncProcessor> myActive = MultiMap.create();

    public static DataSourceSyncManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAbleToPerform(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSyncManager", "isAbleToPerform"));
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            return !this.myActive.containsKey(DataSourceSyncManager.getKey(dataSource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletionStage<SyncResult> tryPerform(@NotNull LoaderContext context, boolean kickExisting, @Nullable DatabaseExecutor executor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DataSourceSyncManager", "tryPerform"));
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key = DataSourceSyncManager.getKey(context.getDataSource());
            Collection queue = this.myActive.getModifiable(key);
            if (!queue.isEmpty() && !kickExisting) {
                return null;
            }
            SyncProcessor processor = new SyncProcessor(new SyncTask(context), executor);
            SyncProcessor current = DataSourceSyncManager.shrinkQueueRunning(queue);
            queue.add(processor);
            return current == null ? this.startProcessor(key, processor) : DataSourceSyncManager.queuedProcessor(processor);
        }
    }

    @Nullable
    public CompletionStage<SyncResult> tryPerform(@NotNull LoaderContext context, boolean kickExisting) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DataSourceSyncManager", "tryPerform"));
        }
        return this.tryPerform(context, kickExisting, null);
    }

    @NotNull
    private static Object getKey(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSyncManager", "getKey"));
        }
        String uniqueId = dataSource.getUniqueId();
        if (uniqueId != null) {
            String string = uniqueId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSyncManager", "getKey"));
            }
            return string;
        }
        Object object = ObjectUtils.chooseNotNull((Object)dataSource.getUrl(), (Object)"");
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSyncManager", "getKey"));
        }
        return object;
    }

    @Nullable
    private static SyncProcessor shrinkQueueRunning(@NotNull Collection<SyncProcessor> queue) {
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/database/dataSource/DataSourceSyncManager", "shrinkQueueRunning"));
        }
        SyncProcessor first = null;
        if (queue.size() < 2) {
            return (SyncProcessor)ContainerUtil.getFirstItem(queue);
        }
        ArrayList toStop = ContainerUtil.newArrayList();
        Iterator<SyncProcessor> it = queue.iterator();
        while (it.hasNext()) {
            if (first == null) {
                first = it.next();
                continue;
            }
            toStop.add(it.next());
            it.remove();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (SyncProcessor processor : toStop) {
                try {
                    processor.myResult.cancel(false);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        });
        return first;
    }

    @NotNull
    private static CompletionStage<SyncResult> queuedProcessor(@NotNull SyncProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/DataSourceSyncManager", "queuedProcessor"));
        }
        CompletableFuture completableFuture = processor.myResult;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSyncManager", "queuedProcessor"));
        }
        return completableFuture;
    }

    @NotNull
    private CompletionStage<SyncResult> startProcessor(@NotNull Object key, @NotNull SyncProcessor processor) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/DataSourceSyncManager", "startProcessor"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/DataSourceSyncManager", "startProcessor"));
        }
        CompletionStage<SyncResult> completionStage = processor.run().whenComplete((r, ignored) -> {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/DataSourceSyncManager", "lambda$startProcessor$4"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/DataSourceSyncManager", "lambda$startProcessor$4"));
            }
            MultiMap<Object, SyncProcessor> multiMap = this.myActive;
            synchronized (multiMap) {
                Collection queue = this.myActive.getModifiable(key);
                if (ContainerUtil.getFirstItem((Collection)queue) != processor) {
                    LOG.warn("Unexpected sync queue corruption");
                }
                queue.remove(processor);
                if (queue.isEmpty()) {
                    this.myActive.remove(key);
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (key == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/DataSourceSyncManager", "lambda$null$3"));
                        }
                        return this.startProcessor(key, (SyncProcessor)queue.iterator().next());
                    });
                }
            }
        });
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSyncManager", "startProcessor"));
        }
        return completionStage;
    }

    private static class SyncProcessor {
        private final SyncTask myTask;
        private final CompletableFuture<SyncResult> myResult;
        private final long myStartTime;
        private final MyProgress myProgress;
        private final TransactionId myTransactionId;
        private final DatabaseExecutor myDbExecutor;
        private long mySyncStartTime;

        public SyncProcessor(@NotNull SyncTask task, @Nullable DatabaseExecutor executor) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor", "<init>"));
            }
            this.myProgress = new MyProgress();
            this.myTask = task;
            this.myResult = new CompletableFuture();
            this.myStartTime = System.currentTimeMillis();
            this.myTransactionId = TransactionGuard.getInstance().getContextTransaction();
            this.myDbExecutor = executor != null ? executor : NEW_CONNECTION_EXECUTOR;
        }

        public void cancel() {
            this.myProgress.cancel();
        }

        @NotNull
        public CompletionStage<SyncResult> run() {
            CompletionStage<SyncResult> completionStage = AsyncUtil.supplyAsync(() -> this.prepareAndRefresh(), AsyncUtil.transactionExecutor((Disposable)this.myTask.context.getProject(), this.myTransactionId)).whenComplete((r, e) -> {
                if (e != null) {
                    this.myResult.completeExceptionally((Throwable)e);
                } else {
                    this.myResult.complete((SyncResult)r);
                }
            });
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor", "run"));
            }
            return completionStage;
        }

        private CompletionStage<SyncResult> prepareAndRefresh() {
            ProgressIndicator indicator;
            if (this.myTask.context.getProject().isOpen() && (indicator = this.myProgress.start()) != null) {
                try {
                    return ((CompletableFuture)AsyncUtil.underProgress(() -> {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        return CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(this::performSync), AsyncUtil.POOL_EXECUTOR);
                    }, indicator)).whenComplete((r, e) -> this.myProgress.stop());
                }
                catch (Throwable e2) {
                    this.myProgress.stop();
                    return AsyncUtil.exceptional(e2);
                }
            }
            return AsyncUtil.cancelled();
        }

        @NotNull
        private SyncResult performSync() {
            this.mySyncStartTime = System.currentTimeMillis();
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator == null) {
                indicator = new EmptyProgressIndicator();
            }
            try {
                new DatabaseModelLoader.IntrospectionSession(this.myTask.context, indicator, this.myTransactionId){

                    @Override
                    public void perform(@Nullable ObjectPath path, @NotNull ThrowableConsumer<DatabaseConnection, Exception> consumer) throws SQLException {
                        if (consumer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor$1", "perform"));
                        }
                        myDbExecutor.perform(myTask, path, consumer);
                    }
                }.run();
            }
            catch (SQLException e) {
                AsyncUtil.addUnhandledError(this.myTask.context.getErrorHandler(), e, this.myTask.context.getDataSource().getName(), DbImplUtil.getDatabaseDialect(this.myTask.context.getDataSource()).getFamilyId());
                throw new ProcessCanceledException();
            }
            finally {
                DbSrcUtils.refresh();
            }
            SyncResult syncResult = new SyncResult(this.myTask, System.currentTimeMillis() - this.myStartTime);
            if (syncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor", "performSync"));
            }
            return syncResult;
        }

        private class MyProgress {
            private boolean myCanceled = false;
            private ProgressIndicatorEx myIndicator;

            private MyProgress() {
            }

            public synchronized void cancel() {
                if (this.myIndicator != null) {
                    this.myIndicator.cancel();
                }
                this.myCanceled = true;
            }

            @Nullable
            public synchronized ProgressIndicator start() {
                if (this.myCanceled) {
                    return null;
                }
                this.myIndicator = this.createIndicator();
                this.myIndicator.start();
                return this.myIndicator;
            }

            public synchronized void stop() {
                if (this.myIndicator == null) {
                    return;
                }
                this.myIndicator.stop();
                this.myIndicator.processFinish();
            }

            private ProgressIndicatorEx createIndicator() {
                return AsyncUtil.createBackgroundIndicator(((SyncProcessor)SyncProcessor.this).myTask.context.getProject(), ((SyncProcessor)SyncProcessor.this).myTask.context.getDataSource().getName());
            }
        }
    }

    public static class SyncTask {
        public final LoaderContext context;

        public SyncTask(@NotNull LoaderContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DataSourceSyncManager$SyncTask", "<init>"));
            }
            this.context = context;
        }
    }

    public static class SyncResult {
        public final long elapsedTime;
        public final SyncTask task;

        public SyncResult(SyncTask task, long elapsedTime) {
            this.task = task;
            this.elapsedTime = elapsedTime;
        }
    }

    public static interface DatabaseExecutor {
        public void perform(@NotNull SyncTask var1, @Nullable ObjectPath var2, @NotNull ThrowableConsumer<DatabaseConnection, Exception> var3);
    }
}

