/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.MssqlDialect;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.db2.Db2;
import com.intellij.database.model.derby.Derby;
import com.intellij.database.model.hsql.HsqlDB;
import com.intellij.database.model.redshift.Redshift;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.UI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;

public class DataSourceUiUtil {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceUiUtil");
    private static final SyncDateFormat ourTimestampFormat = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private DataSourceUiUtil() {
    }

    @Nullable
    public static Rdbms getRdbmsForIntrospection(@Nullable DatabaseFamilyId familyId) {
        if (familyId == DatabaseFamilyId.ORACLE) {
            return Oracle.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MYSQL) {
            return Mysql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MARIADB) {
            return Mysql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.POSTGRES) {
            return Postgres.RDBMS;
        }
        if (familyId == DatabaseFamilyId.REDSHIFT) {
            return Redshift.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MSSQL) {
            return Mssql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.SYBASE) {
            return Sybase.RDBMS;
        }
        if (familyId == DatabaseFamilyId.DB2) {
            return Db2.RDBMS;
        }
        if (familyId == DatabaseFamilyId.DERBY) {
            return Derby.RDBMS;
        }
        if (familyId == DatabaseFamilyId.H2) {
            return H2db.RDBMS;
        }
        if (familyId == DatabaseFamilyId.HSQLDB) {
            return HsqlDB.RDBMS;
        }
        if (familyId == DatabaseFamilyId.SQLITE) {
            return Sqlite.RDBMS;
        }
        return null;
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "performAutoSyncTask"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceUiUtil", "performAutoSyncTask"));
        }
        DataSourceUiUtil.performAutoSyncTask(project, dataSource, null);
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable IntrospectionScopeUpdater scopeUpdater) {
        CompletionStage<DataSourceSyncManager.SyncResult> result2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "performAutoSyncTask"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceUiUtil", "performAutoSyncTask"));
        }
        if (!DbImplUtil.canConnectTo(dataSource) || !dataSource.isAutoSynchronize()) {
            return;
        }
        LoaderContext context = LoaderContext.loadAll(project, dataSource);
        if (scopeUpdater != null) {
            context.getScopeUpdater().merge(scopeUpdater);
        }
        if ((result2 = DataSourceSyncManager.getInstance().tryPerform(context, false)) == null) {
            return;
        }
        result2.whenComplete((r, e) -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "lambda$performAutoSyncTask$0"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceUiUtil", "lambda$performAutoSyncTask$0"));
            }
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                DataSourceUiUtil.showNotification(project, dataSource.getName(), "Cancelled", false);
            } else if (context.getErrorHandler().hasErrors()) {
                DataSourceUiUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
            }
        });
    }

    @NotNull
    public static CompletionStage<DataSourceSyncManager.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DataSourceUiUtil", "performManualSyncTask"));
        }
        CompletionStage<DataSourceSyncManager.SyncResult> result2 = DataSourceSyncManager.getInstance().tryPerform(context, false);
        if (result2 == null) {
            CompletableFuture<DataSourceSyncManager.SyncResult> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "performManualSyncTask"));
            }
            return completableFuture;
        }
        CompletionStage<DataSourceSyncManager.SyncResult> completionStage = result2.whenComplete((r, e) -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DataSourceUiUtil", "lambda$performManualSyncTask$1"));
            }
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                DataSourceUiUtil.showNotification(context.getProject(), context.getDataSource().getName(), "Cancelled", false);
            } else {
                DataSourceUiUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
            }
        });
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "performManualSyncTask"));
        }
        return completionStage;
    }

    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        String string = MessageFormat.format("Database: {0} (ver. {1})\nIdentifier case sensitivity: {5} (plain), {6} (delimited)\nDriver (JDBC{4}): {2} (ver. {3})", o.getDatabaseProductName(), o.getDatabaseProductVersion(), o.getDriverName(), o.getDriverVersion(), o.getJDBCVersion(), Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "formatDataSourceInfoString"));
        }
        return string;
    }

    public static boolean isMsSql2008(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/database/dataSource/DataSourceUiUtil", "isMsSql2008"));
        }
        DatabaseDialectEx.VersionParser parser = MssqlDialect.INSTANCE.getVersionParser();
        Version version = parser == null ? null : parser.parseVersion(versionString);
        return version == null || version.major > 10 || version.major == 10 && version.minor >= 50;
    }

    public static void showNotification(@Nullable Project project, String title, String message, boolean error) {
        final Pair<String, HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message, error ? DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]) : title, error ? Messages.getErrorIcon() : Messages.getInformationIcon());
        NotificationGroup group2 = error ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group2.createNotification(title, (String)pair.first, error ? NotificationType.WARNING : NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/dataSource/DataSourceUiUtil$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$1", "hyperlinkUpdate"));
                }
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
            }
        }).notify(project);
    }

    public static Pair<String, HyperlinkListener> truncatePopupMessageIfNeeded(String text, final String dialogTitle, final Icon icon) {
        boolean truncate;
        boolean bl = truncate = text.length() > 120;
        if (!truncate) {
            return Pair.create((Object)text, null);
        }
        String balloonMessage = text.substring(0, 120) + " ... <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        final String message = text.replace("\t", "  ");
        return Pair.create((Object)balloonMessage, (Object)new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Messages.showIdeaMessageDialog(null, (String)message, (String)dialogTitle, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)icon, null);
                }
            }
        });
    }

    public static void showErrorBalloon(Throwable error, Component component, Point point, boolean showArrow, boolean showConfig) {
        if (!component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = StringUtil.notNullize((String)error.getMessage(), (String)error.getClass().getSimpleName());
        errorText = DataSourceUiUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        final String errorFullText = ExceptionUtil.getThrowableText((Throwable)error, (String)"com.intellij.");
        String imgURL = "";
        URL resource = AllIcons.class.getClassLoader().getResource("/general/settings.png");
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String detailsLinkMessage = " <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        String balloonContent = showConfig ? "<table border=0 cellspacing=0 cellpadding=0><tr valign=top><td>" + errorText + detailsLinkMessage + "</td><td align=right>&nbsp;&nbsp;<a href=\"config\"><img alt=\"Disable error balloons\" hspace=0 vspace=0 border=0 width=16 height=16 src=\"" + imgURL + "\"></a></td></tr></table>" : errorText + detailsLinkMessage;
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if ("more".equals(e.getDescription())) {
                        Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)"Query Error", (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                    } else if ("config".equals(e.getDescription())) {
                        ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                    }
                }
            }
        };
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent, MessageType.ERROR, hyperlinkListener).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceUiUtil$4", "actionPerformed"));
                }
            }
        }, true).setShowCallout(showArrow).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/dataSource/DataSourceUiUtil", "wrap"));
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(new Date()) + "] ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "currentTime"));
        }
        return string;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable DatabaseSystem database) throws PatternSyntaxException {
        DatabaseSystem delegate = database instanceof DbElement ? ((DbElement)database).getDelegate() : database;
        String filterText = delegate instanceof AbstractDataSource ? ((AbstractDataSource)delegate).getTablePattern() : null;
        Condition<DasObject> condition = DataSourceUiUtil.buildObjectFilter(filterText);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
        }
        return condition;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable String filterText) throws PatternSyntaxException {
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
            }
            return condition;
        }
        THashMap map = ContainerUtil.newTroveMap();
        for (String s : StringUtil.split((String)filterText, (String)"||")) {
            ObjectKind kind;
            String part = s.trim();
            if (part.length() == 0) continue;
            int idx = part.indexOf(58);
            boolean exclude = part.charAt(idx + 1) == '-';
            String patternText = part.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == part.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = part.substring(0, idx);
                ObjectKind objectKind = Comparing.strEqual((String)k, (String)"table") ? ObjectKind.TABLE : (Comparing.strEqual((String)k, (String)"vtable") ? ObjectKind.VIRTUAL_TABLE : (Comparing.strEqual((String)k, (String)"view") ? ObjectKind.VIEW : (Comparing.strEqual((String)k, (String)"mview") ? ObjectKind.MAT_VIEW : (Comparing.strEqual((String)k, (String)"routine") ? ObjectKind.ROUTINE : (Comparing.strEqual((String)k, (String)"package") ? ObjectKind.PACKAGE : (Comparing.strEqual((String)k, (String)"sequence") ? ObjectKind.SEQUENCE : (kind = Comparing.strEqual((String)k, (String)"synonym") ? ObjectKind.SYNONYM : ObjectKind.NONE)))))));
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = part;
                }
            }
            Couple prev = (Couple)map.get(kind);
            Pattern pattern = Pattern.compile("(?i)" + patternText);
            Condition c = s1 -> pattern.matcher((CharSequence)s1).matches();
            Couple next = prev == null ? Couple.of((Object)(exclude ? null : c), (Object)(!exclude ? null : c)) : Couple.of((Object)(exclude ? (Condition)prev.first : (prev.first == null ? c : Conditions.or2((Condition)((Condition)prev.first), (Condition)c))), (Object)(!exclude ? (Condition)prev.second : (prev.second == null ? c : Conditions.or2((Condition)((Condition)prev.second), (Condition)c))));
            map.put(kind, next);
        }
        if (map.size() == 1 && ContainerUtil.getFirstItem(map.keySet()) == ObjectKind.NONE) {
            Couple couple = (Couple)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(map.values()));
            Condition first = (Condition)ObjectUtils.notNull((Object)couple.first, (Object)Conditions.alwaysTrue());
            Condition second = (Condition)ObjectUtils.notNull((Object)couple.second, (Object)Conditions.alwaysFalse());
            Condition condition = Conditions.compose((Function)DasUtil.TO_NAME, (Condition)Conditions.and((Condition)first, (Condition)Conditions.not((Condition)second)));
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
            }
            return condition;
        }
        Condition condition = arg_0 -> DataSourceUiUtil.lambda$buildObjectFilter$3((Map)map, arg_0);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
        }
        return condition;
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceUiUtil", "runAsyncWithCorrectModality"));
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceUiUtil", "runSynchronously"));
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
    }

    @NotNull
    public static JBPopup buildHiddenNamespacesPopup(@NotNull Project project, final @NotNull LocalDataSource dataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "buildHiddenNamespacesPopup"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceUiUtil", "buildHiddenNamespacesPopup"));
        }
        final DataSourceScopeEditor editor = new DataSourceScopeEditor(project){

            @Override
            @Nullable
            protected LocalDataSource getDataSource(boolean withCredentials) {
                return dataSource;
            }
        };
        editor.setInitialModel(dataSource, dataSource.getModel());
        editor.setScopes(dataSource.getIntrospectionScope(), dataSource.getIntrospectionScope());
        Ref notApply = Ref.create();
        final Ref popupRef = Ref.create();
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(editor.getComponent(), (JComponent)editor.getTree()).setMovable(true).setResizable(true).setRequestFocus(true).setDimensionServiceKey(project, "HiddenNamespacesPopup", false).setAdText("Press Enter or click outside the list to apply").setKeyEventHandler(event -> {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).closeOk((InputEvent)event);
                    return true;
                }
                if (event.getKeyCode() == 27 && !editor.hasSpeedSearchActive()) {
                    notApply.set((Object)Boolean.TRUE);
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void beforeShown(LightweightWindowEvent event) {
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }
        }).createPopup();
        popupRef.set((Object)popup);
        popup.setFinalRunnable(() -> {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceUiUtil", "lambda$buildHiddenNamespacesPopup$5"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "lambda$buildHiddenNamespacesPopup$5"));
            }
            if (notApply.get() == Boolean.TRUE) {
                return;
            }
            IntrospectionScope scope = IntrospectionScopes.scopeOf(editor.getEditorState());
            if (scope.equals(dataSource.getIntrospectionScope())) {
                return;
            }
            dataSource.setIntrospectionScope(scope);
            DataSourceManagerEx.getInstanceEx(project).updateDataSource(dataSource);
            DataSourceUiUtil.performAutoSyncTask(project, dataSource);
        });
        new UiNotifyConnector.Once((Component)editor.getComponent(), new Activatable(){

            public void showNotify() {
                editor.introspectIfEmpty();
            }

            public void hideNotify() {
            }
        });
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildHiddenNamespacesPopup"));
        }
        return jBPopup;
    }

    public static void setNamespacesVisible(DbDataSource dataSource, BasicModModel model, Iterable<? extends BasicMateNamespace> selectedValues) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            model.modify(BasicModRoot.class, r -> {
                for (BasicMateNamespace n : selectedValues) {
                    r.mod(n).setVisible(true);
                }
            });
            LocalDataSource localDs = (LocalDataSource)dataSource.getDelegate();
            localDs.setIntrospectionScope(DatabaseModelLoader.updateIntrospectionScope(model, localDs.getIntrospectionScope(), false));
            DataSourceUiUtil.performAutoSyncTask(dataSource.getProject(), DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource));
        });
    }

    public static void showNotification(LoaderContext context, long elapsedTime) {
        boolean isError = context.getErrorHandler().hasErrors();
        String message = StringUtil.notNullize((String)StringUtil.nullize((String)DataSourceUiUtil.computeMessage(context)), (String)"Connection successful");
        DataSourceUiUtil.showNotification(context.getProject(), context.getDataSource().getName(), message + DataSourceUiUtil.getElapsedString(elapsedTime), isError);
    }

    @NotNull
    protected static String computeMessage(LoaderContext context) {
        boolean isError = context.getErrorHandler().hasErrors();
        String summary = context.getErrorHandler().getSummary();
        if (isError) {
            String string = summary;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "computeMessage"));
            }
            return string;
        }
        if (!context.getSelection().isEmpty()) {
            List objects = ContainerUtil.filter(context.getSelection(), (Condition)Conditions.notInstanceOf(Class.class));
            int size = objects.size();
            Object item = ContainerUtil.getFirstItem((Collection)objects);
            String itemName = item instanceof String ? (String)item : (item instanceof DasObject ? ((DasObject)item).getName() : null);
            String string = size == 1 && !StringUtil.isEmptyOrSpaces((String)itemName) ? itemName + " synchronized" : "Synchronization successful";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "computeMessage"));
            }
            return string;
        }
        String string = DataSourceUiUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\nConnection successful";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "computeMessage"));
        }
        return string;
    }

    protected static String getElapsedString(long elapsedTime) {
        return elapsedTime > 1L ? " (" + StringUtil.formatDuration((long)elapsedTime) + ")" : "";
    }

    private static /* synthetic */ boolean lambda$buildObjectFilter$3(Map map, DasObject object) {
        Couple couple = (Couple)map.get(object.getKind());
        if (couple == null) {
            return true;
        }
        String name = object.getName();
        return !(couple.first != null && !((Condition)couple.first).value((Object)name) || couple.second != null && ((Condition)couple.second).value((Object)name));
    }

    public static class Status {
        @NotNull
        private final Color color;
        @NotNull
        private final String text;
        @Nullable
        private final String details;

        private Status(@NotNull Color color, @NotNull String text, @Nullable String details) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/dataSource/DataSourceUiUtil$Status", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceUiUtil$Status", "<init>"));
            }
            this.color = color;
            this.text = text;
            this.details = details;
        }

        public static Status failed() {
            return new Status((Color)new JBColor(10944523, 12864337), "Failed", "");
        }

        public static Status successful(@NotNull String details) {
            if (details == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/database/dataSource/DataSourceUiUtil$Status", "successful"));
            }
            return new Status((Color)new JBColor(1011716, 3440685), "Successful", details);
        }
    }

    public static class StatusPanel
    extends JPanel {
        @NotNull
        private final JBLabel statusLabel = new JBLabel();
        @NotNull
        private final ActionLink link = new ActionLink("Details", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                String details;
                String string = details = status == null ? null : status.details;
                if (details == null) {
                    return;
                }
                RelativePoint of = RelativePoint.getSouthOf((JComponent)link);
                JComponent label = HintUtil.createInformationLabel((String)details);
                label.setBorder(IdeBorderFactory.createEmptyBorder((int)1, (int)2, (int)1, (int)2));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFillColor(HintUtil.getInformationColor()).setHideOnClickOutside(true).createBalloon().show(of, Balloon.Position.below);
            }
        });
        private Status status;

        public StatusPanel() {
            super(new BorderLayout());
            Box box = new Box(0);
            box.setAlignmentX(0.0f);
            this.link.setNormalColor((Color)new JBColor(0x898989, 0x898989));
            this.link.setActiveColor(UI.getColor((String)"link.foreground"));
            this.link.setPaintUnderline(true);
            box.add((Component)this.statusLabel, "Center");
            box.add(Box.createHorizontalStrut(5));
            box.add((Component)this.link, "East");
            this.add(box);
            this.setStatus(null);
        }

        public void setStatus(@Nullable Status status) {
            this.status = status;
            boolean visible = status != null;
            this.setVisible(visible);
            if (visible) {
                this.statusLabel.setForeground(status.color);
                this.statusLabel.setText(status.text);
            }
            this.link.setVisible(status != null && StringUtil.isNotEmpty((String)status.details));
        }
    }
}

