/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.execution.rmi.RemoteUtil;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

public class DatabaseConnection {
    private Connection myJdbcConnection;
    private final DatabaseConnectionPoint myConnectionPoint;

    public DatabaseConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull Connection jdbcConnection) {
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnection", "<init>"));
        }
        if (jdbcConnection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdbcConnection", "com/intellij/database/dataSource/DatabaseConnection", "<init>"));
        }
        this.myJdbcConnection = jdbcConnection;
        this.myConnectionPoint = connectionPoint;
    }

    public static DatabaseConnection wrap(@NotNull Connection jdbcConnection) {
        if (jdbcConnection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdbcConnection", "com/intellij/database/dataSource/DatabaseConnection", "wrap"));
        }
        return new DatabaseConnection(new LocalDataSource(), jdbcConnection);
    }

    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        DatabaseConnectionPoint databaseConnectionPoint = this.myConnectionPoint;
        if (databaseConnectionPoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "getConnectionPoint"));
        }
        return databaseConnectionPoint;
    }

    @NotNull
    public Statement createStatement() throws SQLException {
        Statement statement = this.myJdbcConnection.createStatement();
        if (statement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "createStatement"));
        }
        return statement;
    }

    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = this.myJdbcConnection.createStatement(resultSetType, resultSetConcurrency);
        if (statement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "createStatement"));
        }
        return statement;
    }

    @NotNull
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement preparedStatement = this.myJdbcConnection.prepareStatement(sql);
        if (preparedStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "prepareStatement"));
        }
        return preparedStatement;
    }

    @NotNull
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement preparedStatement = this.myJdbcConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        if (preparedStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "prepareStatement"));
        }
        return preparedStatement;
    }

    @NotNull
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStatement = this.myJdbcConnection.prepareCall(sql);
        if (callableStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "prepareCall"));
        }
        return callableStatement;
    }

    @NotNull
    public RemoteBatchPreparedStatement prepareBatchStatement(@NotNull RemoteBatchPreparedStatementImpl.Configuration configuration) throws RemoteException, SQLException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dataSource/DatabaseConnection", "prepareBatchStatement"));
        }
        RemoteBatchPreparedStatement remoteBatchPreparedStatement = ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)this.myJdbcConnection, RemoteConnection.class)).prepareBatchStatement(configuration);
        if (remoteBatchPreparedStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "prepareBatchStatement"));
        }
        return remoteBatchPreparedStatement;
    }

    @NotNull
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = this.myJdbcConnection.getMetaData();
        if (databaseMetaData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "getMetaData"));
        }
        return databaseMetaData;
    }

    Connection release() {
        Connection released = this.myJdbcConnection;
        this.myJdbcConnection = null;
        return released;
    }

    @NotNull
    public Connection getJdbcConnection() {
        Connection connection = this.myJdbcConnection;
        if (connection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnection", "getJdbcConnection"));
        }
        return connection;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.myJdbcConnection.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.myJdbcConnection.getAutoCommit();
    }

    public void setReadOnly(boolean only) throws SQLException {
        this.myJdbcConnection.setReadOnly(only);
    }

    public void rollback() throws SQLException {
        this.myJdbcConnection.rollback();
    }

    public void commit() throws SQLException {
        this.myJdbcConnection.commit();
    }
}

