/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseConnectionEstablisher {
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionManager.class);
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private final DatabaseConnectionPoint myConnectionPoint;
    private final Driver myDriver;
    private final Project myProject;
    private final boolean myAskPassword;
    private final AtomicReference<Boolean> myStopProcessRef;
    private final Properties myConnectionProperties;
    private int myAttemptNo;
    private String myUrl;

    public static CompletionStage<DatabaseConnection> establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull Project project, boolean askPassword) {
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "establishConnection"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "establishConnection"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "establishConnection"));
        }
        JdbcDriverManager jdbcDriverManager = JdbcDriverManager.getDriverManager(project);
        return DatabaseCredentials.getInstance().getCredentialsAsync((DatabaseSystem)connectionPoint.getDataSource()).thenCompose(AsyncUtil.captureIndicator(credentials -> {
            if (connectionPoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$establishConnection$1"));
            }
            if (runConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$establishConnection$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$establishConnection$1"));
            }
            try {
                Driver driver = jdbcDriverManager.getDriver(connectionPoint.getDataSource(), runConfiguration);
                String url = DatabaseConnectionManager.getEffectiveUrl(connectionPoint, jdbcDriverManager);
                if (url == null) {
                    return CompletableFuture.completedFuture(null);
                }
                Runnable releaseDriver = () -> {
                    if (connectionPoint == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$null$0"));
                    }
                    if (runConfiguration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$null$0"));
                    }
                    jdbcDriverManager.releaseDriver(connectionPoint.getDataSource(), runConfiguration);
                };
                DatabaseConnectionEstablisher establisher = new DatabaseConnectionEstablisher(project, driver, connectionPoint, url, releaseDriver, askPassword);
                return establisher.tryConnect((Credentials)credentials);
            }
            catch (Exception e) {
                return AsyncUtil.exceptional(e);
            }
        }));
    }

    DatabaseConnectionEstablisher(@NotNull Project project, @NotNull Driver driver, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull String url, final @NotNull Runnable releaseDriver, boolean askPassword) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "<init>"));
        }
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "<init>"));
        }
        if (releaseDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "releaseDriver", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "<init>"));
        }
        this.myAttemptNo = 0;
        this.myStopProcessRef = new AtomicReference<Boolean>(true);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    if (((Boolean)DatabaseConnectionEstablisher.this.myStopProcessRef.get()).booleanValue()) {
                        releaseDriver.run();
                    }
                }
            });
        }
        this.myConnectionPoint = connectionPoint;
        this.myDriver = driver;
        this.myProject = project;
        this.myConnectionProperties = this.myConnectionPoint.getConnectionProperties();
        this.myUrl = url;
        this.myAskPassword = askPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public CompletionStage<DatabaseConnection> tryConnect(@Nullable Credentials credentials) {
        CompletionStage<DatabaseConnection> completionStage;
        block14: {
            CompletableFuture<DatabaseConnection> completableFuture;
            block13: {
                String password;
                String userName;
                String string = userName = credentials == null ? null : credentials.getUserName();
                if (StringUtil.isNotEmpty((String)userName)) {
                    LOG.info("Connecting as: " + userName);
                    this.myConnectionProperties.setProperty(USER_KEY, userName);
                } else {
                    LOG.info("No user name provided (may be in url)");
                }
                String string2 = password = credentials == null ? null : credentials.getPasswordAsString();
                if (StringUtil.isNotEmpty((String)password)) {
                    this.myConnectionProperties.setProperty(PASSWORD_KEY, password);
                }
                try {
                    DatabaseConnection connection = this.connect();
                    if (connection != null) {
                        CompletableFuture<DatabaseConnection> completableFuture2 = CompletableFuture.completedFuture(connection);
                        completableFuture = completableFuture2;
                        break block13;
                    }
                    CompletionStage<DatabaseConnection> completionStage2 = this.processNullConnection(credentials);
                    completionStage = completionStage2;
                    break block14;
                }
                catch (SQLException e) {
                    CompletionStage<DatabaseConnection> completionStage3 = this.processConnectionFailure(credentials, e);
                    CompletionStage<DatabaseConnection> completionStage4 = completionStage3;
                    if (completionStage4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "tryConnect"));
                    }
                    return completionStage4;
                }
            }
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "tryConnect"));
            }
            return completableFuture;
        }
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "tryConnect"));
        }
        return completionStage;
        finally {
            this.myStopProcessRef.set(false);
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private CompletionStage<DatabaseConnection> processConnectionFailure(@Nullable Credentials credentials, @NotNull SQLException e) {
        CompletionStage<DatabaseConnection> passwordResolution;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "processConnectionFailure"));
        }
        if (e.getCause() instanceof SQLException) {
            e = (SQLException)e.getCause();
        }
        String message = JdbcUtil.getLongMessage((Throwable)e);
        String title = "Connecting to: " + this.myUrl;
        String user = StringUtil.notNullize((String)(credentials == null ? null : credentials.getUserName()), (String)USER_KEY);
        if (this.myAttemptNo < 20 && DatabaseConnectionEstablisher.mayRequestPassword(message, user) && (passwordResolution = this.resolvePasswordIssues(title, message, credentials)) != null) {
            CompletionStage<DatabaseConnection> completionStage = passwordResolution;
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "processConnectionFailure"));
            }
            return completionStage;
        }
        LOG.warn(title);
        LOG.warn(message);
        CompletableFuture<DatabaseConnection> completableFuture = AsyncUtil.exceptional(e);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "processConnectionFailure"));
        }
        return completableFuture;
    }

    @Nullable
    private CompletionStage<DatabaseConnection> resolvePasswordIssues(@NotNull String title, @NotNull String message, @Nullable Credentials credentials) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "resolvePasswordIssues"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "resolvePasswordIssues"));
        }
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        if (this.myAttemptNo == 0 && !Comparing.equal((Object)credentials, (Object)databaseCredentials.getCredentials((DatabaseSystem)this.myConnectionPoint.getDataSource()))) {
            return this.tryReconnectIfWithCredentials(databaseCredentials.getCredentials((DatabaseSystem)this.myConnectionPoint.getDataSource()), message, title);
        }
        if (!this.myAskPassword) {
            return null;
        }
        String userName = credentials == null ? null : credentials.getUserName();
        return AsyncUtil.thenComposeAsync(DatabaseConnectionEstablisher.askPasswordAsync(this.myConnectionPoint.getDataSource(), this.myProject, databaseCredentials, credentials, userName, message), AsyncUtil.captureIndicator(c -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$resolvePasswordIssues$2"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "lambda$resolvePasswordIssues$2"));
            }
            return this.tryReconnectIfWithCredentials((Credentials)c, message, title);
        }), AsyncUtil.NON_EDT_EXECUTOR);
    }

    @NotNull
    private CompletionStage<DatabaseConnection> processNullConnection(@Nullable Credentials credentials) {
        if (this.myAttemptNo == 0 && DatabaseFamilyId.forConnection((RawConnectionConfig)this.myConnectionPoint).isPostgres()) {
            this.myUrl = this.myUrl + "/";
            CompletionStage<DatabaseConnection> completionStage = this.tryReconnect(credentials);
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "processNullConnection"));
            }
            return completionStage;
        }
        LOG.warn("Null connection returned for: " + this.myUrl);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "processNullConnection"));
        }
        return completableFuture;
    }

    @Nullable
    private DatabaseConnection connect() throws SQLException {
        LOG.info("Connecting to: " + this.myUrl);
        Connection jdbcConnection = this.myDriver.connect(this.myUrl, this.myConnectionProperties);
        if (jdbcConnection != null) {
            try {
                this.prepareConnection(jdbcConnection);
            }
            catch (SQLException e) {
                JdbcUtil.closeConnectionSafe((Connection)jdbcConnection);
                throw e;
            }
        }
        return jdbcConnection == null ? null : new DatabaseConnection(this.myConnectionPoint, jdbcConnection);
    }

    private void prepareConnection(@NotNull Connection jdbcConnection) throws SQLException {
        Application app;
        String name;
        if (jdbcConnection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdbcConnection", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "prepareConnection"));
        }
        if (this.myConnectionPoint.isReadOnly()) {
            jdbcConnection.setReadOnly(true);
        }
        String string = name = (app = ApplicationManager.getApplication()) == null || app.isUnitTestMode() ? null : ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (name == null) {
            name = "DG Tests";
        }
        try {
            jdbcConnection.setClientInfo("ApplicationName", name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private CompletionStage<DatabaseConnection> tryReconnect(Credentials credentials) {
        ++this.myAttemptNo;
        this.myStopProcessRef.set(false);
        ProgressManager.checkCanceled();
        return this.tryConnect(credentials);
    }

    private CompletionStage<DatabaseConnection> tryReconnectIfWithCredentials(Credentials credentials, String message, String title) {
        if (credentials == null) {
            LOG.warn(title);
            LOG.warn(message);
            return AsyncUtil.cancelled();
        }
        return this.tryReconnect(credentials);
    }

    private static CompletionStage<Credentials> askPasswordAsync(@NotNull LocalDataSource dataSource, Project project, DatabaseCredentials databaseCredentials, Credentials credentials, String userName, String message) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "askPasswordAsync"));
        }
        String prompt = "The specified user/password combination is rejected";
        prompt = prompt + (message.isEmpty() ? "." : ":<br>" + message);
        String userNameDef = StringUtil.notNullize((String)(credentials == null ? null : userName), (String)StringUtil.notNullize((String)dataSource.getUsername()));
        return databaseCredentials.askCredentialsWhenFailed(project, dataSource, "<html>" + prompt + "</html>", userNameDef);
    }

    private static boolean mayRequestPassword(@NotNull String message, @Nullable String user) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dataSource/DatabaseConnectionEstablisher", "mayRequestPassword"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        if (message.contains("ORA-28001:")) {
            return true;
        }
        if (message.contains("ORA-12705:")) {
            return false;
        }
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message).find();
    }
}

