/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ui.LocalDbParamEditor;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ui.UIUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnectionManager {
    public static final String SSH_HOST = "localhost";
    private static final DatabaseConnectionManager INSTANCE = new DatabaseConnectionManager();
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionManager.class);

    public static DatabaseConnectionManager getInstance() {
        return INSTANCE;
    }

    @NotNull
    public Builder build(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager", "build"));
        }
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnectionManager", "build"));
        }
        Builder builder = new Builder(project, connectionPoint);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager", "build"));
        }
        return builder;
    }

    @Nullable
    public static String getSpecialMessage(@NotNull Throwable t, @NotNull String processName) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dataSource/DatabaseConnectionManager", "getSpecialMessage"));
        }
        if (processName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/database/dataSource/DatabaseConnectionManager", "getSpecialMessage"));
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        boolean remote = ExceptionUtil.causedBy((Throwable)t, RemoteException.class);
        String message = cause.getMessage();
        if (message == null) {
            return null;
        }
        if (cause instanceof SQLException && StringUtil.contains((CharSequence)message, (CharSequence)"ORA-12705:")) {
            return DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName});
        }
        if (cause instanceof OutOfMemoryError && remote) {
            return DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useDriver(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull ThrowableConsumer<Driver, Exception> user) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager", "useDriver"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "useDriver"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager", "useDriver"));
        }
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        Driver driver = driverManager.getDriver(dataSource, driverManager.getDefaultRunConfiguration(dataSource));
        try {
            user.consume((Object)driver);
        }
        finally {
            if (project.isOpen()) {
                DatabaseConnectionManager.releaseDriver(project, dataSource);
            }
        }
    }

    @Nullable
    public static String getEffectiveUrl(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull JdbcDriverManager driverManager) {
        Integer localPort;
        JdbcUrlParser parser;
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/DatabaseConnectionManager", "getEffectiveUrl"));
        }
        if (driverManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/DatabaseConnectionManager", "getEffectiveUrl"));
        }
        final String localDbInst = connectionPoint.getAdditionalJdbcProperties().get("LOCAL_DB_INSTANCE");
        final String localDbExec = connectionPoint.getAdditionalJdbcProperties().get("LOCAL_DB_EXECUTABLE");
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        String url = connectionPoint.getUrl();
        if (driver == null || url == null) {
            return url;
        }
        if (localDbExec != null && localDbInst != null && (parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), url))) != null && parser.getParameters().contains("localdb_pipe")) {
            parser.setUrlText(url);
            if (parser.isValid()) {
                final Ref pipe = Ref.create();
                UIUtil.invokeAndWaitIfNeeded(() -> (new Task.Modal(null, "Actualizing LocalDB Instance Info", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseConnectionManager$1", "run"));
                        }
                        pipe.set((Object)LocalDbParamEditor.getPipeForInstance(localDbInst, localDbExec, indicator));
                    }
                }).queue());
                if (!StringUtil.isEmpty((String)((String)pipe.get()))) {
                    parser.setParameter("localdb_pipe", (String)pipe.get());
                    return parser.getUrlText();
                }
            }
        }
        if ((localPort = driverManager.getLocalPort(connectionPoint.getDataSource())) == null) {
            return url;
        }
        Ref parser2 = Ref.create();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), StringUtil.notNullize((String)url), (Ref<JdbcUrlParser>)parser2);
        if (hostPort == null) {
            return url;
        }
        ((JdbcUrlParser)parser2.get()).setParameter("host", SSH_HOST);
        ((JdbcUrlParser)parser2.get()).setParameter("port", String.valueOf(localPort));
        return ((JdbcUrlParser)parser2.get()).getUrlText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseConnection(Project project, @NotNull LocalDataSource dataSource, @Nullable Connection connection) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "releaseConnection"));
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            DatabaseConnectionManager.releaseDriver(project, dataSource);
        }
    }

    private static void releaseDriver(Project project, LocalDataSource dataSource) {
        if (dataSource.getUniqueId() == null) {
            JdbcDriverManager.getDriverManager(project).releaseDriver(dataSource, null);
        }
    }

    private static void handleConnectionError(@NotNull Throwable e, @NotNull ErrorHandler errorHandler, @NotNull String dsName) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseConnectionManager", "handleConnectionError"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager", "handleConnectionError"));
        }
        if (dsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsName", "com/intellij/database/dataSource/DatabaseConnectionManager", "handleConnectionError"));
        }
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        if (e instanceof SQLException) {
            errorHandler.addError(StringUtil.notNullize((String)DatabaseConnectionManager.getSpecialMessage(e, dsName), (String)DatabaseMessages.message((String)"message.text.cant.establish.connection.to", (Object[])new Object[]{dsName})), e);
        } else if (e instanceof ClassNotFoundException) {
            errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{e.getMessage()}), null);
        } else if (e instanceof ExecutionException) {
            Matcher matcher = Pattern.compile("java\\.lang\\.(ClassNotFoundException|InstantiationException):\\s+((?:\\w+\\.)*\\w+)").matcher(e.getMessage());
            if (matcher.find()) {
                if ("InstantiationException".equals(matcher.group(1))) {
                    errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.instantiable", (Object[])new Object[]{matcher.group(2)}), null);
                } else {
                    errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{matcher.group(2)}), null);
                }
            } else {
                matcher = Pattern.compile(Pattern.quote("Missing native authentication library: ") + "(.*)").matcher(e.getMessage());
                if (matcher.find()) {
                    errorHandler.addError("Missing native authentication library: " + matcher.group(1) + "\nEnsure that supplied driver is up to date or jar with native library is added", null);
                } else {
                    errorHandler.addError(DatabaseMessages.message((String)"message.text.cant.establish.connection.because.of.error", (Object[])new Object[]{dsName, e.getMessage()}), e);
                }
            }
        } else if (e instanceof UnsatisfiedLinkError) {
            errorHandler.addError(DatabaseMessages.message((String)"message.text.native.library.cannot.be.loaded", (Object[])new Object[]{e.getMessage()}), e);
        } else if (e.getClass().getName().equals("com.jcraft.jsch.JSchException")) {
            errorHandler.addError("SSH tunnel creation failed:", e);
        } else {
            errorHandler.addError(DatabaseConnectionManager.getSpecialMessage(e, dsName), e);
        }
    }

    private static class Executor {
        private final Project myProject;
        private final ConsoleRunConfiguration myRunConfiguration;
        private final DatabaseConnectionPoint myConnectionPoint;
        private final boolean myAskPassword;

        private Executor(@NotNull Builder b) {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "<init>"));
            }
            this.myProject = b.getProject();
            this.myConnectionPoint = b.getConnectionPoint();
            this.myRunConfiguration = b.getRunConfiguration();
            this.myAskPassword = b.getAskPassword();
        }

        @NotNull
        public <T> CompletionStage<T> async(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "async"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "async"));
            }
            CompletionStage<Object> completionStage = this.supplyAsync().handle((r, e) -> {
                if (errorHandler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "lambda$async$0"));
                }
                if (e == null) {
                    return r;
                }
                if (!AsyncUtil.isCancellation(e)) {
                    DatabaseConnectionManager.handleConnectionError(e, errorHandler, this.myConnectionPoint.getName());
                }
                throw new ProcessCanceledException();
            }).thenApply(AsyncUtil.captureIndicator(connection -> {
                if (errorHandler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "lambda$async$1"));
                }
                if (user == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "lambda$async$1"));
                }
                return this.perform((DatabaseConnection)connection, errorHandler, user);
            }));
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "async"));
            }
            return completionStage;
        }

        public <T> T sync(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "sync"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "sync"));
            }
            return AsyncUtil.withAsyncFriendly(ProgressIndicatorProvider.getGlobalProgressIndicator(), () -> {
                if (errorHandler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "lambda$sync$2"));
                }
                if (user == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "lambda$sync$2"));
                }
                try (GuardedRef<DatabaseConnection> ref = this.createInner();){
                    Object t = this.perform(ref == null ? null : ref.get(), errorHandler, user);
                    return t;
                }
                catch (SQLException e) {
                    if (AsyncUtil.isCancellation(e)) throw new ProcessCanceledException();
                    DatabaseConnectionManager.handleConnectionError(e, errorHandler, this.myConnectionPoint.getName());
                    throw new ProcessCanceledException();
                }
            });
        }

        @Nullable
        private GuardedRef<DatabaseConnection> create() throws SQLException {
            return (GuardedRef)AsyncUtil.withAsyncFriendly(ProgressIndicatorProvider.getGlobalProgressIndicator(), () -> this.createInner());
        }

        @Nullable
        private GuardedRef<DatabaseConnection> createInner() throws SQLException {
            CompletionStage<DatabaseConnection> connectionFuture = this.supplyAsync();
            try {
                DatabaseConnection connection = connectionFuture.toCompletableFuture().get();
                return connection == null ? null : new GuardedRef<DatabaseConnection>(connection){

                    @Override
                    protected void close(@NotNull DatabaseConnection ref) {
                        if (ref == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor$1", "close"));
                        }
                        this.release(ref);
                    }
                };
            }
            catch (InterruptedException e) {
                connectionFuture.whenComplete((c, ex) -> {
                    try {
                        this.release((DatabaseConnection)c);
                    }
                    catch (Throwable er) {
                        LOG.warn(er);
                    }
                });
                Thread.currentThread().interrupt();
                throw new ProcessCanceledException();
            }
            catch (Exception e) {
                Throwable t = AsyncUtil.unwrap(e);
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
                return null;
            }
        }

        private void release(@NotNull DatabaseConnection ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "release"));
            }
            DatabaseConnectionManager.releaseConnection(this.myProject, this.myConnectionPoint.getDataSource(), ref.release());
        }

        @Nullable
        private <T> T perform(DatabaseConnection connection, ErrorHandler errorHandler, Operation<T> op) {
            if (connection == null) {
                errorHandler.addError(DatabaseMessages.message((String)"wrong.driver.specified", (Object[])new Object[0]), null);
                throw new ProcessCanceledException();
            }
            try {
                T t = op.perform(connection);
                return t;
            }
            catch (Exception e) {
                if (!AsyncUtil.isCancellation(e)) {
                    errorHandler.addError(DatabaseConnectionManager.getSpecialMessage(e, this.myConnectionPoint.getName()), e);
                }
                throw new ProcessCanceledException();
            }
            finally {
                try {
                    this.release(connection);
                }
                catch (Throwable e) {
                    errorHandler.addError(null, e);
                }
            }
        }

        @NotNull
        private CompletionStage<DatabaseConnection> supplyAsync() {
            CompletionStage<DatabaseConnection> completionStage;
            boolean wasIndeterminate;
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            boolean bl = wasIndeterminate = indicator != null && indicator.isIndeterminate();
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText("Connecting to database...");
                indicator.setIndeterminate(false);
            }
            try {
                completionStage = DatabaseConnectionEstablisher.establishConnection(this.myConnectionPoint, this.myRunConfiguration, this.myProject, this.myAskPassword).whenComplete((r, e) -> {
                    if (indicator != null) {
                        indicator.setIndeterminate(wasIndeterminate);
                    }
                });
            }
            catch (Error | RuntimeException e2) {
                if (indicator != null) {
                    indicator.setIndeterminate(wasIndeterminate);
                }
                throw e2;
            }
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor", "supplyAsync"));
            }
            return completionStage;
        }
    }

    public static class Builder {
        private final Project myProject;
        private DatabaseConnectionPoint myConnectionPoint;
        private boolean myAskPassword;
        private ConsoleRunConfiguration myRunConfiguration;

        public Builder(@NotNull Project project, @NotNull DatabaseConnectionPoint point) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "<init>"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "<init>"));
            }
            this.myAskPassword = true;
            this.myProject = project;
            this.myConnectionPoint = point;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "getProject"));
            }
            return project;
        }

        @NotNull
        public DatabaseConnectionPoint getConnectionPoint() {
            DatabaseConnectionPoint databaseConnectionPoint = this.myConnectionPoint;
            if (databaseConnectionPoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "getConnectionPoint"));
            }
            return databaseConnectionPoint;
        }

        public Builder setDestination(@Nullable ObjectPath path) {
            if (path != null) {
                this.myConnectionPoint = JdbcUrlParserUtil.connectedTo(this.myConnectionPoint, path);
            }
            return this;
        }

        public boolean getAskPassword() {
            return this.myAskPassword;
        }

        public Builder setAskPassword(boolean askPassword) {
            this.myAskPassword = askPassword;
            return this;
        }

        public Builder setRunConfiguration(ConsoleRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
            return this;
        }

        @NotNull
        public ConsoleRunConfiguration getRunConfiguration() {
            ConsoleRunConfiguration consoleRunConfiguration = this.myRunConfiguration == null ? JdbcDriverManager.getDriverManager(this.myProject).getDefaultRunConfiguration(this.myConnectionPoint.getDataSource()) : this.myRunConfiguration;
            if (consoleRunConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "getRunConfiguration"));
            }
            return consoleRunConfiguration;
        }

        @NotNull
        public <T> CompletionStage<T> async(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "async"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "async"));
            }
            CompletionStage<T> completionStage = new Executor(this).async(user, errorHandler);
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "async"));
            }
            return completionStage;
        }

        public <T> T sync(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "sync"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$Builder", "sync"));
            }
            return new Executor(this).sync(user, errorHandler);
        }

        @Nullable
        public GuardedRef<DatabaseConnection> create() throws SQLException {
            return new Executor(this).create();
        }
    }

    public static interface Operation<T> {
        public T perform(@NotNull DatabaseConnection var1) throws Exception;
    }
}

