/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDriver
extends DataSourceTemplate {
    public static final Option<Boolean> OPTION_AUTO_COMMIT = new Option<Boolean>(false, "auto-commit", true);
    public static final Option<Boolean> OPTION_AUTO_SYNC = new Option<Boolean>(false, "auto-sync", true);

    public boolean isPredefined();

    public String getId();

    @NotNull
    public String getName();

    public String getDriverClass();

    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers();

    @Nullable
    public Bounds getConnectionBounds();

    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations();

    public boolean matchesUrl(@NotNull String var1);

    @NotNull
    public String getSampleUrl();

    public String getSqlDialect();

    public String getIconName();

    public Map<String, String> getDriverProperties();

    public <T> T getOption(@NotNull Option<T> var1);

    public <T> void setOption(@NotNull Option<T> var1, T var2);

    public String getVmOptions();

    @Nullable
    public ArtifactRef getArtifact();

    public List<SimpleClasspathElement> getClasspathElements();

    public List<SimpleClasspathElement> getAdditionalClasspathElements();

    public static interface ArtifactRef {
        @NotNull
        public String getName();

        @Nullable
        public String getVersion();

        public boolean isUsed();

        public boolean isRolling();
    }

    public static class Bounds {
        public boolean inReadOnlyMode = false;
        @NotNull
        public ObjectKind boundTo = ObjectKind.DATABASE;
        @NotNull
        public List<Pair<String, Boolean>> rewriteParameters = ContainerUtil.newSmartList();
        @Nullable
        public String defaultValue = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bounds bounds = (Bounds)o;
            if (this.inReadOnlyMode != bounds.inReadOnlyMode) {
                return false;
            }
            if (!this.boundTo.equals(bounds.boundTo)) {
                return false;
            }
            if (!this.rewriteParameters.equals(bounds.rewriteParameters)) {
                return false;
            }
            return !(this.defaultValue != null ? !this.defaultValue.equals(bounds.defaultValue) : bounds.defaultValue != null);
        }

        public int hashCode() {
            int result2 = this.inReadOnlyMode ? 1 : 0;
            result2 = 31 * result2 + this.boundTo.hashCode();
            result2 = 31 * result2 + this.rewriteParameters.hashCode();
            result2 = 31 * result2 + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            return result2;
        }
    }

    public static class Option<T> {
        private static final Map<String, Option<?>> ourInstances = ContainerUtil.newLinkedHashMap();
        private final String myName;
        private final T myDef;
        private boolean myFixed;

        @Nullable
        public static Option byName(String name) {
            return ourInstances.get(name);
        }

        @NotNull
        public static Collection<? extends Option<?>> enumerate() {
            Collection<Option<?>> collection = ourInstances.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriver$Option", "enumerate"));
            }
            return collection;
        }

        Option(boolean fixed, String name, T def) {
            this.myName = name;
            this.myDef = def;
            this.myFixed = fixed;
            ourInstances.put(name, this);
        }

        public String getName() {
            return this.myName;
        }

        public T getDefault() {
            return this.myDef;
        }

        public boolean isFixed() {
            return this.myFixed;
        }

        public T get(DatabaseDriver driver) {
            return driver != null ? driver.getOption(this) : this.myDef;
        }

        public T fromString(String value) {
            if (value == null) {
                return this.myDef;
            }
            if (this.myDef instanceof String) {
                return (T)value;
            }
            if (this.myDef instanceof Boolean) {
                return (T)Boolean.valueOf(value);
            }
            throw new AssertionError((Object)(this + "!=" + value));
        }

        public String toString() {
            return this.myName + "(" + this.myDef + (this.myFixed ? ", fixed" : "") + ")";
        }
    }
}

