/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.sql.SqlQuery;

public class DefaultsInstaller {
    private final LocalDataSource myDataSource;
    private IntrospectionScope myIntrospectionScope;
    private IntrospectionScope myDefaultSchemas;

    DefaultsInstaller(@NotNull LocalDataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/DefaultsInstaller", "<init>"));
        }
        this.myDataSource = ds;
        this.myDefaultSchemas = ds.myResolveScope;
        this.myIntrospectionScope = ds.getIntrospectionScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getOracleCurrentUserAndSchema(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DefaultsInstaller", "getOracleCurrentUserAndSchema"));
        }
        SqlQuery currentUserAndSchema = new SqlQuery("select sys_context('userenv','current_schema'), user from dual", Layouts.rowOf((RowLayout)Layouts.arrayOf((int)2, String.class)));
        try (JdbcIntermediateSession intermediateSession = new JdbcIntermediateSession(null, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE, connection.getJdbcConnection(), false){};){
            BaseSession session = new BaseSession((IntegralIntermediateSession)intermediateSession){};
            String[] stringArray = (String[])session.query(currentUserAndSchema).run();
            return stringArray;
        }
    }

    @NotNull
    public DefaultsInstaller saveSchemas() {
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "saveSchemas"));
        }
        return defaultsInstaller;
    }

    @NotNull
    public DefaultsInstaller setupIntrospectionScopeByDefault(@NotNull DatabaseConnection connection, @Nullable String userName) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DefaultsInstaller", "setupIntrospectionScopeByDefault"));
        }
        if (this.myIntrospectionScope.asList().isEmpty() && this.myDefaultSchemas.asList().isEmpty()) {
            if (this.myDataSource.getFamilyId() == DatabaseFamilyId.ORACLE) {
                List<Couple<String>> userAndSchema = DefaultsInstaller.prefixWithAsterisks(DefaultsInstaller.getOracleCurrentUserAndSchema(connection));
                this.myIntrospectionScope = IntrospectionScopes.scopeOf(ContainerUtil.concat(userAndSchema, DefaultsInstaller.prefixWithAsterisks("PUBLIC", "SYS", "SYSTEM")));
                this.myDefaultSchemas = IntrospectionScopes.scopeOf(ContainerUtil.concat(userAndSchema, DefaultsInstaller.prefixWithAsterisks("PUBLIC")));
            } else {
                String currentDatabase2 = connection.getJdbcConnection().getCatalog();
                Set<Couple<String>> toIntrospect = this.getDefaultSchemasToIntrospect(currentDatabase2, userName);
                Set<Couple<String>> toResolve = this.getDefaultSchemasToResolve(currentDatabase2, userName);
                for (Couple<String> c : toResolve) {
                    if (!toResolve.contains(c)) continue;
                    toIntrospect.add(c);
                }
                this.myIntrospectionScope = IntrospectionScopes.scopeOf(toIntrospect);
                this.myDefaultSchemas = IntrospectionScopes.scopeOf(toResolve);
            }
        }
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "setupIntrospectionScopeByDefault"));
        }
        return defaultsInstaller;
    }

    @NotNull
    private static List<Couple<String>> prefixWithAsterisks(String ... schemaNames) {
        if (schemaNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaNames", "com/intellij/database/dataSource/DefaultsInstaller", "prefixWithAsterisks"));
        }
        List list = ContainerUtil.map((Object[])schemaNames, s -> Couple.of((Object)"*", (Object)s));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "prefixWithAsterisks"));
        }
        return list;
    }

    @NotNull
    private Set<Couple<String>> getDefaultSchemasToIntrospect(@Nullable String currentDb, @Nullable String userId) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        OrderedSet result2 = new OrderedSet();
        String currentDatabase2 = StringUtil.notNullize((String)currentDb);
        if (familyId.isDb2()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)userId));
        } else if (familyId.isDerby()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)userId));
            result2.add(Couple.of((Object)currentDatabase2, (Object)"APP"));
        } else if (familyId.isTransactSql()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)"*"));
            result2.add(Couple.of((Object)"*", (Object)"dbo"));
        } else if (familyId.isMysql()) {
            result2.add(Couple.of((Object)"*", (Object)currentDatabase2));
        } else if (familyId.isPostgres()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)"public"));
            result2.add(Couple.of((Object)currentDatabase2, (Object)"pg_catalog"));
            result2.add(Couple.of((Object)currentDatabase2, (Object)userId));
        } else if (familyId.isHsqldb() || familyId.isH2()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)"public"));
        }
        OrderedSet orderedSet = result2;
        if (orderedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getDefaultSchemasToIntrospect"));
        }
        return orderedSet;
    }

    @NotNull
    private Set<Couple<String>> getDefaultSchemasToResolve(@Nullable String currentDb, @Nullable String userId) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        OrderedSet result2 = new OrderedSet();
        String currentDatabase2 = StringUtil.notNullize((String)currentDb);
        if (familyId.isDb2()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)userId));
        } else if (familyId.isDerby()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)userId));
            result2.add(Couple.of((Object)currentDatabase2, (Object)"APP"));
        } else if (familyId.isTransactSql()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)"*"));
        } else if (familyId.isMysql()) {
            result2.add(Couple.of((Object)"*", (Object)currentDatabase2));
        } else if (familyId.isPostgres()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)"public"));
            result2.add(Couple.of((Object)currentDatabase2, (Object)userId));
        } else if (familyId.isHsqldb() || familyId.isH2()) {
            result2.add(Couple.of((Object)currentDatabase2, (Object)"public"));
        }
        OrderedSet orderedSet = result2;
        if (orderedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getDefaultSchemasToResolve"));
        }
        return orderedSet;
    }

    @NotNull
    IntrospectionScope getIntrospectionScope() {
        IntrospectionScope introspectionScope = this.myIntrospectionScope;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getIntrospectionScope"));
        }
        return introspectionScope;
    }

    void setIntrospectionScope(@NotNull IntrospectionScope introspectionScope) {
        if (introspectionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScope", "com/intellij/database/dataSource/DefaultsInstaller", "setIntrospectionScope"));
        }
        this.myIntrospectionScope = introspectionScope;
    }

    @NotNull
    IntrospectionScope getDefaultSchemas() {
        IntrospectionScope introspectionScope = this.myDefaultSchemas;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DefaultsInstaller", "getDefaultSchemas"));
        }
        return introspectionScope;
    }

    void setDefaultSchemas(@NotNull IntrospectionScope defaultSchemas) {
        if (defaultSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSchemas", "com/intellij/database/dataSource/DefaultsInstaller", "setDefaultSchemas"));
        }
        this.myDefaultSchemas = defaultSchemas;
    }
}

