/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayouts;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.SafeFileOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataSourceLayout
implements Disposable {
    public static final Key<StorageSettings> STORAGE_SETTINGS_KEY = Key.create((String)"STORAGE_SETTINGS_KEY");
    public static final String DEF_STAGING_LAYOUT = "plain";
    public static final String DEF_BASE_LAYOUT = "schema-zip";
    public static final String STAGING_DIR = "_staging_";
    public static final String BASE_DIR = "_src_";
    public static final String METADATA_DIR = "_metadata_";
    public static final String STORAGE_CONFIG = "storage.xml";
    private final Logger LOG;
    private final String myDataSourceId;
    private final String myDsRoot;
    private final DbSrcStorage.FsAccess myFsAccess;
    private final LazyMetaData myMetadata;
    private StorageSettings mySettings;
    private boolean mySettingsDirty;

    public DbDataSourceLayout(@NotNull String dataSourceId, @NotNull String dsRoot, @NotNull DbSrcStorage.FsAccess fs) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "<init>"));
        }
        if (dsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsRoot", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "<init>"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "<init>"));
        }
        this.LOG = Logger.getInstance(this.getClass());
        this.myMetadata = new LazyMetaData();
        this.mySettingsDirty = false;
        this.myDataSourceId = dataSourceId;
        this.myDsRoot = dsRoot;
        this.myFsAccess = fs;
        this.init();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMetadata);
    }

    private DbSrcStorageDsMetadata createMeta(@NotNull String dsRoot) {
        if (dsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsRoot", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "createMeta"));
        }
        try {
            return new DbSrcStorageDsMetadata(DbDataSourceLayout.getMetadataFile(dsRoot));
        }
        catch (IOException e) {
            this.LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    public String getRoot() {
        String string = this.myDsRoot;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getRoot"));
        }
        return string;
    }

    public static boolean existsOnDisc(@NotNull String dsRoot) {
        if (dsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsRoot", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "existsOnDisc"));
        }
        return DbDataSourceLayout.getMetadataFile(dsRoot).exists();
    }

    @NotNull
    private static File getMetadataFile(@NotNull String dsRoot) {
        if (dsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsRoot", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getMetadataFile"));
        }
        File file = new File(new File(dsRoot, METADATA_DIR), "metadata");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getMetadataFile"));
        }
        return file;
    }

    @Nullable
    public DbSrcStorageLayout.Item getPath(@Nullable DbSrcPath object, boolean staging) {
        if (staging && !DbSrcStorage.isWritable()) {
            return null;
        }
        return object == null ? null : this.layout(staging).getLocation(this.getRoot(staging), object);
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getMetaData(@Nullable DbSrcPath object) {
        DbSrcStorageDsMetadata metadata = this.myMetadata.get(true);
        return object == null || metadata == null ? null : metadata.getMetaData(object);
    }

    public void putMetaData(@Nullable DbSrcPath object, @Nullable DbSrcStorageDsMetadata.MetaData metaData) {
        if (object == null) {
            return;
        }
        DbSrcStorageDsMetadata metadata = this.myMetadata.get(metaData == null);
        if (metadata == null) {
            return;
        }
        metadata.putMetaData(object, metaData);
    }

    public void init() {
        try {
            this.readSettings();
        }
        catch (IOException e) {
            if (!(e instanceof FileNotFoundException)) {
                this.LOG.warn((Throwable)e);
            }
            this.mySettings = this.getDefaultSettings();
        }
    }

    @NotNull
    private StorageSettings getDefaultSettings() {
        SqlLanguageDialect dialect = DbSqlUtil.getGenericDialect();
        DbSrcStorageLayout stagingLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_STAGING_LAYOUT, this.myFsAccess));
        DbSrcStorageLayout baseLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_BASE_LAYOUT, this.myFsAccess));
        StorageSettings storageSettings = new StorageSettings(dialect, stagingLayout, baseLayout);
        if (storageSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getDefaultSettings"));
        }
        return storageSettings;
    }

    public void initForce(@NotNull SqlLanguageDialect language) throws IOException {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "initForce"));
        }
        boolean updated = this.updateSettingsImpl(language);
        if ((updated |= this.createFolders()) || this.mySettingsDirty) {
            this.saveSettings();
        }
    }

    public void initForce() throws IOException {
        boolean updated = this.createFolders();
        if (updated || this.mySettingsDirty) {
            this.saveSettings();
        }
    }

    private boolean updateSettingsImpl(@NotNull SqlLanguageDialect language) {
        DbSrcStorageLayout baseLayout;
        DbSrcStorageLayout stagingLayout;
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "updateSettingsImpl"));
        }
        if (this.mySettings != null && this.mySettings.myLanguage == language) {
            return false;
        }
        if (this.mySettings == null) {
            stagingLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_STAGING_LAYOUT, this.myFsAccess));
            baseLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_BASE_LAYOUT, this.myFsAccess));
        } else {
            stagingLayout = this.mySettings.myStagingLayout;
            baseLayout = this.mySettings.myBaseLayout;
        }
        StorageSettings newSettings = new StorageSettings(language, stagingLayout, baseLayout);
        this.migrate(newSettings);
        return true;
    }

    void updateSettings(@NotNull SqlLanguageDialect language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "updateSettings"));
        }
        boolean updated = this.updateSettingsImpl(language);
        this.mySettingsDirty |= updated;
        if (updated && new File(this.myDsRoot).exists()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    this.initForce();
                }
                catch (IOException e) {
                    this.LOG.warn((Throwable)e);
                }
            });
        }
    }

    private void migrate(@NotNull StorageSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "migrate"));
        }
        this.mySettings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettings() throws IOException {
        VirtualFile file = this.myFsAccess.findFileByPath(new DbSrcStorage.BiPath(this.myDsRoot + "/" + STORAGE_CONFIG, null));
        if (file != null && file.exists()) {
            StorageSettings saved = (StorageSettings)STORAGE_SETTINGS_KEY.get((UserDataHolder)file);
            if (saved != null) {
                this.mySettings = new StorageSettings(saved.myLanguage, (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(saved.myStagingLayout.getId(), this.myFsAccess)), (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(saved.myBaseLayout.getId(), this.myFsAccess)));
                return;
            }
            try (XppReader reader = new XppReader((Reader)new InputStreamReader(file.getInputStream(), CharsetToolkit.UTF8_CHARSET));){
                this.mySettings = this.read((HierarchicalStreamReader)reader);
            }
        } else {
            this.mySettings = this.getDefaultSettings();
        }
    }

    private void saveSettings() throws IOException {
        DbDataSourceLayout.saveInner((OutputStream)new SafeFileOutputStream(new File(this.myDsRoot, STORAGE_CONFIG)), this.mySettings);
        this.mySettingsDirty = false;
    }

    @NotNull
    public DbSrcStorageLayout.WriteSession createWriteSession(boolean staging) {
        DbSrcStorageLayout.WriteSession writeSession = this.layout(staging).createSession();
        if (writeSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "createWriteSession"));
        }
        return writeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveInner(@NotNull OutputStream stream, @NotNull StorageSettings settings) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "saveInner"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "saveInner"));
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(stream, CharsetToolkit.UTF8_CHARSET));
        try (PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);){
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            DbDataSourceLayout.write((HierarchicalStreamWriter)writer, settings);
        }
    }

    @Nullable
    public Pair<DbSrcPath, Boolean> getObject(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getObject"));
        }
        int jarIdx = filePath.indexOf("!/");
        String hierarchyFilePath = jarIdx == -1 ? filePath : filePath.substring(0, jarIdx);
        for (int i2 = 0; i2 < 2; ++i2) {
            String rootPath;
            boolean isStaging;
            boolean bl = isStaging = i2 == 0;
            if (isStaging && !DbSrcStorage.isWritable() || !FileUtil.isAncestor((String)(rootPath = this.getRoot(isStaging)), (String)hierarchyFilePath, (boolean)false)) continue;
            if (rootPath.equals(hierarchyFilePath)) {
                return Pair.create(null, (Object)isStaging);
            }
            DbSrcPath object = this.layout(isStaging).getObject(rootPath, filePath);
            return object == null ? null : Pair.create((Object)object, (Object)isStaging);
        }
        return null;
    }

    @NotNull
    public Iterable<DbSrcPath> getExistingChildren(@Nullable DbSrcPath object, @NotNull String group2) {
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getExistingChildren"));
        }
        JBIterable res = this.mySettings.myBaseLayout.getExistingChildren(this.getRoot(false), object, group2);
        JBIterable extra = JBIterable.from(this.mySettings.myStagingLayout.getExistingChildren(this.getRoot(true), object, group2));
        JBIterable jBIterable = extra.isEmpty() ? res : extra.append(res).unique();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getExistingChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<String> getExistingGroups(@Nullable DbSrcPath object) {
        JBIterable res = this.mySettings.myBaseLayout.getExistingGroups(this.getRoot(false), object);
        JBIterable extra = JBIterable.from(this.mySettings.myStagingLayout.getExistingGroups(this.getRoot(true), object));
        JBIterable jBIterable = extra.isEmpty() ? res : extra.append(res).unique();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getExistingGroups"));
        }
        return jBIterable;
    }

    @NotNull
    public String getDataSourceId() {
        String string = this.myDataSourceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getDataSourceId"));
        }
        return string;
    }

    @NotNull
    private DbSrcStorageLayout layout(boolean staging) {
        DbSrcStorageLayout dbSrcStorageLayout = staging ? this.mySettings.myStagingLayout : this.mySettings.myBaseLayout;
        if (dbSrcStorageLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "layout"));
        }
        return dbSrcStorageLayout;
    }

    @NotNull
    public String getRoot(boolean staging) {
        String string = this.myDsRoot + DbSrcStorageLayouts.VFS_SEP + (staging ? STAGING_DIR : BASE_DIR);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getRoot"));
        }
        return string;
    }

    @NotNull
    public SqlLanguageDialect getLanguage() {
        SqlLanguageDialect sqlLanguageDialect = this.mySettings.myLanguage;
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getLanguage"));
        }
        return sqlLanguageDialect;
    }

    private boolean createFolders() throws IOException {
        boolean result2;
        final String stagingPath = this.getRoot(true);
        final String basePath = this.getRoot(false);
        VirtualFile stagingRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(stagingPath);
        VirtualFile baseRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath);
        final boolean updateStaging = stagingRoot == null || !stagingRoot.isValid();
        final boolean updateBase = baseRoot == null || !baseRoot.isValid();
        boolean bl = result2 = updateBase || updateStaging;
        if (result2) {
            final Ref exc = Ref.create();
            new WriteAction(){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$1", "run"));
                    }
                    try {
                        if (updateStaging) {
                            VfsUtil.createDirectories((String)stagingPath);
                        }
                        if (updateBase) {
                            VfsUtil.createDirectories((String)basePath);
                        }
                    }
                    catch (IOException e) {
                        exc.set((Object)e);
                    }
                }
            }.execute();
            if (!exc.isNull()) {
                throw (IOException)exc.get();
            }
        }
        return result2;
    }

    @Nullable
    public StorageSettings read(@NotNull HierarchicalStreamReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "read"));
        }
        if (!"storage-settings".equals(reader.getNodeName())) {
            return null;
        }
        String stagingLayoutId = reader.getAttribute("staging-layout");
        String baseLayoutId = reader.getAttribute("base-layout");
        String languageId = reader.getAttribute("language");
        if (stagingLayoutId == null) {
            throw new IOException("Staging layout is undefined");
        }
        if (baseLayoutId == null) {
            throw new IOException("Base layout is undefined");
        }
        DbSrcStorageLayout stagingLayout = DbSrcStorageLayouts.createLayout(stagingLayoutId, this.myFsAccess);
        if (stagingLayout == null) {
            throw new IOException("Unknown staging layout: " + stagingLayoutId);
        }
        DbSrcStorageLayout baseLayout = DbSrcStorageLayouts.createLayout(baseLayoutId, this.myFsAccess);
        if (baseLayout == null) {
            throw new IOException("Unknown base layout: " + baseLayoutId);
        }
        SqlLanguageDialect language = (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)languageId), SqlLanguageDialect.class);
        if (language == null) {
            throw new IOException("Unknown SQL dialect: " + languageId);
        }
        return new StorageSettings(language, stagingLayout, baseLayout);
    }

    public static void write(@NotNull HierarchicalStreamWriter writer, @NotNull StorageSettings settings) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "write"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "write"));
        }
        writer.startNode("storage-settings");
        writer.addAttribute("staging-layout", settings.myStagingLayout.getId());
        writer.addAttribute("base-layout", settings.myBaseLayout.getId());
        writer.addAttribute("language", settings.myLanguage.getID());
        writer.endNode();
    }

    private class LazyMetaData
    implements Disposable {
        private volatile DbSrcStorageDsMetadata myMetadata = null;
        private volatile boolean initialized = false;

        private LazyMetaData() {
        }

        @Nullable
        public DbSrcStorageDsMetadata get(boolean onlyExisted) {
            if (this.initialized) {
                return this.myMetadata;
            }
            return this.init(onlyExisted);
        }

        private boolean existsOnDisc() {
            return DbDataSourceLayout.existsOnDisc(DbDataSourceLayout.this.myDsRoot);
        }

        @Nullable
        private synchronized DbSrcStorageDsMetadata init(boolean onlyExisted) {
            if (this.initialized) {
                return this.myMetadata;
            }
            if (onlyExisted && !this.existsOnDisc()) {
                return null;
            }
            this.myMetadata = DbDataSourceLayout.this.createMeta(DbDataSourceLayout.this.myDsRoot);
            this.initialized = true;
            return this.myMetadata;
        }

        public void dispose() {
            this.initialized = true;
            DbSrcStorageDsMetadata metadata = this.init(true);
            if (metadata != null) {
                Disposer.dispose((Disposable)metadata);
            }
        }
    }

    public static class StorageSettings {
        private final SqlLanguageDialect myLanguage;
        private final DbSrcStorageLayout myStagingLayout;
        private final DbSrcStorageLayout myBaseLayout;

        public StorageSettings(@NotNull SqlLanguageDialect language, @NotNull DbSrcStorageLayout stagingLayout, @NotNull DbSrcStorageLayout baseLayout) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            if (stagingLayout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stagingLayout", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            if (baseLayout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLayout", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            this.myStagingLayout = stagingLayout;
            this.myBaseLayout = baseLayout;
            this.myLanguage = language;
        }
    }
}

