/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.util.GuardedRef;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcValidator {
    private final ScriptingFactory myScripting = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);

    public static boolean isEnabled() {
        return ApplicationManager.getApplication().isInternal();
    }

    @NotNull
    public Couple<List<LocalDataSource>> collect(@Nullable Project project, @NotNull Iterable<LocalDataSource> dataSources) {
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "collect"));
        }
        Couple res = Couple.of((Object)ContainerUtil.newArrayList(), (Object)ContainerUtil.newArrayList());
        for (LocalDataSource source : dataSources) {
            Result result2;
            assert (source.isGlobal() || project != null);
            if (project != null && project.isDisposed()) break;
            DbDataSourceLayout layout = DbSrcStorage.getInstance(source.isGlobal() ? null : project).getLayout(source.getUniqueId());
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getModel(), BasicModel.class);
            if (model == null || (result2 = this.isValid(layout, model)) == Result.VALID) continue;
            if (result2 == Result.GENERATE || result2 == Result.GENERATE_AND_INTROSPECT) {
                ((List)res.first).add(source);
            }
            if (result2 != Result.INTROSPECT && result2 != Result.GENERATE_AND_INTROSPECT) continue;
            ((List)res.second).add(source);
        }
        Couple couple = res;
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "collect"));
        }
        return couple;
    }

    @NotNull
    public Result isValid(@NotNull DbDataSourceLayout layout, @NotNull BasicModel model) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        Result result2 = Result.VALID;
        for (BasicSchema schema : DbSrcValidator.getSchemas(model)) {
            Result cur = this.isValid(layout, model, schema);
            if (result2 == Result.GENERATE && cur == Result.INTROSPECT || result2 == Result.INTROSPECT && cur == Result.GENERATE) {
                Result result3 = Result.GENERATE_AND_INTROSPECT;
                if (result3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
                }
                return result3;
            }
            if (cur.ordinal() <= result2.ordinal()) continue;
            result2 = cur;
        }
        Result result4 = result2;
        if (result4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        return result4;
    }

    @NotNull
    public Result isValid(@NotNull DbDataSourceLayout layout, @NotNull BasicModel model, @NotNull BasicSchema schema) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        Result result2 = this.checkVersions(layout, model, schema);
        if (result2 != null) {
            Result result3 = result2;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
            }
            return result3;
        }
        result2 = Result.VALID;
        for (BasicSourceAware object : DbSrcValidator.getSources(model, schema)) {
            Result cur = (Result)((Object)ObjectUtils.chooseNotNull((Object)((Object)this.checkVersions(layout, model, object)), (Object)((Object)Result.VALID)));
            if (cur.ordinal() > result2.ordinal()) {
                result2 = cur;
            }
            if (result2 != Result.INTROSPECT) continue;
            break;
        }
        this.updateSchemaValidness(layout, model, schema, result2);
        Result result4 = result2;
        if (result4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "isValid"));
        }
        return result4;
    }

    @NotNull
    private static JBIterable<BasicSchema> getSchemas(@NotNull BasicModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "getSchemas"));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().withRoots(model.getModelRoots())).expand(n -> n.getKind() != ObjectKind.SCHEMA)).filter(BasicSchema.class).filter(BasicMateNamespace::isVisible);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "getSchemas"));
        }
        return jBIterable;
    }

    private static JBIterable<BasicSourceAware> getSources(@NotNull BasicModel model, @Nullable BasicSchema schema) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "getSources"));
        }
        JBTreeTraverser traverser = model.traverser();
        traverser = schema != null ? (JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)schema)).expand(Conditions.alwaysTrue()) : (JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)model.getRoot())).expand(o -> !(o instanceof DasNamespace) || ((DasNamespace)o).isVisible());
        return traverser.filter(BasicSourceAware.class);
    }

    @Nullable
    private Result checkVersions(@NotNull DbDataSourceLayout layout, @NotNull BasicModel model, @NotNull BasicElement object) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "checkVersions"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "checkVersions"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "checkVersions"));
        }
        DbSrcPath path = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData metaData = layout.getMetaData(path);
        if (metaData == null) {
            return null;
        }
        if (object.getKind() == ObjectKind.SCHEMA) {
            if (metaData.introContentVersion < 0 && metaData.introContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion) {
                return Result.INTROSPECT;
            }
            if (metaData.genContentVersion < 0 && metaData.genContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion) {
                return Result.GENERATE;
            }
            int genVersion = this.myScripting.getCurrentScriptingVersion(model.getRdbms(), object.getKind());
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
            boolean match = introVersion == metaData.introContentVersion && genVersion == metaData.genContentVersion;
            return match ? Result.VALID : null;
        }
        int genVersion = this.myScripting.getCurrentScriptingVersion(model.getRdbms(), object.getKind());
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
        if (introVersion != metaData.introContentVersion) {
            return Result.INTROSPECT;
        }
        if (genVersion != metaData.genContentVersion) {
            return Result.GENERATE;
        }
        return Result.VALID;
    }

    private void updateSchemaValidness(@NotNull DbDataSourceLayout layout, @NotNull BasicModel model, @NotNull BasicSchema object, @NotNull Result result2) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "updateSchemaValidness"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "updateSchemaValidness"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "updateSchemaValidness"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "updateSchemaValidness"));
        }
        DbSrcPath path = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)layout.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
        int genVersion = this.myScripting.getCurrentScriptingVersion(model.getRdbms(), object.getKind());
        metaData = DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, result2 == Result.INTROSPECT ? -introVersion : introVersion, result2 != Result.VALID ? -genVersion : genVersion);
        layout.putMetaData(path, metaData);
    }

    public static void invalidate(@NotNull DbDataSourceLayout layout, @NotNull DbSrcPath path) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "invalidate"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "invalidate"));
        }
        DbSrcStorageDsMetadata.MetaData metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)layout.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        if (metaData == null) {
            return;
        }
        layout.putMetaData(path, DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion, DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion));
    }

    public static void suggestIntrospecting(@NotNull Project project, @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "suggestIntrospecting"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "suggestIntrospecting"));
        }
        String names = StringUtil.join(dataSources, AbstractDataSource::getName, (String)", ");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("DB objects source code needs update", names + " should be <a href=\"introspect\">reintrospected</a>", NotificationType.WARNING, (notification, event) -> {
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "lambda$suggestIntrospecting$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "lambda$suggestIntrospecting$2"));
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("introspect")) {
                return;
            }
            for (LocalDataSource dataSource : dataSources) {
                DataSourceUiUtil.performAutoSyncTask(project, dataSource);
            }
        }).notify(project);
    }

    public static void suggestRegenerating(final @NotNull Project project, final @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "suggestRegenerating"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "suggestRegenerating"));
        }
        String names = StringUtil.join(dataSources, AbstractDataSource::getName, (String)", ");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("DB objects source code needs update", names + " should be <a href=\"regenerate\">regenerated</a>", NotificationType.WARNING, (notification, event) -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "lambda$suggestRegenerating$3"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "lambda$suggestRegenerating$3"));
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("regenerate")) {
                return;
            }
            new Task.Backgroundable(project, "Regenerating DB Objects Source Code", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/srcStorage/DbSrcValidator$1", "run"));
                    }
                    DbSrcValidator.regenerateSources(project, dataSources);
                }
            }.queue();
        }).notify(project);
    }

    public static void regenerateSources(@NotNull Project project, @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "regenerateSources"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "regenerateSources"));
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText("Regenerating DB objects source code");
        }
        for (LocalDataSource dataSource : dataSources) {
            DbSrcValidator.regenerateSources(project, dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void regenerateSources(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        DbSrcModelStorage modelStorage;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "regenerateSources"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcValidator", "regenerateSources"));
        }
        ScriptingFactory scripting = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class);
        DbSrcModelStorage dbSrcModelStorage = modelStorage = model == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class);
        if (modelStorage == null) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2("Processing " + dataSource.getName());
        }
        DbDataSourceLayout layout = DbSrcStorage.getInstance(dataSource.isGlobal() ? null : project).getLayout(dataSource.getUniqueId());
        try (GuardedRef ignored = modelStorage.startWriteSession(model, TransactionGuard.getInstance().getContextTransaction());){
            modelStorage.beginWrite();
            try {
                for (BasicSourceAware aware : DbSrcValidator.getSources(model, null)) {
                    CompositeText compositeText;
                    int version = scripting.getCurrentScriptingVersion(model.getRdbms(), aware.getKind());
                    DbSrcStorageDsMetadata.MetaData metaData = layout.getMetaData(DbSrcPath.of(aware));
                    if (metaData == null || metaData.genContentVersion == version || (compositeText = modelStorage.load(aware)) == null) continue;
                    modelStorage.save(aware, compositeText);
                }
            }
            finally {
                modelStorage.endWrite();
            }
        }
    }

    public static enum Result {
        VALID,
        GENERATE,
        INTROSPECT,
        GENERATE_AND_INTROSPECT;

    }
}

