/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUrlParserUtil {
    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        for (StatelessJdbcUrlParser p : parsers) {
            if (!p.isUrlValueValid(url)) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @NotNull StatelessJdbcUrlParser.LocationType loc) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        if (loc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loc", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        for (StatelessJdbcUrlParser p : parsers) {
            if (!p.getPossibleLocations().contains((Object)loc) || !p.isUrlValueValid(url)) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static JdbcUrlParser stateful(@Nullable StatelessJdbcUrlParser parser) {
        return parser == null ? null : parser.createStatefull();
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(config));
        if (stateful == null) {
            return null;
        }
        stateful.setUrlText(config.getUrl());
        return stateful.isValid() ? stateful : null;
    }

    @Nullable
    public static Pair.NonNull<String, String> extractHostPort(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable Ref<JdbcUrlParser> p) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "extractHostPort"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "extractHostPort"));
        }
        JdbcUrlParser parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(parsers, url, StatelessJdbcUrlParser.LocationType.REMOTE));
        if (parser != null) {
            parser.setUrlText(url);
        }
        if (parser == null || !parser.isValid()) {
            return null;
        }
        String host = parser.getParameter("host");
        String port = parser.getParameter("port");
        if (StringUtil.isEmpty((String)port)) {
            port = parser.getParameterDefValue("port");
        }
        if (p != null) {
            p.set((Object)parser);
        }
        return StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port) ? null : Pair.createNonNull((Object)host, (Object)port);
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config) {
        DatabaseDriver driver;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        String url = config.getUrl();
        if (url == null) {
            return null;
        }
        if (config instanceof LocalDataSource && (driver = ((LocalDataSource)config).getDatabaseDriver()) != null) {
            return JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), url);
        }
        for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
            StatelessJdbcUrlParser parser;
            if (!Comparing.equal((String)config.getDriverClass(), (String)databaseDriver.getDriverClass()) || (parser = JdbcUrlParserUtil.select(databaseDriver.getJDBCUrlParsers(), url)) == null) continue;
            return parser;
        }
        return null;
    }

    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "connectedTo"));
        }
        if (needed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needed", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "connectedTo"));
        }
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        DatabaseDriver.Bounds bounds2 = bounds = driver == null ? null : driver.getConnectionBounds();
        if (JdbcUrlParserUtil.inBoundsFast(bounds, connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return connectionPoint;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
            return connectionPoint;
        }
        return JdbcUrlParserUtil.rebound(parser, connectionPoint, bounds, neededParam);
    }

    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "connectedTo"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "connectedTo"));
        }
        if (needed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needed", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "connectedTo"));
        }
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        DatabaseDriver.Bounds bounds2 = bounds = driver == null ? null : driver.getConnectionBounds();
        if (JdbcUrlParserUtil.inBoundsFast(bounds, connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return connectionPoint;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        String parameter = JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo);
        if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
            return connectionPoint;
        }
        return JdbcUrlParserUtil.rebound(new LazyStatefulParser(connectionPoint), connectionPoint, bounds, neededParam);
    }

    @NotNull
    private static DatabaseConnectionPoint rebound(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDriver.Bounds bounds, final @NotNull String neededParam) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
        }
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
        }
        if (neededParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "neededParam", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
        }
        if (bounds.rewriteParameters.isEmpty()) {
            DatabaseConnectionPoint databaseConnectionPoint = connectionPoint;
            if (databaseConnectionPoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
            }
            return databaseConnectionPoint;
        }
        final Pair<String, Boolean> param = bounds.rewriteParameters.get(0);
        if (((Boolean)param.second).booleanValue()) {
            JdbcUrlParser urlParser = parser.getParser();
            if (urlParser == null) {
                DatabaseConnectionPoint databaseConnectionPoint = connectionPoint;
                if (databaseConnectionPoint == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
                }
                return databaseConnectionPoint;
            }
            urlParser.setParameter((String)param.first, neededParam);
            final String rewritten = urlParser.getUrlText();
            DatabaseConnectionPoint.Adapter adapter = new DatabaseConnectionPoint.Adapter(connectionPoint){

                @Override
                public String getUrl() {
                    return rewritten;
                }
            };
            if (adapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
            }
            return adapter;
        }
        DatabaseConnectionPoint.Adapter adapter = new DatabaseConnectionPoint.Adapter(connectionPoint){

            @Override
            @NotNull
            public Properties getConnectionProperties() {
                Properties properties = super.getConnectionProperties();
                properties.setProperty((String)param.first, neededParam);
                Properties properties2 = properties;
                if (properties2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil$2", "getConnectionProperties"));
                }
                return properties2;
            }
        };
        if (adapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "rebound"));
        }
        return adapter;
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "outOfBounds"));
        }
        if (needed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needed", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "outOfBounds"));
        }
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        DatabaseDriver.Bounds bounds2 = bounds = driver == null ? null : driver.getConnectionBounds();
        if (JdbcUrlParserUtil.inBoundsFast(bounds, connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        LazyStatefulParser parser = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath current, @NotNull ObjectPath needed) {
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "outOfBounds"));
        }
        if (needed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needed", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "outOfBounds"));
        }
        if (current == null) {
            return JdbcUrlParserUtil.outOfBounds(connectionPoint, needed);
        }
        return JdbcUrlParserUtil.outOfBounds(connectionPoint.getDatabaseDriver(), connectionPoint.isReadOnly(), current, needed);
    }

    public static boolean outOfBounds(@Nullable DatabaseDriver driver, boolean isReadOnly, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriver.Bounds bounds;
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "outOfBounds"));
        }
        if (needed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needed", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "outOfBounds"));
        }
        DatabaseDriver.Bounds bounds2 = bounds = driver == null ? null : driver.getConnectionBounds();
        if (JdbcUrlParserUtil.inBoundsFast(bounds, isReadOnly)) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo), neededParam);
    }

    private static boolean paramOutOfBounds(@Nullable String currentParameter, @NotNull String neededParam) {
        if (neededParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "neededParam", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "paramOutOfBounds"));
        }
        if (currentParameter == null) {
            return true;
        }
        return !neededParam.equalsIgnoreCase(currentParameter);
    }

    private static boolean inBoundsFast(@Nullable DatabaseDriver.Bounds bounds, boolean isReadOnly) {
        return bounds == null || !isReadOnly && bounds.inReadOnlyMode;
    }

    @Nullable
    public static String getObjectItem(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "getObjectItem"));
        }
        if (path == null) {
            return null;
        }
        List<String> p = path.path;
        int sz = p.size();
        if (path.kind == kind) {
            return sz == 0 ? null : p.get(sz - 1);
        }
        if (path.kind == ObjectKind.SCHEMA && kind == ObjectKind.DATABASE) {
            return sz < 2 ? null : p.get(sz - 2);
        }
        return null;
    }

    @Nullable
    private static String findParameter(@NotNull LazyStatefulParser parser, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull List<Pair<String, Boolean>> params2) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "findParameter"));
        }
        if (connectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionPoint", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "findParameter"));
        }
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "findParameter"));
        }
        HashMap properties = null;
        for (Pair<String, Boolean> param : params2) {
            String value;
            if (((Boolean)param.second).booleanValue()) {
                JdbcUrlParser urlParser = parser.getParser();
                value = urlParser != null ? urlParser.getParameter((String)param.first) : null;
            } else {
                if (properties == null) {
                    properties = ContainerUtil.newHashMap((Map)connectionPoint.getConnectionProperties());
                }
                value = (String)ObjectUtils.tryCast(properties.get(param.first), String.class);
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static class LazyStatefulParser {
        private final RawConnectionConfig myConfig;
        private Ref<JdbcUrlParser> myParser;

        private LazyStatefulParser(RawConnectionConfig config) {
            this.myConfig = config;
        }

        @Nullable
        JdbcUrlParser getParser() {
            if (this.myParser == null) {
                this.myParser = Ref.create((Object)JdbcUrlParserUtil.parsed(this.myConfig));
            }
            return (JdbcUrlParser)this.myParser.get();
        }
    }
}

