/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import gnu.trove.TIntStack;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PatternBuilder {
    private final StringBuilder myBuilder;
    private final TIntStack myStack;

    public Pattern compile() {
        return PatternBuilder.compile(this.myBuilder.toString());
    }

    public PatternBuilder wrap(@NotNull CharSequence pre, @NotNull CharSequence post) {
        if (pre == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pre", "com/intellij/database/dataSource/url/template/PatternBuilder", "wrap"));
        }
        if (post == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "post", "com/intellij/database/dataSource/url/template/PatternBuilder", "wrap"));
        }
        this.myBuilder.insert(this.floor(), pre);
        this.myBuilder.append(post);
        return this;
    }

    public PatternBuilder prepend(@NotNull CharSequence pre) {
        if (pre == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pre", "com/intellij/database/dataSource/url/template/PatternBuilder", "prepend"));
        }
        this.myBuilder.insert(this.floor(), pre);
        return this;
    }

    public PatternBuilder append(@NotNull CharSequence post) {
        if (post == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "post", "com/intellij/database/dataSource/url/template/PatternBuilder", "append"));
        }
        this.myBuilder.append(post);
        return this;
    }

    public PatternBuilder append(@NotNull PatternBuilder post) {
        if (post == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "post", "com/intellij/database/dataSource/url/template/PatternBuilder", "append"));
        }
        return this.append(post.myBuilder);
    }

    public PatternBuilder appendQuoted(@NotNull String post) {
        if (post == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "post", "com/intellij/database/dataSource/url/template/PatternBuilder", "appendQuoted"));
        }
        return this.append(Pattern.quote(post));
    }

    public PatternBuilder push() {
        this.myStack.push(this.myBuilder.length());
        return this;
    }

    public PatternBuilder pop() {
        assert (this.myStack.size() != 0);
        this.myStack.pop();
        return this;
    }

    public PatternBuilder append(@NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dataSource/url/template/PatternBuilder", "append"));
        }
        return this.append(pattern.pattern());
    }

    public PatternBuilder matchingGroup() {
        return this.wrap("(", ")");
    }

    public PatternBuilder group() {
        return this.wrap("(?:", ")");
    }

    public PatternBuilder negativeLookahead() {
        return this.wrap("(?!", ")");
    }

    public PatternBuilder positiveLookahead() {
        return this.wrap("(?=", ")");
    }

    public PatternBuilder quote() {
        return this.wrap("\\Q", "\\E");
    }

    public PatternBuilder opt() {
        return this.append("?");
    }

    public PatternBuilder oneOrMore() {
        return this.append("+");
    }

    public PatternBuilder any() {
        return this.append("*");
    }

    public static Pattern compile(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dataSource/url/template/PatternBuilder", "compile"));
        }
        return Pattern.compile(s, 2);
    }

    public static PatternBuilder build(@NotNull CharSequence string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/dataSource/url/template/PatternBuilder", "build"));
        }
        return new PatternBuilder(string);
    }

    public static PatternBuilder build(@NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dataSource/url/template/PatternBuilder", "build"));
        }
        return PatternBuilder.build(pattern.pattern());
    }

    public static PatternBuilder build(@NotNull PatternBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dataSource/url/template/PatternBuilder", "build"));
        }
        return PatternBuilder.build(builder.myBuilder);
    }

    public static int countGroups(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dataSource/url/template/PatternBuilder", "countGroups"));
        }
        return PatternBuilder.countGroups(PatternBuilder.compile(pattern));
    }

    public static int countGroups(@NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dataSource/url/template/PatternBuilder", "countGroups"));
        }
        return pattern.matcher("").groupCount();
    }

    public String toString() {
        return this.myBuilder.toString();
    }

    private PatternBuilder(@NotNull CharSequence string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/dataSource/url/template/PatternBuilder", "<init>"));
        }
        this.myStack = new TIntStack(0);
        this.myBuilder = new StringBuilder(string);
    }

    private int floor() {
        return this.myStack.size() == 0 ? 0 : this.myStack.peek();
    }
}

