/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CheckBoxParamEditor
extends ParamEditorBase<ThreeStateCheckBox> {
    private final String myTrueText;
    private final String myFalseText;
    private final Pattern myTrueCheck;
    private final Pattern myFalseCheck;
    private String myText;

    public CheckBoxParamEditor(@NotNull DataInterchange interchange, @NotNull String caption, @NotNull String trueText, @NotNull String falseText, @NotNull Pattern trueCheck, @NotNull Pattern falseCheck) {
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "<init>"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "<init>"));
        }
        if (trueText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueText", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "<init>"));
        }
        if (falseText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "falseText", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "<init>"));
        }
        if (trueCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueCheck", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "<init>"));
        }
        if (falseCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "falseCheck", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "<init>"));
        }
        super(new ThreeStateCheckBox(caption), interchange, TypesRegistry.ParamEditor.FieldSize.SMALL, null, new AnAction[0]);
        this.myTrueText = trueText;
        this.myFalseText = falseText;
        this.myTrueCheck = trueCheck;
        this.myFalseCheck = falseCheck;
        ((ThreeStateCheckBox)this.getEditorComponent()).setThirdStateEnabled(false);
        ((ThreeStateCheckBox)this.getEditorComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ThreeStateCheckBox)CheckBoxParamEditor.this.getEditorComponent()).getState() == ThreeStateCheckBox.State.SELECTED) {
                    if (!CheckBoxParamEditor.this.myTrueCheck.matcher(CheckBoxParamEditor.this.myText).matches()) {
                        CheckBoxParamEditor.this.myText = CheckBoxParamEditor.this.myTrueText;
                    }
                } else if (((ThreeStateCheckBox)CheckBoxParamEditor.this.getEditorComponent()).getState() == ThreeStateCheckBox.State.NOT_SELECTED && !CheckBoxParamEditor.this.myFalseCheck.matcher(CheckBoxParamEditor.this.myText).matches()) {
                    CheckBoxParamEditor.this.myText = CheckBoxParamEditor.this.myFalseText;
                }
                CheckBoxParamEditor.this.fireChanged();
            }
        });
        this.setText("");
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "getText"));
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/CheckBoxParamEditor", "setText"));
        }
        if ((text = StringUtil.notNullize((String)text)).equals(this.myText)) {
            return;
        }
        this.myText = text;
        if (this.myTrueCheck.matcher(this.myText).matches()) {
            ((ThreeStateCheckBox)this.getEditorComponent()).setState(ThreeStateCheckBox.State.SELECTED);
        } else if (this.myFalseCheck.matcher(this.myText).matches()) {
            ((ThreeStateCheckBox)this.getEditorComponent()).setState(ThreeStateCheckBox.State.NOT_SELECTED);
        } else {
            ((ThreeStateCheckBox)this.getEditorComponent()).setState(ThreeStateCheckBox.State.DONT_CARE);
        }
    }

    @Override
    public void setActive(boolean active) {
    }
}

