/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.dataSource.url.ui.SsrpHostParamEditor;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfoCache;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInstanceParamEditor
extends CompletionParamEditor<SsrpInfo.SsrpInstance> {
    public SsrpInstanceParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "<init>"));
        }
        super(label, interchange);
        this.setForceRefresh("Refresh");
        this.setValidateOnDirtyCompletion(true);
        this.addUpdateOnShow();
        this.setReportErrorOnAutoPopup(true);
        this.getInterchange().addUserDataListener(new DataInterchange.UserDataListener(){

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor$1", "userDataChanged"));
                }
                if (changed != SsrpHostParamEditor.SSRP_INFO) {
                    return;
                }
                SsrpInstanceParamEditor.this.updateVariants();
            }
        }, this);
        this.getInterchange().addPropertyChangeListener("host", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SsrpInstanceParamEditor.this.updateVariants();
            }
        }, this);
        ((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(this::updateHighlighting);
    }

    private void updateVariants() {
        try {
            this.setVariantsAndCompletionVariants((List)ObjectUtils.chooseNotNull(this.getVariants(false), Collections.emptyList()));
        }
        catch (Exception e) {
            this.setVariantsAndCompletionVariants(Collections.emptyList());
        }
    }

    protected void updateHighlighting(@Nullable Editor editor) {
        String error;
        if (editor == null) {
            return;
        }
        editor.getComponent().putClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING, Boolean.TRUE);
        DataSourceSshTunnelConfiguration sshConfiguration = this.getInterchange().getDataSource().getSshConfiguration();
        boolean unsupportedBrowsing = sshConfiguration != null && sshConfiguration.isEnabled();
        editor.getMarkupModel().removeAllHighlighters();
        SsrpInfo.SsrpServer server = this.getServer();
        SsrpInfo.SsrpInstance inst = server == null ? null : server.getInstance(this.getText());
        String string = error = server == null ? null : server.getError();
        if (unsupportedBrowsing || error == null && (server == null || inst != null) || StringUtil.isEmptyOrSpaces((String)this.getText())) {
            editor.getContentComponent().setToolTipText("");
            return;
        }
        TextAttributesKey key = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
        String msg = "UnknownHost".equals(error) ? "Unable to contact Browser Service: Unknown Host" : ("NoResponse".equals(error) ? "Unable to contact Browser Service: No Response" : "No such instance");
        editor.getContentComponent().setToolTipText(msg);
        TextAttributes attributes = editor.getColorsScheme().getAttributes(key);
        editor.getMarkupModel().addRangeHighlighter(0, editor.getDocument().getTextLength(), 4000, attributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @Override
    @NotNull
    protected CompletionStage<List<SsrpInfo.SsrpInstance>> getVariants(@NotNull Map<Key, ?> options, @NotNull ErrorHandler errorHandler) {
        CompletableFuture<List<SsrpInfo.SsrpInstance>> completableFuture;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getVariants"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getVariants"));
        }
        try {
            List<SsrpInfo.SsrpInstance> res = this.getVariants(false);
            if (res == null) {
                res = this.getVariants(true);
            }
            if (res == null) {
                res = Collections.emptyList();
            }
            completableFuture = CompletableFuture.completedFuture(res);
        }
        catch (Exception e) {
            errorHandler.addError(null, e);
            throw new ProcessCanceledException();
        }
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getVariants"));
        }
        return completableFuture;
    }

    @Nullable
    protected List<SsrpInfo.SsrpInstance> getVariants(boolean forced) throws Exception {
        String host = this.getInterchange().getProperty("host");
        if (StringUtil.isEmptyOrSpaces((String)host)) {
            return null;
        }
        SsrpInfo.SsrpServer server = this.getServer();
        if (server == null && forced) {
            SsrpInfoCache.updateHost(false, host);
            server = this.getServer();
        }
        return server == null ? null : ContainerUtil.newArrayList(server.getInstances());
    }

    @Override
    @Nullable
    protected String getTypeText(@NotNull SsrpInfo.SsrpInstance item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getTypeText"));
        }
        return item.getAttribute("Version");
    }

    @Override
    @NotNull
    protected String getText(@NotNull SsrpInfo.SsrpInstance item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getText"));
        }
        String string = item.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getText"));
        }
        return string;
    }

    @Nullable
    private SsrpInfo.SsrpServer getServer() {
        SsrpInfo info = (SsrpInfo)SsrpHostParamEditor.SSRP_INFO.get((UserDataHolder)this.getInterchange());
        String host = this.getInterchange().getProperty("host");
        return info == null || host == null ? null : info.getServer(host);
    }

    @Override
    protected void setVariants(@NotNull List<SsrpInfo.SsrpInstance> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "setVariants"));
        }
        super.setVariants(variants);
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }

    @Override
    protected void fireChanged() {
        super.fireChanged();
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }
}

