/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsHolder;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceProblemsCollector<Key> {
    private final DataSourceProblemsHolder myDataSourceProblemsHolder;
    private final Map<Key, Errors> myErrors;

    public DataSourceProblemsCollector(@NotNull DataSourceProblemsHolder dataSourceProblemsHolder) {
        if (dataSourceProblemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceProblemsHolder", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector", "<init>"));
        }
        this.myErrors = ContainerUtil.newHashMap();
        this.myDataSourceProblemsHolder = dataSourceProblemsHolder;
    }

    public void add(@NotNull Key object, @NotNull DataSourceProblemsProvider provider) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector", "add"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector", "add"));
        }
        this.myErrors.put(object, new Errors(provider, this.myDataSourceProblemsHolder));
    }

    public boolean contains(@NotNull Key object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector", "contains"));
        }
        return this.myErrors.containsKey(object);
    }

    public void update(@NotNull Key object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector", "update"));
        }
        Errors errors = this.myErrors.get(object);
        if (errors != null) {
            errors.update();
        }
    }

    public void remove(@NotNull Key object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector", "remove"));
        }
        Errors errors = this.myErrors.get(object);
        if (errors != null) {
            errors.setErrors(null);
        }
        this.myErrors.remove(object);
    }

    @Nullable
    public Set<DataSourceProblem> getProblems(Key object) {
        Errors errors = this.myErrors.get(object);
        return errors == null ? null : errors.myErrors;
    }

    private static class Errors {
        private final DataSourceProblemsProvider myProvider;
        private final DataSourceProblemsHolder myDataSourceProblemsHolder;
        private Set<DataSourceProblem> myErrors;

        public Errors(@NotNull DataSourceProblemsProvider provider, @NotNull DataSourceProblemsHolder dataSourceProblemsHolder) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector$Errors", "<init>"));
            }
            if (dataSourceProblemsHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceProblemsHolder", "com/intellij/database/dataSource/validation/DataSourceProblemsCollector$Errors", "<init>"));
            }
            this.myProvider = provider;
            this.myDataSourceProblemsHolder = dataSourceProblemsHolder;
            this.update();
        }

        public void update() {
            this.setErrors(this.getErrors());
        }

        @Nullable
        private Set<DataSourceProblem> getErrors() {
            Set<DataSourceProblem> errors = this.myProvider.getErrors();
            return errors.isEmpty() ? null : errors;
        }

        public void setErrors(@Nullable Set<DataSourceProblem> errors) {
            if (this.myErrors != null) {
                for (DataSourceProblem error : this.myErrors) {
                    if (errors != null && errors.contains(error)) continue;
                    this.myDataSourceProblemsHolder.removeError(error);
                }
            }
            this.myErrors = errors;
            if (errors != null) {
                for (DataSourceProblem error : errors) {
                    this.myDataSourceProblemsHolder.addError(error);
                }
            }
        }
    }
}

