/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshDataSourceValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull LocalDataSource target, @NotNull Consumer<DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "collectProblems"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "collectProblems"));
        }
        DataSourceSshTunnelConfiguration configuration = target.getSshConfiguration();
        DatabaseDriver driver = target.getDatabaseDriver();
        String url = target.getUrl();
        if (driver == null || StringUtil.isEmpty((String)url)) {
            return;
        }
        if (configuration == null || !configuration.isEnabled() || SshDataSourceValidator.isOk(driver, url)) {
            return;
        }
        String description = "Host & port not found. Fix URL or <a href=\"$ACTION0\">create template</a>";
        problems.consume((Object)new DataSourceProblem(target, this, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("Unable to apply SSH settings", description, description, new DataSourceProblem.NewUrlTemplate(driver, url)), null));
    }

    private static boolean isOk(@NotNull DatabaseDriver driver, @NotNull String url) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "isOk"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/validation/SshDataSourceValidator", "isOk"));
        }
        return JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), url, null) != null;
    }
}

