/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.NavigatableWithText;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridPomTarget
implements PomNamedTarget,
NavigatableWithText {
    public final DataGrid dataGrid;

    @NotNull
    public static PsiElement wrapDataGrid(@NotNull Project project, @NotNull DataGrid dataGrid) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataGridPomTarget", "wrapDataGrid"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget", "wrapDataGrid"));
        }
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new Grid(dataGrid));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridPomTarget", "wrapDataGrid"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement wrapCell(@NotNull Project project, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataGridPomTarget", "wrapCell"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget", "wrapCell"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DataGridPomTarget", "wrapCell"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DataGridPomTarget", "wrapCell"));
        }
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new Cell(dataGrid, rows, columns));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridPomTarget", "wrapCell"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement wrapColumn(@NotNull Project project, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataGridPomTarget", "wrapColumn"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget", "wrapColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/DataGridPomTarget", "wrapColumn"));
        }
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new Column(dataGrid, column));
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridPomTarget", "wrapColumn"));
        }
        return psiElement;
    }

    @Nullable
    public static DataGrid unwrapDataGrid(@Nullable PsiElement element) {
        DataGridPomTarget t = DataGridPomTarget.unwrap(element);
        return t != null ? t.dataGrid : null;
    }

    @Nullable
    public static Cell unwrapCell(@Nullable PsiElement element) {
        DataGridPomTarget t = DataGridPomTarget.unwrap(element);
        return t instanceof Cell ? (Cell)t : null;
    }

    @Nullable
    public static Column unwrapColumn(@Nullable PsiElement element) {
        DataGridPomTarget t = DataGridPomTarget.unwrap(element);
        return t instanceof Column ? (Column)t : null;
    }

    @Nullable
    private static DataGridPomTarget unwrap(@Nullable PsiElement element) {
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget target = ((PomTargetPsiElement)element).getTarget();
        return target instanceof DataGridPomTarget ? (DataGridPomTarget)target : null;
    }

    DataGridPomTarget(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget", "<init>"));
        }
        this.dataGrid = dataGrid;
    }

    public boolean isValid() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        this.dataGrid.scrollSelectionToVisible();
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.dataGrid.getPreferredFocusedComponent(), true));
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public int hashCode() {
        return this.dataGrid.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.dataGrid.equals(((DataGridPomTarget)o).dataGrid);
    }

    @Nullable
    public String getNavigateActionText(boolean focusEditor) {
        return "Jump to Data Grid";
    }

    public String getName() {
        return this.toString();
    }

    public static class Cell
    extends DataGridPomTarget {
        public final ModelIndexSet<DataConsumer.Row> rows;
        public final ModelIndexSet<DataConsumer.Column> columns;

        Cell(DataGrid dataGrid, ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns) {
            super(dataGrid);
            this.rows = rows;
            this.columns = columns;
        }

        @Override
        public void navigate(boolean requestFocus) {
            this.dataGrid.getSelectionModel().setRowSelection(this.rows);
            this.dataGrid.getSelectionModel().setColumnSelection(this.columns);
            super.navigate(requestFocus);
        }

        public String toString() {
            ModelIndex r0 = (ModelIndex)this.rows.first();
            ModelIndex c0 = (ModelIndex)this.columns.last();
            ModelIndex r1 = (ModelIndex)this.rows.last();
            ModelIndex c1 = (ModelIndex)this.columns.last();
            if (!(r0.isValid(this.dataGrid) && c0.isValid(this.dataGrid) && r1.isValid(this.dataGrid) && c1.isValid(this.dataGrid))) {
                return "";
            }
            String s = r0.toView(this.dataGrid).asInteger() + 1 + "x" + (c0.toView(this.dataGrid).asInteger() + 1);
            return "[" + (r0.equals(r1) && c0.equals(c1) ? s : s + ".." + (r1.toView(this.dataGrid).asInteger() + 1) + "x" + (c1.toView(this.dataGrid).asInteger() + 1)) + "]";
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.rows.hashCode() + 961 * this.columns.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return super.equals(o) && this.rows.equals(((Cell)o).rows) && this.columns.equals(((Cell)o).columns);
        }
    }

    public static class Column
    extends DataGridPomTarget {
        public final ModelIndex<DataConsumer.Column> column;

        Column(@NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Column> column) {
            if (dataGrid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget$Column", "<init>"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/DataGridPomTarget$Column", "<init>"));
            }
            super(dataGrid);
            this.column = column;
        }

        public DataConsumer.Column getColumn() {
            return this.dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(this.column);
        }

        @Override
        public void navigate(boolean requestFocus) {
            this.dataGrid.getSelectionModel().setColumnSelection(this.column);
            super.navigate(requestFocus);
        }

        public String toString() {
            return "Column " + this.column.asInteger();
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.column.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return super.equals(o) && this.column.equals(((Column)o).column);
        }
    }

    public static class Grid
    extends DataGridPomTarget {
        public final String title;

        Grid(@NotNull DataGrid dataGrid) {
            if (dataGrid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget$Grid", "<init>"));
            }
            super(dataGrid);
            this.title = dataGrid.getDisplayName();
        }

        public String toString() {
            return StringUtil.isNotEmpty((String)this.title) ? this.title : "Table Data";
        }
    }
}

