/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.OwnerEx {
    private final DatabaseMutatorImpl myMutator;
    private DasTable myDatabaseTable;
    private DbDataSource myDataSource;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    DatabaseGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "<init>"));
        }
        super(project, messageBus);
        this.myMutator = new DatabaseMutatorImpl(this.getModel(), this);
    }

    @Nullable
    public DatabaseMutatorImpl getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        DatabaseLoader databaseLoader = new DatabaseLoader();
        if (databaseLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "createLoader"));
        }
        return databaseLoader;
    }

    @Override
    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource = this.getDataSource();
        if (dataSource == null || !dataSource.isWritable()) {
            return true;
        }
        ObjectKind kind = this.myDatabaseTable != null ? this.myDatabaseTable.getKind() : null;
        return !DbImplUtil.isEditableTable(kind);
    }

    @Nullable
    public DasTable getDatabaseTable() {
        if (this.myDatabaseTable instanceof DbElement) {
            return ((DbElement)this.myDatabaseTable).isValid() ? this.myDatabaseTable : null;
        }
        return this.myDatabaseTable;
    }

    public void setDatabaseTable(@Nullable DasTable databaseTable) {
        this.myDatabaseTable = databaseTable;
    }

    @Nullable
    public DbDataSource getDataSource() {
        if (this.myDataSource != null && this.myDataSource.isValid()) {
            return this.myDataSource;
        }
        DasTable dbTable = this.getDatabaseTable();
        return dbTable instanceof DbElement ? ((DbElement)dbTable).getDataSource() : null;
    }

    public void setDataSource(@Nullable DbDataSource dataSource) {
        this.myDataSource = dataSource;
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DbDataSource dataSource = this.getDataSource();
        DatabaseDialectEx databaseDialectEx = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @Nullable
    public DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column) {
        if (column == null) {
            return null;
        }
        DasTable dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from((Iterable)DasUtil.getColumns((DasObject)dasTable)).filter(DasUtil.byName((String)column.name)).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns = this.myModel.getColumns();
        for (DataConsumer.Column column : columns) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column.columnNum));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column.name)))) continue;
            return null;
        }
        return this.myTableType;
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private boolean myLastColumnIsRowId;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "setColumns"));
            }
            boolean sameQuery = Comparing.equal((String)this.getQueryText(), (String)context.getQuery());
            DatabaseGridDataHookUp.this.myReadOnly = sameQuery ? DatabaseGridDataHookUp.this.myReadOnly : !DbSqlUtil.isResultEditable(context.request, DatabaseGridDataHookUp.this.myDatabaseTable);
            ConsoleDataRequest request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
            DatabaseGridDataHookUp.this.myTableType = request != null ? (SqlTableType)ObjectUtils.tryCast((Object)request.resultType, SqlTableType.class) : null;
            DatabaseGridDataHookUp.this.myMutator.clearPendingChanges();
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
        }

        @Override
        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "prepareColumns"));
            }
            for (int i2 = 0; i2 < columns.length; ++i2) {
                DataConsumer.Column column = columns[i2];
                DasColumn databaseColumn = DatabaseGridDataHookUp.this.getDatabaseColumn(column);
                if (databaseColumn != null && (column.type == 0 || column.type == 1111)) {
                    columns[column.columnNum] = column = new DataConsumer.Column(column.columnNum, column.name, databaseColumn.getDataType().jdbcType, column.typeName, column.clazz);
                    continue;
                }
                if (i2 != columns.length - 1 || !this.myLastColumnIsRowId) continue;
                columns[i2] = DbImplUtil.makeComputedColumn(column);
            }
            return columns;
        }

        @Override
        protected void setQueryText(String query) {
            super.setQueryText(query);
            boolean updateable = StringUtil.isNotEmpty((String)query) && DbImplUtil.createSelectCountQuery(DatabaseGridDataHookUp.this.getProject(), DatabaseGridDataHookUp.this.getDatabaseDialect(), query, null) != null;
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(updateable);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "updateTotalRowCount"));
            }
            this.updateQueryText(null);
            if (!DatabaseGridDataHookUp.this.myPageModel.isTotalRowCountUpdateable()) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DbDataSource system = DatabaseGridDataHookUp.this.getDataSource();
            String text = this.getQueryText();
            DatabaseDialectEx dialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            Project project = DatabaseGridDataHookUp.this.getProject();
            String alias = text == null ? "t" : DbImplUtil.findFreeAlias(project, dialect, text, "t");
            final String countQuery = DbImplUtil.createSelectCountQuery(project, dialect, text, system, alias);
            DataRequest.RawRequest request = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                    int count = DbImplUtil.getCount(connection, (String)ObjectUtils.assertNotNull((Object)countQuery));
                    DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(count, true);
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@Nullable Integer limit) {
            Pair<String, Boolean> pure = this.createQueryTextPure(limit);
            if (pure == null) {
                return null;
            }
            this.myLastColumnIsRowId = (Boolean)pure.getSecond();
            return (String)pure.getFirst();
        }

        @Nullable
        public Pair<String, Boolean> createQueryTextPure(@Nullable Integer limit) {
            DasTable dbTable = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (dbTable == null) {
                return null;
            }
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            boolean needId = this.needRowId(dbTable);
            DbDataSource source = DatabaseGridDataHookUp.this.getDataSource();
            DdlBuilder builder = limit != null ? dbDialect.sqlSelectAll(DbImplUtil.createBuilderForUIExec(dbDialect, (DasObject)dbTable), dbTable, (DatabaseSystem)source, this::appendWhereClause, (Consumer<DdlBuilder>)((Consumer)this::appendOrderByClause), needId, limit) : this.createUnlimitedBuilder(dbDialect, dbTable);
            return Pair.create((Object)builder.getStatement(), (Object)(needId && dbDialect.hasRowId((DatabaseSystem)source) ? 1 : 0));
        }

        @NotNull
        private DdlBuilder createUnlimitedBuilder(@NotNull DatabaseDialectEx dialect, @NotNull DasTable table) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "createUnlimitedBuilder"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "createUnlimitedBuilder"));
            }
            DdlBuilder builder = DbImplUtil.createSelectAllQuery(table, dialect, (DatabaseSystem)DatabaseGridDataHookUp.this.getDataSource(), this.needRowId(table), -1);
            this.appendWhereClause(null, builder);
            this.appendOrderByClause(builder);
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "createUnlimitedBuilder"));
            }
            return ddlBuilder;
        }

        private boolean needRowId(@NotNull DasTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "needRowId"));
            }
            return table.getKind() == ObjectKind.TABLE && DasUtil.getPrimaryKey((DasTable)table) == null;
        }

        protected void appendOrderByClause(@NotNull DdlBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "appendOrderByClause"));
            }
        }

        protected void appendWhereClause(@Nullable String alias, @NotNull DdlBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "appendWhereClause"));
            }
        }
    }
}

