/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.tree.ImportTargetChooser;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportUtil {
    private ImportUtil() {
    }

    @NotNull
    public static InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/ImportUtil", "getInputStream"));
        }
        VirtualFileSystem system = file.getFileSystem();
        InputStream inputStream = system instanceof JarFileSystem ? ImportUtil.getInputStreamForZip(file) : new FileInputStream(file.getPath());
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getInputStream"));
        }
        return inputStream;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull ColumnDescriptor delegate, boolean autogenerated, boolean hasDefault) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor> delegateDescriptor = new AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor>(delegate, autogenerated, hasDefault);
        if (delegateDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        return delegateDescriptor;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull DeColumn column, boolean mapped) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        MyDeColumnDescriptor myDeColumnDescriptor = new MyDeColumnDescriptor(column, mapped);
        if (myDeColumnDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        return myDeColumnDescriptor;
    }

    @NotNull
    public static ImportDatabaseTableEditor<?> createEditor(@NotNull DeTable table, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull ImportAction.ImportEditorContext context) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        SqlCodeStyleSettings settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)context.getProject()));
        TableEditorModel tableEditorModel = new TableEditorModel(table, new EditorModelsCache(settings));
        ImportEditorState<? extends ColumnDescriptor> state = new ImportEditorState<ColumnDescriptor>(context, descriptors);
        ImportDatabaseTableEditor editor = new ImportDatabaseTableEditor(state, context.getCaps(), tableEditorModel);
        Disposer.register((Disposable)context.getDisposable(), editor);
        ImportDatabaseTableEditor importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    @NotNull
    public static List<DataConsumer.Row> getRows(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "getRows"));
        }
        List<DataConsumer.Row> list = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getRows"));
        }
        return list;
    }

    @NotNull
    public static DeTable createDeTableFromDasObject(@NotNull DasModel dasModel, @NotNull DasObject element, @NotNull DeModel model) {
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        DeTable deTable = (DeTable)model.getExportHelper().exportDeep(dasModel, element, true);
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromDasObject"));
        }
        return deTable;
    }

    @NotNull
    public static DeTable createDeTableFromColumns(@NotNull DeModel model, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull String name) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromColumns"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromColumns"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromColumns"));
        }
        DeTable table = new DeTable(name, null, model);
        table.columns.clear();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn column = new DeColumn(columnDescriptor.getName(), table, model);
            column.dataType = columnDescriptor.getTypeName();
            table.columns.add(column);
        }
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDeTableFromColumns"));
        }
        return deTable;
    }

    public static void removeUnsupportedObjects(@NotNull DeTable table, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "removeUnsupportedObjects"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ImportUtil", "removeUnsupportedObjects"));
        }
        if (!caps.getComment().isSupported()) {
            table.comment = null;
        }
        if (!caps.getColumnCaps(false).getComment().isSupported()) {
            for (DeColumn column : table.columns) {
                column.comment = null;
            }
        }
    }

    public static void removeUntransferableObjects(@NotNull DeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "removeUntransferableObjects"));
        }
        table.foreignKeys.clear();
        for (DeColumn column : table.columns) {
            column.defaultValue = null;
            column.flags.clear();
        }
        table.keys.clear();
        table.indices.clear();
    }

    @NotNull
    public static DeTable createTable(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows, @NotNull Function<ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        if (columnTypePredictor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTypePredictor", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        ImportInfo.Builder builder = context.getBuilder();
        List<? extends ColumnDescriptor> visibleProducers = builder.getVisibleProducers();
        DeModel oldModel = context.getModel();
        DeModel newModel = new DeModel(oldModel.getModel(), oldModel.getExportHelper());
        DeTable table = new DeTable(context.getTableName(), context.getNamespace(), newModel);
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        table.columns.addAll(ImportUtil.createDeColumns(context, producers, rows, table, newModel, columnTypePredictor));
        newModel.addRoot(table);
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createTable"));
        }
        return deTable;
    }

    public static void showTargetChooser(@NotNull Project project, @NotNull ImportInfo.Builder builder, @Nullable DbElement producer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportUtil", "showTargetChooser"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImportUtil", "showTargetChooser"));
        }
        MyDialog dialog = new MyDialog(project, builder, producer);
        dialog.show();
    }

    @NotNull
    public static List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "getColumns"));
        }
        List<DataConsumer.Column> columns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(DbImplUtil::isComputedColumn));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getColumns"));
        }
        return list;
    }

    @NotNull
    public static List<DataConsumer.Column> getVisibleColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "getVisibleColumns"));
        }
        ModelIndexSet indices = grid.getVisibleColumns();
        ArrayList columns = ContainerUtil.newArrayList(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indices));
        ContainerUtil.sort((List)columns, Comparator.comparingInt(c -> c.columnNum));
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(DbImplUtil::isComputedColumn));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getVisibleColumns"));
        }
        return list;
    }

    @NotNull
    public static String getPreferredTypeBasedOnContent(@NotNull ColumnTypePredictorInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportUtil", "getPreferredTypeBasedOnContent"));
        }
        TypeMerger merger = null;
        ImportManager manager = info.context.getManager();
        if (info.rows == null || !(info.column instanceof DataConsumer.Column)) {
            String string = manager.getStringMerger().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getPreferredTypeBasedOnContent"));
            }
            return string;
        }
        DataConsumer.Column column = (DataConsumer.Column)info.column;
        for (DataConsumer.Row row : info.rows) {
            Object object = column.getValue(row);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            TypeMerger nextMerger = manager.getType(value);
            merger = merger == null ? nextMerger : merger.merge(nextMerger);
        }
        String string = merger == null ? manager.getStringMerger().getName() : merger.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getPreferredTypeBasedOnContent"));
        }
        return string;
    }

    @NotNull
    private static List<DataConsumer.Column> unambiguous(@NotNull DataGrid grid, @NotNull List<DataConsumer.Column> columns) {
        SqlTableType type;
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ImportUtil", "unambiguous"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportUtil", "unambiguous"));
        }
        DatabaseGridDataHookUp hookUp = DataGridUtil.getDatabaseHookUp(grid);
        SqlTableType sqlTableType = type = hookUp == null ? null : hookUp.getTableType();
        if (type == null) {
            List<DataConsumer.Column> list = columns;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "unambiguous"));
            }
            return list;
        }
        List<String> names = DbSqlUtil.getUnambiguousColumnNames(DataGridUtil.getProject(grid), DataGridUtil.getDatabaseDialect(grid), type);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (DataConsumer.Column column : columns) {
            if (column.columnNum >= names.size()) {
                result2.add(column);
                continue;
            }
            result2.add(new DataConsumer.Column(column.columnNum, names.get(column.columnNum), column.type, column.typeName, column.clazz, column.precision, column.scale, column.catalog, column.schema, column.table));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "unambiguous"));
        }
        return arrayList;
    }

    @NotNull
    private static List<DeColumn> createDeColumns(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows, @NotNull DeTable table, @NotNull DeModel model, @NotNull Function<ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        if (columnTypePredictor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTypePredictor", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn deColumn = new DeColumn(columnDescriptor.getName(), table, model);
            deColumn.dataType = (String)columnTypePredictor.fun((Object)new ColumnTypePredictorInfo(context, columnDescriptor, rows));
            result2.add(deColumn);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDeColumns"));
        }
        return arrayList;
    }

    @NotNull
    private static InputStream getInputStreamForZip(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/ImportUtil", "getInputStreamForZip"));
        }
        JarFileSystem instance = JarFileSystem.getInstance();
        VirtualFile jar = instance.getVirtualFileForJar(file);
        VirtualFile root2 = instance.getJarRootForLocalFile((VirtualFile)ObjectUtils.assertNotNull((Object)jar));
        ZipFile zipFile = new ZipFile(((VirtualFile)ObjectUtils.assertNotNull((Object)jar)).getPath());
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)root2)));
        ZipEntry entry = zipFile.getEntry(relativePath);
        MyDelegateInputStream myDelegateInputStream = new MyDelegateInputStream(zipFile.getInputStream(entry), zipFile);
        if (myDelegateInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "getInputStreamForZip"));
        }
        return myDelegateInputStream;
    }

    @NotNull
    public static String pluralizeRows(long count) {
        String string = ImportUtil.pluralize("row", count);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "pluralizeRows"));
        }
        return string;
    }

    @NotNull
    public static String pluralize(@NotNull String word, long count) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/database/dbimport/ImportUtil", "pluralize"));
        }
        String string = count == 1L ? word : StringUtil.pluralize((String)word);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "pluralize"));
        }
        return string;
    }

    public static boolean canBeProducer(@Nullable DbElement element) {
        return element != null && DbImplUtil.canConnectTo(element) && DbImplUtil.isDataTable(element.getKind());
    }

    public static boolean canBeConsumer(@Nullable DbElement element) {
        return ImportUtil.canBeConsumerFast(element) && DbImplUtil.canConnectToAndModify(element);
    }

    public static boolean canBeConsumerFast(@Nullable DbElement element) {
        return element != null && (!(element instanceof DbNamespaceImpl) && !(element instanceof DbDataSource) || DatabaseView.getLowestSchema(element) != null) && ImportType.of(element) != null;
    }

    private static class MyDialog
    extends DialogWrapper {
        private final ImportTargetChooser myChooser;
        private final Project myProject;
        private final ImportInfo.Builder myBuilder;

        protected MyDialog(@NotNull Project project, @NotNull ImportInfo.Builder builder, @Nullable DbElement producer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportUtil$MyDialog", "<init>"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImportUtil$MyDialog", "<init>"));
            }
            super(project);
            this.myChooser = new ImportTargetChooser(project, (Consumer<Object>)((Consumer)this::selectionChanged), producer);
            this.myProject = project;
            this.myBuilder = builder;
            Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myChooser);
            this.setTitle("Choose Target");
            this.init();
        }

        protected void init() {
            super.init();
            this.myChooser.getChoseByNamePanel().invoke(new ChooseByNamePopupComponent.Callback(){

                public void elementChosen(Object element) {
                    this.chosen(element);
                }
            }, ModalityState.stateForComponent((Component)this.getRootPane()), false);
        }

        protected void dispose() {
            this.myChooser.saveState();
            super.dispose();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myChooser.getChoseByNamePanel().getPreferredFocusedComponent();
        }

        protected void doOKAction() {
            Object element = this.myChooser.getChoseByNamePanel().getChosenElement();
            this.chosen(element);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myChooser;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        private void chosen(@Nullable Object element) {
            if (!this.getOKAction().isEnabled()) {
                return;
            }
            this.close(0);
            if (element == null || !(element instanceof DbElement)) {
                return;
            }
            ImportAction.showDialog(this.myProject, this.myBuilder, (DbElement)element);
        }

        private void selectionChanged(@Nullable Object element) {
            this.getOKAction().setEnabled(ObjectUtils.tryCast((Object)element, DbElement.class) != null);
        }
    }

    private static class MyDeColumnDescriptor
    implements AutoValueDescriptor {
        private final DeColumn myColumn;
        private final boolean myMapped;

        private MyDeColumnDescriptor(@NotNull DeColumn column, boolean mapped) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$MyDeColumnDescriptor", "<init>"));
            }
            this.myColumn = column;
            this.myMapped = mapped;
        }

        @Override
        public int getScale() {
            return this.myColumn.getDataType().getScale();
        }

        @Override
        public int getSize() {
            return this.myColumn.getDataType().getPrecision();
        }

        @Override
        public int getType() {
            return JdbcUtil.guessJdbcTypeByName((String)this.myColumn.dataType);
        }

        @Override
        public String getName() {
            return this.myColumn.getName();
        }

        @Override
        public String getTypeName() {
            return this.myColumn.dataType;
        }

        @Override
        public String getJavaClassName() {
            return "";
        }

        @Override
        public boolean isAutogenerated() {
            return !this.myMapped && DasUtil.isAutoVal((DasColumn)this.myColumn);
        }

        @Override
        public boolean hasDefault() {
            return !this.myMapped && this.myColumn.getDefault() != null;
        }
    }

    private static class MyDelegateInputStream
    extends InputStream {
        private final InputStream myStream;
        private final Closeable myCloseable;

        private MyDelegateInputStream(@NotNull InputStream stream, @NotNull Closeable closeable) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "<init>"));
            }
            if (closeable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeable", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "<init>"));
            }
            this.myStream = stream;
            this.myCloseable = closeable;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "read"));
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream", "read"));
            }
            return this.myStream.read(b);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myCloseable.close();
        }
    }

    public static class ColumnTypePredictorInfo {
        public final ImportAction.ImportEditorContext context;
        public final ColumnDescriptor column;
        public final List<DataConsumer.Row> rows;

        public ColumnTypePredictorInfo(@NotNull ImportAction.ImportEditorContext context, @NotNull ColumnDescriptor column, @Nullable List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo", "<init>"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo", "<init>"));
            }
            this.context = context;
            this.column = column;
            this.rows = rows;
        }
    }
}

