/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.dbimport.ImportUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CsvPreviewModel {
    private static final int MAX_BYTES = 5000;
    private final byte[] myBytes;
    private Charset myCharset;
    private final VirtualFile myFile;

    public CsvPreviewModel(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/csv/CsvPreviewModel", "<init>"));
        }
        this.myBytes = CsvPreviewModel.loadBytes(file);
        this.myCharset = file.getCharset();
        this.myFile = file;
    }

    @NotNull
    public String getText() {
        String s = new String(this.myBytes, this.myCharset);
        String string = StringUtil.convertLineSeparators((String)s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvPreviewModel", "getText"));
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvPreviewModel", "getCharset"));
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/csv/CsvPreviewModel", "setCharset"));
        }
        this.myCharset = charset;
    }

    public void acceptCharset() {
        this.myFile.setCharset(this.myCharset);
    }

    private static byte[] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dbimport/csv/CsvPreviewModel", "loadBytes"));
        }
        byte[] bytes = new byte[5000];
        try (InputStream stream = ImportUtil.getInputStream(file);){
            int read = Math.max(stream.read(bytes), 0);
            byte[] byArray = Arrays.copyOf(bytes, read);
            return byArray;
        }
    }
}

