/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.hsql.HsqlDB;
import com.intellij.database.model.hsql.HsqlModDatabase;
import com.intellij.database.model.hsql.HsqlModKey;
import com.intellij.database.model.hsql.HsqlModModel;
import com.intellij.database.model.hsql.HsqlModRoot;
import com.intellij.database.model.hsql.HsqlModSchema;
import com.intellij.database.model.hsql.HsqlModTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HsqldbDialect
extends AbstractDatabaseDialect
implements DatabaseDialect,
AbstractDatabaseDialect.SplitAlterColumnSupport {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).build();
    public static final HsqldbDialect INSTANCE = new HsqldbDialect();

    protected HsqldbDialect() {
        super(META_MODEL, new TypeHelper.HSQLTypeHelper(), new KeywordHelper.HsqldbKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.HSQLDB;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Hsqldb;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("HSQLDB" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "getDisplayName"));
        }
        return "HSQLDB";
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return false;
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryData", "com/intellij/database/dialects/HsqldbDialect", "getBinaryLiteralString"));
        }
        return "x" + super.getBinaryLiteralString(binaryData);
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/HsqldbDialect", "supportsProduct"));
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("HSQL");
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "sqlDropColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/HsqldbDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/HsqldbDialect", "sqlDropTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/HsqldbDialect", "tryToLoadSearchPath"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/HsqldbDialect", "tryToLoadSearchPath"));
        }
        Map<String, Object> rs = DbImplUtil.resultRowAsMap(connection, "select current_catalog d, current_schema s from (values (1))", new String[0]);
        String d = (String)ObjectUtils.tryCast((Object)rs.get("D"), String.class);
        String s = (String)ObjectUtils.tryCast((Object)rs.get("S"), String.class);
        return StringUtil.isEmpty((String)s) || StringUtil.isEmpty((String)d) ? null : SearchPath.of(new ObjectPath(ObjectKind.SCHEMA, Arrays.asList(d, s)));
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameDatabase"));
        }
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameDatabase"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameDatabase"));
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "CATALOG").space().qualifiedRef((DasObject)database).space().keywords("RENAME", "TO").space().identifier((DasObject)database, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameDatabase"));
        }
        return ddlBuilder;
    }

    @Override
    public String sqlSetSearchPath(@NotNull DatabaseSystem system, @NotNull SearchPath path) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/HsqldbDialect", "sqlSetSearchPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/HsqldbDialect", "sqlSetSearchPath"));
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    public boolean supportsRenameDatabase() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/HsqldbDialect", "sqlAddPrimaryKey"));
        }
        DdlBuilder ddlBuilder = HsqldbDialect.getAddPrimaryKeySQL(builder, pk);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlBuilder getAddPrimaryKeySQL(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "getAddPrimaryKeySQL"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/HsqldbDialect", "getAddPrimaryKeySQL"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable()).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)pk);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "getAddPrimaryKeySQL"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnComment"));
        }
        throw new UnsupportedOperationException("HSQLDB doesn't support column comments");
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnNullable"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnNullable"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("SET").space();
        builder.keyword(!column.isNotNull() ? "NULL" : "NOT NULL");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnNullable"));
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnName"));
        }
        String alterClause = "ALTER COLUMN";
        String renameToClause = "RENAME TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, renameToClause);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnType"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnType"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnType"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder, "ALTER COLUMN", "", false, to);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnType"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnDefault"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterColumnDefault"));
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String[] getIndexStorageOptions() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumnAutoIncrement"));
        }
        builder.comment("Column must be a primary key and an integer type");
        builder.newStatement();
        DasTable tableOrig = column.getTable();
        DasTableKey pk = (DasTableKey)DialectUtils.withNewModel(HsqlDB.RDBMS, HsqlModModel.class, HsqlModRoot.class, root2 -> {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "lambda$sqlAddColumnAutoIncrement$0"));
            }
            HsqlModSchema schema = (HsqlModSchema)((HsqlModDatabase)root2.getDatabases().createOrGet(DasUtil.getCatalog((DasObject)tableOrig))).getSchemas().createOrGet(DasUtil.getSchema((DasObject)tableOrig));
            HsqlModTable table = (HsqlModTable)schema.getTables().createOrGet(column.getTableName());
            table.getColumns().createOrGet(column.getName());
            HsqlModKey key = (HsqlModKey)table.getKeys().createOrGet("PK_" + tableOrig.getName() + "_" + column.getName());
            key.setPrimary(true);
            key.setColNames(column.getName());
            return key;
        });
        HsqldbDialect.getAddPrimaryKeySQL(builder, pk);
        builder.newStatement();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)tableOrig);
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("IDENTITY");
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumnAutoIncrement"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumn"));
        }
        DialectUtils.getAddColumnSQL(builder, column, false, true, true);
        if (DasUtil.isAutoVal((DasColumn)column)) {
            builder.space().keyword("IDENTITY");
        }
        builder.newStatement();
        String defaultValue = column.getDefault();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space();
            builder.columnRef((DasObject)column);
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "SET DEFAULT");
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/HsqldbDialect", "sqlAddForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAddForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDefineForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDefineForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDefineColumn"));
        }
        super.sqlDefineColumn(builder, column, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoVal((DasColumn)column) ? builder.space().keyword("IDENTITY") : builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/HsqldbDialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/HsqldbDialect", "sqlAddUniqueConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/HsqldbDialect", "sqlAddUniqueConstraint"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(constraint, constraintName).space();
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        DdlBuilder ddlBuilder = DialectUtils.alterSequenceSQL(builder, sequence, "", restart);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlAlterSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateIndex"));
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        builder.keywords("CREATE", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence);
        if (!start.isEmpty()) {
            builder.space().keyword("START WITH").space();
            builder.literal(start);
        }
        if (!increment.isEmpty()) {
            builder.space().keyword("INCREMENT BY").space();
            builder.literal(increment);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view2, definition, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/HsqldbDialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/HsqldbDialect", "sqlDropConstraint"));
        }
        DdlBuilder.Marker m = builder.mark();
        DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        m.replace(DialectUtils.stripQuotesFromIdentifier(this, constraintName, m.extract()));
        m.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDropConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/HsqldbDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/HsqldbDialect", "sqlDropIndex"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "INDEX").space().identifier((DasObject)index, indexName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/HsqldbDialect", "sqlDropSequence"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDropSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlDropView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/HsqldbDialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "VIEW").space().qualifiedRef((DasObject)view2);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameTable"));
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)table).space().keywords("RENAME", "TO").space().identifier((DasObject)table, newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameView"));
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view2, newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlRenameView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/HsqldbDialect", "sqlSequenceInformation"));
        }
        builder.keyword("SELECT").space();
        builder.ref(null, "START_WITH").space().keyword("AS").space().plain("LAST_VALUE").symbol(",").space();
        builder.ref(null, "MAXIMUM_VALUE").symbol(",").space();
        builder.ref(null, "MINIMUM_VALUE").symbol(",").space();
        builder.literal("0").space().keyword("AS").space().plain("CACHE_VALUE").symbol(",").space();
        builder.ref(null, "INCREMENT").symbol(",").space();
        builder.keyword("case").space().ref(null, "INCREMENT").space().keyword("when").space().literal("'NO'").space().keyword("then").space().literal("0").space().keyword("else").space().literal("1").space().keyword("end").space().keyword("as").space().plain("INCREMENT_BY").space();
        builder.keyword("FROM").space().ref(null, "INFORMATION_SCHEMA.SYSTEM_SEQUENCES").space();
        builder.keyword("WHERE").space().ref(null, "SEQUENCE_SCHEMA").space().symbol("=").space().literal("'" + DasUtil.getSchema((DasObject)sequence) + "'").space().keyword("AND").space().ref(null, "SEQUENCE_NAME").space().symbol("=").space().literal("'" + sequence.getName() + "'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlSequenceInformation"));
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/HsqldbDialect", "sqlViewDefinition"));
        }
        String templateStr = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = ''{0}'' and TABLE_SCHEMA = ''{1}'' ";
        return Pair.create((Object)MessageFormat.format(templateStr, element.getName(), DasUtil.getSchema((DasObject)element)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/HsqldbDialect", "sqlProcedureDefinition"));
        }
        String templateStr = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = ''{0}'' and ROUTINE_SCHEMA = ''{1}'' ";
        Pair pair = Pair.create((Object)MessageFormat.format(templateStr, element.getName(), DasUtil.getSchema((DasObject)element)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/HsqldbDialect", "isValidPlainIdentifier"));
        }
        char c0 = identifier.charAt(0);
        if (!Character.isLetter(c0) && c0 != '$' && c0 != '#') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/HsqldbDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/HsqldbDialect", "qualifiedIdentifier"));
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/HsqldbDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/HsqldbDialect", "sqlExplainPlan"));
        }
        if (analyze) {
            throw new UnsupportedOperationException("HSQLDB does not support EXPLAIN ANALYZE");
        }
        builder.keywords("explain", "plan", "for").space();
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/HsqldbDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }
}

