/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.scripting.SqlWords;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class KeywordHelper {
    private Set<String> myReservedKeywords = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);

    public boolean isReservedKeyword(String text) {
        return this.myReservedKeywords.contains(text);
    }

    protected void addKeywords(String ... text) {
        this.myReservedKeywords.addAll(Arrays.asList(text));
    }

    protected void addKeywords(@NotNull Collection<String> words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/database/dialects/KeywordHelper", "addKeywords"));
        }
        this.myReservedKeywords.addAll(words);
    }

    public static class MssqlKeywords
    extends KeywordHelper {
        public MssqlKeywords() {
            this.addKeywords(SqlWords.MS_SQL_KEY_WORDS);
        }
    }

    public static class SybaseKeywords
    extends KeywordHelper {
        public SybaseKeywords() {
            this.addKeywords(SqlWords.SYBASE_KEY_WORDS);
        }
    }

    public static class SqliteKeywords
    extends KeywordHelper {
        public SqliteKeywords() {
            this.addKeywords(SqlWords.SQLITE_KEY_WORDS);
        }
    }

    public static class PostgresKeywords
    extends KeywordHelper {
        public PostgresKeywords() {
            this.addKeywords(SqlWords.POSTGRES_KEY_WORDS);
        }
    }

    public static class OracleKeywords
    extends KeywordHelper {
        public OracleKeywords() {
            this.addKeywords(SqlWords.ORACLE_KEY_WORDS);
        }
    }

    public static class MysqlKeywords
    extends KeywordHelper {
        public MysqlKeywords() {
            this.addKeywords(SqlWords.MYSQL_KEY_WORDS);
        }
    }

    public static class HsqldbKeywords
    extends KeywordHelper {
        public HsqldbKeywords() {
            this.addKeywords(SqlWords.HSQL_KEY_WORDS);
        }
    }

    public static class H2Keywords
    extends KeywordHelper {
        public H2Keywords() {
            this.addKeywords(SqlWords.H2_KEY_WORDS);
        }
    }

    public static class GenericKeywords
    extends KeywordHelper {
        public GenericKeywords() {
            this.addKeywords("ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE");
        }
    }

    public static class DerbyKeywords
    extends KeywordHelper {
        public DerbyKeywords() {
            this.addKeywords(SqlWords.DERBY_KEY_WORDS);
        }
    }

    public static class Db2Keywords
    extends KeywordHelper {
        public Db2Keywords() {
            this.addKeywords(new String[0]);
        }
    }
}

