/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DbDiffCheckOption;
import com.intellij.database.diff.DbDiffElement;
import com.intellij.database.diff.DbMigrationAction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareDbElementsAction
extends DumbAwareAction {
    public CompareDbElementsAction() {
        super("Compare", null, AllIcons.Actions.Diff);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = CompareDbElementsAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.customSettings.put("IGNORE_ORDER", true);
        settings.customSettings.put("IGNORE_CASE", true);
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_ORDER", "Ignore &order", "alt O"));
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_CASE", "Ignore &case", "alt C"));
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.diff");
        Pair<DbDiffElement, DbDiffElement> pair = CompareDbElementsAction.getElements(e);
        assert (pair != null);
        ((DbDiffElement)((Object)pair.first)).setSettings(settings);
        ((DbDiffElement)((Object)pair.second)).setSettings(settings);
        DirDiffManager.getInstance((Project)project).showDiff((DiffElement)pair.first, (DiffElement)pair.second, settings, null);
    }

    @Nullable
    public static Pair<DbDiffElement, DbDiffElement> getElements(AnActionEvent e) {
        DbElement e2;
        DbElement e1;
        block5: {
            DbElement same;
            PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
            if (elements == null || elements.length != 2 || !(elements[0] instanceof DbElement) || !(elements[1] instanceof DbElement)) {
                return null;
            }
            e1 = (DbElement)elements[0];
            e2 = (DbElement)elements[1];
            HashMap possible1 = ContainerUtil.newHashMap();
            HashMap possible2 = ContainerUtil.newHashMap();
            e1 = CompareDbElementsAction.fillPossible(e1, possible1);
            e2 = CompareDbElementsAction.fillPossible(e2, possible2);
            while ((same = (DbElement)possible2.get(e1.getKind())) == null) {
                DbElement p = e1.getDbParent();
                if (p != null && possible1.containsKey(p.getKind())) {
                    e1 = p;
                    continue;
                }
                break block5;
            }
            e2 = same;
        }
        if (e1.getKind() != e2.getKind()) {
            return null;
        }
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        return Pair.create((Object)((Object)new DbDiffElement(e1)), (Object)((Object)new DbDiffElement(e2)));
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(CompareDbElementsAction.getEventProject((AnActionEvent)e) != null && CompareDbElementsAction.getElements(e) != null);
    }

    private static DbElement fillPossible(@NotNull DbElement el, @NotNull Map<ObjectKind, DbElement> pos) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/database/diff/CompareDbElementsAction", "fillPossible"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/database/diff/CompareDbElementsAction", "fillPossible"));
        }
        if (DasUtil.getParentOfKind((DasObject)el, (ObjectKind)ObjectKind.SCHEMA, (boolean)true) == null) {
            DbElement tmp = el;
            while (tmp != null) {
                pos.put(tmp.getKind(), tmp);
                el = tmp;
                tmp = tmp.getKind() == ObjectKind.SCHEMA ? null : CompareDbElementsAction.singleChild(tmp);
            }
            return el;
        }
        pos.put(el.getKind(), el);
        return el;
    }

    @Nullable
    private static DbElement singleChild(@NotNull DbElement el) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/database/diff/CompareDbElementsAction", "singleChild"));
        }
        Iterator it = el.getDbChildren(DbElement.class, ObjectKind.NONE).iterator();
        if (!it.hasNext()) {
            return null;
        }
        DbElement candidate = (DbElement)it.next();
        return it.hasNext() ? null : candidate;
    }
}

